/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.Enumeration;
import weka.classifiers.Classifier;
import weka.classifiers.Sourcable;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class ZeroR
extends Classifier
implements WeightedInstancesHandler,
Sourcable {
    static final long serialVersionUID = 48055541465867954L;
    private double m_ClassValue;
    private double[] m_Counts;
    private Attribute m_Class;

    public String globalInfo() {
        return "Class for building and using a 0-R classifier. Predicts the mean (for a numeric class) or the mode (for a nominal class).";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        double d = 0.0;
        this.m_Class = instances.classAttribute();
        this.m_ClassValue = 0.0;
        switch (instances.classAttribute().type()) {
            case 0: {
                this.m_Counts = null;
                break;
            }
            case 1: {
                this.m_Counts = new double[instances.numClasses()];
                for (int i = 0; i < this.m_Counts.length; ++i) {
                    this.m_Counts[i] = 1.0;
                }
                d = instances.numClasses();
            }
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (instance.classIsMissing()) continue;
            if (instances.classAttribute().isNominal()) {
                int n = (int)instance.classValue();
                this.m_Counts[n] = this.m_Counts[n] + instance.weight();
            } else {
                this.m_ClassValue += instance.weight() * instance.classValue();
            }
            d += instance.weight();
        }
        if (instances.classAttribute().isNumeric()) {
            if (Utils.gr(d, 0.0)) {
                this.m_ClassValue /= d;
            }
        } else {
            this.m_ClassValue = Utils.maxIndex(this.m_Counts);
            Utils.normalize(this.m_Counts, d);
        }
    }

    public double classifyInstance(Instance instance) {
        return this.m_ClassValue;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_Counts == null) {
            double[] dArray = new double[]{this.m_ClassValue};
            return dArray;
        }
        return (double[])this.m_Counts.clone();
    }

    public String toSource(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class " + string + " {\n");
        stringBuffer.append("  public static double classify(Object[] i) {\n");
        if (this.m_Counts != null) {
            stringBuffer.append("    // always predicts label '" + this.m_Class.value((int)this.m_ClassValue) + "'\n");
        }
        stringBuffer.append("    return " + this.m_ClassValue + ";\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.m_Class == null) {
            return "ZeroR: No model built yet.";
        }
        if (this.m_Counts == null) {
            return "ZeroR predicts class value: " + this.m_ClassValue;
        }
        return "ZeroR predicts class value: " + this.m_Class.value((int)this.m_ClassValue);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.19 $");
    }

    public static void main(String[] stringArray) {
        ZeroR.runClassifier(new ZeroR(), stringArray);
    }
}

