/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Drawable;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XStream;
import weka.experiment.Task;
import weka.experiment.TaskStatusInfo;
import weka.gui.ExtensionFileFilter;
import weka.gui.Logger;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.SerializedModelSaver;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Classifier
extends JPanel
implements BeanCommon,
Visible,
WekaWrapper,
EventConstraints,
Serializable,
UserRequestAcceptor,
TrainingSetListener,
TestSetListener,
InstanceListener {
    private static final long serialVersionUID = 659603893917736008L;
    protected BeanVisual m_visual = new BeanVisual("Classifier", "weka/gui/beans/icons/DefaultClassifier.gif", "weka/gui/beans/icons/DefaultClassifier_animated.gif");
    private static int IDLE = 0;
    private static int BUILDING_MODEL = 1;
    private static int CLASSIFYING = 2;
    private int m_state = IDLE;
    protected String m_globalInfo;
    private Hashtable m_listenees = new Hashtable();
    private Vector m_batchClassifierListeners = new Vector();
    private Vector m_incrementalClassifierListeners = new Vector();
    private Vector m_graphListeners = new Vector();
    private Vector m_textListeners = new Vector();
    private Instances m_trainingSet;
    private transient Instances m_testingSet;
    private weka.classifiers.Classifier m_Classifier = new ZeroR();
    private IncrementalClassifierEvent m_ie = new IncrementalClassifierEvent(this);
    public static final String FILE_EXTENSION = "model";
    private transient JFileChooser m_fileChooser = null;
    protected FileFilter m_binaryFilter = new ExtensionFileFilter(".model", "Binary serialized model file (*model)");
    protected FileFilter m_KOMLFilter = new ExtensionFileFilter(".komlmodel", "XML serialized model file (*.komlmodel)");
    protected FileFilter m_XStreamFilter = new ExtensionFileFilter(".xstreammodel", "XML serialized model file (*.xstreammodel)");
    private boolean m_updateIncrementalClassifier = true;
    private transient Logger m_log = null;
    private InstanceEvent m_incrementalEvent;
    protected int m_executionSlots = 2;
    protected transient ThreadPoolExecutor m_executorPool;
    protected transient BatchClassifierEvent[][] m_outputQueues;
    protected String m_oldText = "";
    protected boolean m_block = false;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Classifier() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.setClassifier(this.m_Classifier);
    }

    private void startExecutorPool() {
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
        }
        this.m_executorPool = new ThreadPoolExecutor(this.m_executionSlots, this.m_executionSlots, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    protected void setupFileChooser() {
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        }
        this.m_fileChooser.addChoosableFileFilter(this.m_binaryFilter);
        if (KOML.isPresent()) {
            this.m_fileChooser.addChoosableFileFilter(this.m_KOMLFilter);
        }
        if (XStream.isPresent()) {
            this.m_fileChooser.addChoosableFileFilter(this.m_XStreamFilter);
        }
        this.m_fileChooser.setFileFilter(this.m_binaryFilter);
    }

    public int getExecutionSlots() {
        return this.m_executionSlots;
    }

    public void setExecutionSlots(int n) {
        this.m_executionSlots = n;
    }

    public void setClassifier(weka.classifiers.Classifier classifier) {
        boolean bl = true;
        if (classifier.getClass().getName().compareTo(this.m_Classifier.getClass().getName()) == 0) {
            bl = false;
        } else {
            this.m_trainingSet = null;
        }
        this.m_Classifier = classifier;
        String string = classifier.getClass().toString();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (bl && !this.m_visual.loadIcons("weka/gui/beans/icons/" + string + ".gif", "weka/gui/beans/icons/" + string + "_animated.gif")) {
            this.useDefaultVisual();
        }
        this.m_visual.setText(string);
        if (!(this.m_Classifier instanceof UpdateableClassifier) && this.m_listenees.containsKey("instance") && this.m_log != null) {
            this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + " WARNING : " + this.getCustomName() + " is not an incremental classifier");
        }
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Classifier);
    }

    public boolean hasIncomingStreamInstances() {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        return this.m_listenees.containsKey("instance");
    }

    public boolean hasIncomingBatchInstances() {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        return this.m_listenees.containsKey("trainingSet") || this.m_listenees.containsKey("testSet");
    }

    public weka.classifiers.Classifier getClassifier() {
        return this.m_Classifier;
    }

    public void setWrappedAlgorithm(Object object) {
        if (!(object instanceof weka.classifiers.Classifier)) {
            throw new IllegalArgumentException(object.getClass() + " : incorrect " + "type of algorithm (Classifier)");
        }
        this.setClassifier((weka.classifiers.Classifier)object);
    }

    public Object getWrappedAlgorithm() {
        return this.getClassifier();
    }

    public boolean getUpdateIncrementalClassifier() {
        return this.m_updateIncrementalClassifier;
    }

    public void setUpdateIncrementalClassifier(boolean bl) {
        this.m_updateIncrementalClassifier = bl;
    }

    public void acceptInstance(InstanceEvent instanceEvent) {
        this.m_incrementalEvent = instanceEvent;
        this.handleIncrementalEvent();
    }

    private void handleIncrementalEvent() {
        if (this.m_executorPool != null && (this.m_executorPool.getQueue().size() > 0 || this.m_executorPool.getActiveCount() > 0)) {
            String string = "[Classifier] " + this.statusMessagePrefix() + " is currently batch training!";
            if (this.m_log != null) {
                this.m_log.logMessage(string);
                this.m_log.statusMessage(this.statusMessagePrefix() + "WARNING: " + "Can't accept instance - batch training in progress.");
            } else {
                System.err.println(string);
            }
            return;
        }
        if (this.m_incrementalEvent.getStatus() == 0) {
            Instances instances = this.m_incrementalEvent.getStructure();
            if (instances.classIndex() < 0) {
                instances.setClassIndex(instances.numAttributes() - 1);
            }
            try {
                if (this.m_trainingSet == null || !instances.equalHeaders(this.m_trainingSet)) {
                    if (!(this.m_Classifier instanceof UpdateableClassifier)) {
                        this.stop();
                        if (this.m_log != null) {
                            String string = this.m_trainingSet == null ? this.statusMessagePrefix() + "ERROR: classifier has not been batch " + "trained; can't process instance events." : this.statusMessagePrefix() + "ERROR: instance event's structure is different from " + "the data that " + "was used to batch train this classifier; can't continue.";
                            this.m_log.logMessage("[Classifier] " + string);
                            this.m_log.statusMessage(string);
                        }
                        return;
                    }
                    if (this.m_trainingSet != null && !instances.equalHeaders(this.m_trainingSet)) {
                        if (this.m_log != null) {
                            String string = this.statusMessagePrefix() + " WARNING : structure of instance events differ " + "from data used in batch training this " + "classifier. Resetting classifier...";
                            this.m_log.logMessage("[Classifier] " + string);
                            this.m_log.statusMessage(string);
                        }
                        this.m_trainingSet = null;
                    }
                    if (this.m_trainingSet == null) {
                        this.m_trainingSet = new Instances(instances, 0);
                        this.m_Classifier.buildClassifier(this.m_trainingSet);
                    }
                }
            }
            catch (Exception exception) {
                this.stop();
                if (this.m_log != null) {
                    this.m_log.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
                    this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + " problem during incremental processing. " + exception.getMessage());
                }
                exception.printStackTrace();
            }
            System.err.println("NOTIFYING NEW BATCH");
            this.m_ie.setStructure(instances);
            this.m_ie.setClassifier(this.m_Classifier);
            this.notifyIncrementalClassifierListeners(this.m_ie);
            return;
        }
        if (this.m_trainingSet == null) {
            return;
        }
        try {
            if (this.m_incrementalEvent.getInstance().dataset().classIndex() < 0) {
                this.m_incrementalEvent.getInstance().dataset().setClassIndex(this.m_incrementalEvent.getInstance().dataset().numAttributes() - 1);
            }
            int n = 1;
            if (this.m_incrementalEvent.getStatus() == 2) {
                n = 2;
            }
            this.m_ie.setStatus(n);
            this.m_ie.setClassifier(this.m_Classifier);
            this.m_ie.setCurrentInstance(this.m_incrementalEvent.getInstance());
            this.notifyIncrementalClassifierListeners(this.m_ie);
            if (this.m_Classifier instanceof UpdateableClassifier && this.m_updateIncrementalClassifier && !this.m_incrementalEvent.getInstance().isMissing(this.m_incrementalEvent.getInstance().dataset().classIndex())) {
                ((UpdateableClassifier)((Object)this.m_Classifier)).updateClassifier(this.m_incrementalEvent.getInstance());
            }
            if (this.m_incrementalEvent.getStatus() == 2 && this.m_textListeners.size() > 0) {
                String string = this.m_Classifier.toString();
                String string2 = this.m_Classifier.getClass().getName();
                string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
                string = "=== Classifier model ===\n\nScheme:   " + string2 + "\n" + "Relation: " + this.m_trainingSet.relationName() + "\n\n" + string;
                string2 = "Model: " + string2;
                TextEvent textEvent = new TextEvent(this, string, string2);
                this.notifyTextListeners(textEvent);
            }
        }
        catch (Exception exception) {
            this.stop();
            if (this.m_log != null) {
                this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + exception.getMessage());
                this.m_log.statusMessage(this.statusMessagePrefix() + "ERROR (see log for details)");
                exception.printStackTrace();
            }
            exception.printStackTrace();
        }
    }

    public void acceptTrainingSet(TrainingSetEvent trainingSetEvent) {
        Object object;
        if (trainingSetEvent.isStructureOnly()) {
            BatchClassifierEvent batchClassifierEvent = new BatchClassifierEvent(this, this.m_Classifier, new DataSetEvent(this, trainingSetEvent.getTrainingSet()), new DataSetEvent(this, trainingSetEvent.getTrainingSet()), trainingSetEvent.getSetNumber(), trainingSetEvent.getMaxSetNumber());
            this.notifyBatchClassifierListeners(batchClassifierEvent);
            return;
        }
        if (this.m_block) {
            if (this.m_log != null) {
                this.m_log.statusMessage(this.statusMessagePrefix() + "BUSY. Can't accept data " + "at this time.");
                this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + " BUSY. Can't accept data at this time.");
            }
            return;
        }
        if (trainingSetEvent.getRunNumber() == 1 && trainingSetEvent.getSetNumber() == 1) {
            object = "[Classifier] " + this.statusMessagePrefix() + " starting executor pool (" + this.getExecutionSlots() + " slots)...";
            if (this.m_log != null) {
                this.m_log.logMessage((String)object);
            } else {
                System.err.println((String)object);
            }
            this.startExecutorPool();
            object = "[Classifier] " + this.statusMessagePrefix() + " setup output queues.";
            if (this.m_log != null) {
                this.m_log.logMessage((String)object);
            } else {
                System.err.println((String)object);
            }
            this.m_outputQueues = new BatchClassifierEvent[trainingSetEvent.getMaxRunNumber()][trainingSetEvent.getMaxSetNumber()];
        }
        object = new TrainingTask(trainingSetEvent.getRunNumber(), trainingSetEvent.getMaxRunNumber(), trainingSetEvent.getSetNumber(), trainingSetEvent.getMaxSetNumber(), trainingSetEvent.getTrainingSet());
        String string = "[Classifier] " + this.statusMessagePrefix() + " scheduling run " + trainingSetEvent.getRunNumber() + " fold " + trainingSetEvent.getSetNumber() + " for execution...";
        if (this.m_log != null) {
            this.m_log.logMessage(string);
        } else {
            System.err.println(string);
        }
        this.m_executorPool.execute((Runnable)object);
        if (trainingSetEvent.getRunNumber() == trainingSetEvent.getMaxRunNumber() && trainingSetEvent.getSetNumber() == trainingSetEvent.getMaxSetNumber()) {
            this.m_block = true;
        }
    }

    public synchronized void acceptTestSet(TestSetEvent testSetEvent) {
        if (!this.m_listenees.containsKey("trainingSet")) {
            Instances instances = testSetEvent.getTestSet();
            if (instances != null) {
                if (instances.classIndex() < 0) {
                    instances.setClassIndex(instances.numAttributes() - 1);
                }
                if (this.m_trainingSet.equalHeaders(instances)) {
                    BatchClassifierEvent batchClassifierEvent = new BatchClassifierEvent(this, this.m_Classifier, new DataSetEvent(this, this.m_trainingSet), new DataSetEvent(this, testSetEvent.getTestSet()), testSetEvent.getRunNumber(), testSetEvent.getMaxRunNumber(), testSetEvent.getSetNumber(), testSetEvent.getMaxSetNumber());
                    this.notifyBatchClassifierListeners(batchClassifierEvent);
                }
            }
        } else if (this.m_outputQueues[testSetEvent.getRunNumber() - 1][testSetEvent.getSetNumber() - 1] == null) {
            this.m_outputQueues[testSetEvent.getRunNumber() - 1][testSetEvent.getSetNumber() - 1] = new BatchClassifierEvent(this, null, null, new DataSetEvent(this, testSetEvent.getTestSet()), testSetEvent.getRunNumber(), testSetEvent.getMaxRunNumber(), testSetEvent.getSetNumber(), testSetEvent.getMaxSetNumber());
        } else {
            this.m_outputQueues[testSetEvent.getRunNumber() - 1][testSetEvent.getSetNumber() - 1].setTestSet(new DataSetEvent(this, testSetEvent.getTestSet()));
            this.checkCompletedRun(testSetEvent.getRunNumber(), testSetEvent.getMaxSetNumber());
        }
    }

    private synchronized void classifierTrainingComplete(BatchClassifierEvent batchClassifierEvent) {
        if (this.m_listenees.containsKey("testSet")) {
            String string = "[Classifier] " + this.statusMessagePrefix() + " storing model for run " + batchClassifierEvent.getRunNumber() + " fold " + batchClassifierEvent.getSetNumber();
            if (this.m_log != null) {
                this.m_log.logMessage(string);
            } else {
                System.err.println(string);
            }
            if (this.m_outputQueues[batchClassifierEvent.getRunNumber() - 1][batchClassifierEvent.getSetNumber() - 1] == null) {
                this.m_outputQueues[batchClassifierEvent.getRunNumber() - 1][batchClassifierEvent.getSetNumber() - 1] = batchClassifierEvent;
            } else {
                this.m_outputQueues[batchClassifierEvent.getRunNumber() - 1][batchClassifierEvent.getSetNumber() - 1].setClassifier(batchClassifierEvent.getClassifier());
                this.m_outputQueues[batchClassifierEvent.getRunNumber() - 1][batchClassifierEvent.getSetNumber() - 1].setTrainSet(batchClassifierEvent.getTrainSet());
            }
        }
        this.checkCompletedRun(batchClassifierEvent.getRunNumber(), batchClassifierEvent.getMaxSetNumber());
    }

    private synchronized void checkCompletedRun(int n, int n2) {
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            if (this.m_outputQueues[n - 1][i] == null) {
                bl = false;
                break;
            }
            if (this.m_outputQueues[n - 1][i].getClassifier() != null && this.m_outputQueues[n - 1][i].getTestSet() != null) continue;
            bl = false;
            break;
        }
        if (bl) {
            String string = "[Classifier] " + this.statusMessagePrefix() + " dispatching run " + n + " to listeners.";
            if (this.m_log != null) {
                this.m_log.logMessage(string);
            } else {
                System.err.println(string);
            }
            for (int i = 0; i < n2; ++i) {
                this.notifyBatchClassifierListeners(this.m_outputQueues[n - 1][i]);
                this.m_outputQueues[n - 1][i] = null;
            }
        }
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        String string = this.m_Classifier.getClass().toString();
        String string2 = string.substring(0, string.lastIndexOf(46));
        string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
        if (!this.m_visual.loadIcons("weka/gui/beans/icons/Default_" + string2 + "Classifier.gif", "weka/gui/beans/icons/Default_" + string2 + "Classifier_animated.gif")) {
            this.m_visual.loadIcons("weka/gui/beans/icons/DefaultClassifier.gif", "weka/gui/beans/icons/DefaultClassifier_animated.gif");
        }
    }

    public synchronized void addBatchClassifierListener(BatchClassifierListener batchClassifierListener) {
        this.m_batchClassifierListeners.addElement(batchClassifierListener);
    }

    public synchronized void removeBatchClassifierListener(BatchClassifierListener batchClassifierListener) {
        this.m_batchClassifierListeners.remove(batchClassifierListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatchClassifierListeners(BatchClassifierEvent batchClassifierEvent) {
        Vector vector;
        Classifier classifier = this;
        synchronized (classifier) {
            vector = (Vector)this.m_batchClassifierListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((BatchClassifierListener)vector.elementAt(i)).acceptClassifier(batchClassifierEvent);
            }
        }
    }

    public synchronized void addGraphListener(GraphListener graphListener) {
        this.m_graphListeners.addElement(graphListener);
    }

    public synchronized void removeGraphListener(GraphListener graphListener) {
        this.m_graphListeners.remove(graphListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGraphListeners(GraphEvent graphEvent) {
        Vector vector;
        Classifier classifier = this;
        synchronized (classifier) {
            vector = (Vector)this.m_graphListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((GraphListener)vector.elementAt(i)).acceptGraph(graphEvent);
            }
        }
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.m_textListeners.addElement(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.m_textListeners.remove(textListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent textEvent) {
        Vector vector;
        Classifier classifier = this;
        synchronized (classifier) {
            vector = (Vector)this.m_textListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TextListener)vector.elementAt(i)).acceptText(textEvent);
            }
        }
    }

    public synchronized void addIncrementalClassifierListener(IncrementalClassifierListener incrementalClassifierListener) {
        this.m_incrementalClassifierListeners.add(incrementalClassifierListener);
    }

    public synchronized void removeIncrementalClassifierListener(IncrementalClassifierListener incrementalClassifierListener) {
        this.m_incrementalClassifierListeners.remove(incrementalClassifierListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIncrementalClassifierListeners(IncrementalClassifierEvent incrementalClassifierEvent) {
        Vector vector;
        Classifier classifier = this;
        synchronized (classifier) {
            vector = (Vector)this.m_incrementalClassifierListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((IncrementalClassifierListener)vector.elementAt(i)).acceptClassifier(incrementalClassifierEvent);
            }
        }
    }

    public boolean connectionAllowed(String string) {
        return !this.m_listenees.containsKey(string);
    }

    public boolean connectionAllowed(EventSetDescriptor eventSetDescriptor) {
        return this.connectionAllowed(eventSetDescriptor.getName());
    }

    public synchronized void connectionNotification(String string, Object object) {
        if (string.compareTo("instance") == 0 && !(this.m_Classifier instanceof UpdateableClassifier) && this.m_log != null) {
            String string2 = this.statusMessagePrefix() + "WARNING: " + " Is not an updateable classifier. This " + "classifier will only be evaluated on incoming " + "instance events and not trained on them.";
            this.m_log.logMessage("[Classifier] " + string2);
            this.m_log.statusMessage(string2);
        }
        if (this.connectionAllowed(string)) {
            this.m_listenees.put(string, object);
        }
    }

    public synchronized void disconnectionNotification(String string, Object object) {
        this.m_listenees.remove(string);
        if (string.compareTo("instance") == 0) {
            this.stop();
        }
    }

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public void stop() {
        Enumeration enumeration = this.m_listenees.keys();
        while (enumeration.hasMoreElements()) {
            Object v = this.m_listenees.get(enumeration.nextElement());
            if (!(v instanceof BeanCommon)) continue;
            ((BeanCommon)v).stop();
        }
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
            this.m_executorPool.purge();
        }
        this.m_block = false;
        this.m_visual.setStatic();
        if (this.m_oldText.length() > 0) {
            // empty if block
        }
    }

    public void loadModel() {
        block19: {
            try {
                int n;
                if (this.m_fileChooser == null) {
                    this.setupFileChooser();
                }
                if ((n = this.m_fileChooser.showOpenDialog(this)) != 0) break block19;
                File file = this.m_fileChooser.getSelectedFile();
                if (this.m_fileChooser.getFileFilter() == this.m_binaryFilter) {
                    if (!file.getName().toLowerCase().endsWith(".model")) {
                        file = new File(file.getParent(), file.getName() + "." + FILE_EXTENSION);
                    }
                } else if (this.m_fileChooser.getFileFilter() == this.m_KOMLFilter) {
                    if (!file.getName().toLowerCase().endsWith(".komlmodel")) {
                        file = new File(file.getParent(), file.getName() + ".koml" + FILE_EXTENSION);
                    }
                } else if (this.m_fileChooser.getFileFilter() == this.m_XStreamFilter && !file.getName().toLowerCase().endsWith(".xstreammodel")) {
                    file = new File(file.getParent(), file.getName() + ".xstream" + FILE_EXTENSION);
                }
                weka.classifiers.Classifier classifier = null;
                Instances instances = null;
                if (KOML.isPresent() && file.getAbsolutePath().toLowerCase().endsWith(".komlmodel")) {
                    Vector vector = (Vector)KOML.read(file.getAbsolutePath());
                    classifier = (weka.classifiers.Classifier)vector.elementAt(0);
                    if (vector.size() == 2) {
                        instances = (Instances)vector.elementAt(1);
                    }
                } else if (XStream.isPresent() && file.getAbsolutePath().toLowerCase().endsWith(".xstreammodel")) {
                    Vector vector = (Vector)XStream.read(file.getAbsolutePath());
                    classifier = (weka.classifiers.Classifier)vector.elementAt(0);
                    if (vector.size() == 2) {
                        instances = (Instances)vector.elementAt(1);
                    }
                } else {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                    classifier = (weka.classifiers.Classifier)objectInputStream.readObject();
                    try {
                        instances = (Instances)objectInputStream.readObject();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    objectInputStream.close();
                }
                this.setClassifier(classifier);
                this.m_trainingSet = instances;
                if (this.m_log != null) {
                    this.m_log.logMessage("[Classifier] Loaded classifier: " + this.m_Classifier.getClass().toString());
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Problem loading classifier.\n", "Load Model", 0);
                if (this.m_log == null) break block19;
                this.m_log.logMessage("[Classifier] Problem loading classifier. " + exception.getMessage());
            }
        }
    }

    public void saveModel() {
        block17: {
            try {
                int n;
                if (this.m_fileChooser == null) {
                    this.setupFileChooser();
                }
                if ((n = this.m_fileChooser.showSaveDialog(this)) == 0) {
                    File file = this.m_fileChooser.getSelectedFile();
                    String string = file.getAbsolutePath();
                    if (this.m_fileChooser.getFileFilter() == this.m_binaryFilter) {
                        if (!string.toLowerCase().endsWith(".model")) {
                            string = string + ".model";
                        }
                    } else if (this.m_fileChooser.getFileFilter() == this.m_KOMLFilter) {
                        if (!string.toLowerCase().endsWith(".komlmodel")) {
                            string = string + ".komlmodel";
                        }
                    } else if (this.m_fileChooser.getFileFilter() == this.m_XStreamFilter && !string.toLowerCase().endsWith(".xstreammodel")) {
                        string = string + ".xstreammodel";
                    }
                    file = new File(string);
                    if (KOML.isPresent() && file.getAbsolutePath().toLowerCase().endsWith(".komlmodel")) {
                        SerializedModelSaver.saveKOML(file, this.m_Classifier, this.m_trainingSet != null ? new Instances(this.m_trainingSet, 0) : null);
                    } else if (XStream.isPresent() && file.getAbsolutePath().toLowerCase().endsWith(".xstreammodel")) {
                        SerializedModelSaver.saveXStream(file, this.m_Classifier, this.m_trainingSet != null ? new Instances(this.m_trainingSet, 0) : null);
                    } else {
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                        objectOutputStream.writeObject(this.m_Classifier);
                        if (this.m_trainingSet != null) {
                            Instances instances = new Instances(this.m_trainingSet, 0);
                            objectOutputStream.writeObject(instances);
                        }
                        objectOutputStream.close();
                    }
                    if (this.m_log != null) {
                        this.m_log.logMessage("[Classifier] Saved classifier " + this.getCustomName());
                    }
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Problem saving classifier.\n", "Save Model", 0);
                if (this.m_log == null) break block17;
                this.m_log.logMessage("[Classifier] Problem saving classifier " + this.getCustomName() + exception.getMessage());
            }
        }
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_executorPool != null && (this.m_executorPool.getQueue().size() > 0 || this.m_executorPool.getActiveCount() > 0)) {
            vector.addElement("Stop");
        }
        if ((this.m_executorPool == null || this.m_executorPool.getQueue().size() == 0 && this.m_executorPool.getActiveCount() == 0) && this.m_Classifier != null) {
            vector.addElement("Save model");
        }
        if (this.m_executorPool == null || this.m_executorPool.getQueue().size() == 0 && this.m_executorPool.getActiveCount() == 0) {
            vector.addElement("Load model");
        }
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Stop") == 0) {
            this.stop();
        } else if (string.compareTo("Save model") == 0) {
            this.saveModel();
        } else if (string.compareTo("Load model") == 0) {
            this.loadModel();
        } else {
            throw new IllegalArgumentException(string + " not supported (Classifier)");
        }
    }

    public boolean eventGeneratable(EventSetDescriptor eventSetDescriptor) {
        String string = eventSetDescriptor.getName();
        return this.eventGeneratable(string);
    }

    private boolean generatableEvent(String string) {
        return string.compareTo("graph") == 0 || string.compareTo("text") == 0 || string.compareTo("batchClassifier") == 0 || string.compareTo("incrementalClassifier") == 0;
    }

    public boolean eventGeneratable(String string) {
        Object v;
        if (!this.generatableEvent(string)) {
            return false;
        }
        if (string.compareTo("graph") == 0) {
            if (!(this.m_Classifier instanceof Drawable)) {
                return false;
            }
            if (!this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            v = this.m_listenees.get("trainingSet");
            if (v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (string.compareTo("batchClassifier") == 0) {
            if (!this.m_listenees.containsKey("testSet") && !this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            v = this.m_listenees.get("testSet");
            if (v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("testSet")) {
                return false;
            }
        }
        if (string.compareTo("text") == 0) {
            if (!this.m_listenees.containsKey("trainingSet") && !this.m_listenees.containsKey("instance")) {
                return false;
            }
            v = this.m_listenees.get("trainingSet");
            if (v != null && v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("trainingSet")) {
                return false;
            }
            v = this.m_listenees.get("instance");
            if (v != null && v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("instance")) {
                return false;
            }
        }
        if (string.compareTo("incrementalClassifier") == 0) {
            if (!this.m_listenees.containsKey("instance")) {
                return false;
            }
            v = this.m_listenees.get("instance");
            if (v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("instance")) {
                return false;
            }
        }
        return true;
    }

    public boolean isBusy() {
        return this.m_executorPool != null && (this.m_executorPool.getQueue().size() != 0 || this.m_executorPool.getActiveCount() != 0);
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|" + (this.m_Classifier instanceof OptionHandler && Utils.joinOptions(this.m_Classifier.getOptions()).length() > 0 ? Utils.joinOptions(this.m_Classifier.getOptions()) + "|" : "");
    }

    protected class TrainingTask
    implements Runnable,
    Task {
        private int m_runNum;
        private int m_maxRunNum;
        private int m_setNum;
        private int m_maxSetNum;
        private Instances m_train = null;
        private TaskStatusInfo m_taskInfo = new TaskStatusInfo();

        public TrainingTask(int n, int n2, int n3, int n4, Instances instances) {
            this.m_runNum = n;
            this.m_maxRunNum = n2;
            this.m_setNum = n3;
            this.m_maxSetNum = n4;
            this.m_train = instances;
            this.m_taskInfo.setExecutionStatus(0);
        }

        public void run() {
            this.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute() {
            block30: {
                try {
                    block29: {
                        try {
                            Object object;
                            Object object2;
                            if (this.m_train == null) break block29;
                            if (this.m_train.classIndex() < 0) {
                                this.m_train.setClassIndex(this.m_train.numAttributes() - 1);
                                if (Classifier.this.m_log != null) {
                                    Classifier.this.m_log.logMessage("[Classifier] " + Classifier.this.statusMessagePrefix() + " : assuming last " + "column is the class");
                                }
                            }
                            if (this.m_runNum == 1 && this.m_setNum == 1) {
                                Classifier.this.m_state = BUILDING_MODEL;
                                this.m_taskInfo.setExecutionStatus(1);
                            }
                            String string = Classifier.this.statusMessagePrefix() + "Building model for run " + this.m_runNum + " fold " + this.m_setNum;
                            if (Classifier.this.m_log != null) {
                                Classifier.this.m_log.statusMessage(string);
                            } else {
                                System.err.println(string);
                            }
                            weka.classifiers.Classifier classifier = weka.classifiers.Classifier.makeCopy(Classifier.this.m_Classifier);
                            classifier.buildClassifier(this.m_train);
                            if (this.m_runNum == this.m_maxRunNum && this.m_setNum == this.m_maxSetNum) {
                                Classifier.this.m_Classifier = classifier;
                                Classifier.this.m_trainingSet = this.m_train;
                            }
                            if (Classifier.this.m_batchClassifierListeners.size() > 0) {
                                object2 = new BatchClassifierEvent(Classifier.this, classifier, new DataSetEvent(this, this.m_train), null, this.m_setNum, this.m_maxSetNum);
                                Classifier.this.notifyBatchClassifierListeners((BatchClassifierEvent)object2);
                                Classifier.this.classifierTrainingComplete((BatchClassifierEvent)object2);
                            }
                            if (classifier instanceof Drawable && Classifier.this.m_graphListeners.size() > 0) {
                                object2 = ((Drawable)((Object)classifier)).graph();
                                int n = ((Drawable)((Object)classifier)).graphType();
                                object = classifier.getClass().getName();
                                object = ((String)object).substring(((String)object).lastIndexOf(46) + 1, ((String)object).length());
                                object = "Set " + this.m_setNum + " (" + this.m_train.relationName() + ") " + (String)object;
                                GraphEvent graphEvent = new GraphEvent(Classifier.this, (String)object2, (String)object, n);
                                Classifier.this.notifyGraphListeners(graphEvent);
                            }
                            if (Classifier.this.m_textListeners.size() > 0) {
                                object2 = classifier.toString();
                                String string2 = classifier.getClass().getName();
                                string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
                                object2 = "=== Classifier model ===\n\nScheme:   " + string2 + "\n" + "Relation: " + this.m_train.relationName() + (this.m_maxSetNum > 1 ? "\nTraining Fold: " + this.m_setNum : "") + "\n\n" + (String)object2;
                                string2 = "Model: " + string2;
                                object = new TextEvent(Classifier.this, (String)object2, string2);
                                Classifier.this.notifyTextListeners((TextEvent)object);
                            }
                        }
                        catch (Exception exception) {
                            Classifier.this.stop();
                            exception.printStackTrace();
                            if (Classifier.this.m_log != null) {
                                String string = "[Classifier] " + Classifier.this.statusMessagePrefix();
                                string = string + " run " + this.m_runNum + " fold " + this.m_setNum + " failed to complete.";
                                Classifier.this.m_log.logMessage(string + " (build classifier). " + exception.getMessage());
                                Classifier.this.m_log.statusMessage(Classifier.this.statusMessagePrefix() + "ERROR (see log for details)");
                                exception.printStackTrace();
                            }
                            this.m_taskInfo.setExecutionStatus(2);
                            Object var8_11 = null;
                            Classifier.this.m_visual.setStatic();
                            if (Thread.currentThread().isInterrupted()) {
                                Classifier.this.m_trainingSet = null;
                                if (Classifier.this.m_log == null) return;
                                String string = "[Classifier] " + Classifier.this.statusMessagePrefix();
                                Classifier.this.m_log.logMessage(string + " (" + " run " + this.m_runNum + " fold " + this.m_setNum + ") interrupted!");
                                Classifier.this.m_log.statusMessage(Classifier.this.statusMessagePrefix() + "INTERRUPTED");
                                if (Classifier.this.m_executorPool.getActiveCount() != 1) return;
                                String string5 = "[Classifier] " + Classifier.this.statusMessagePrefix() + " last classifier unblocking...";
                                Classifier.this.m_log.logMessage(string5);
                                Classifier.this.m_block = false;
                                return;
                            }
                            if (Classifier.this.m_executorPool != null) {
                                if (Classifier.this.m_executorPool.getQueue().size() != 0) return;
                                if (Classifier.this.m_executorPool.getActiveCount() != 1) return;
                            }
                            String string = "[Classifier] " + Classifier.this.statusMessagePrefix() + " last classifier unblocking...";
                            if (Classifier.this.m_log != null) {
                                Classifier.this.m_log.logMessage(string);
                            } else {
                                System.err.println(string);
                            }
                            if (Classifier.this.m_log != null) {
                                Classifier.this.m_log.statusMessage(Classifier.this.statusMessagePrefix() + "Finished.");
                            }
                            Classifier.this.m_block = false;
                            return;
                        }
                    }
                    Object var8_10 = null;
                    Classifier.this.m_visual.setStatic();
                    if (!Thread.currentThread().isInterrupted()) break block30;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    Classifier.this.m_visual.setStatic();
                    if (Thread.currentThread().isInterrupted()) {
                        Classifier.this.m_trainingSet = null;
                        if (Classifier.this.m_log == null) throw throwable;
                        String string = "[Classifier] " + Classifier.this.statusMessagePrefix();
                        Classifier.this.m_log.logMessage(string + " (" + " run " + this.m_runNum + " fold " + this.m_setNum + ") interrupted!");
                        Classifier.this.m_log.statusMessage(Classifier.this.statusMessagePrefix() + "INTERRUPTED");
                        if (Classifier.this.m_executorPool.getActiveCount() != 1) throw throwable;
                        String string3 = "[Classifier] " + Classifier.this.statusMessagePrefix() + " last classifier unblocking...";
                        Classifier.this.m_log.logMessage(string3);
                        Classifier.this.m_block = false;
                        throw throwable;
                    }
                    if (Classifier.this.m_executorPool != null) {
                        if (Classifier.this.m_executorPool.getQueue().size() != 0) throw throwable;
                        if (Classifier.this.m_executorPool.getActiveCount() != 1) throw throwable;
                    }
                    String string = "[Classifier] " + Classifier.this.statusMessagePrefix() + " last classifier unblocking...";
                    if (Classifier.this.m_log != null) {
                        Classifier.this.m_log.logMessage(string);
                    } else {
                        System.err.println(string);
                    }
                    if (Classifier.this.m_log != null) {
                        Classifier.this.m_log.statusMessage(Classifier.this.statusMessagePrefix() + "Finished.");
                    }
                    Classifier.this.m_block = false;
                    throw throwable;
                }
                Classifier.this.m_trainingSet = null;
                if (Classifier.this.m_log == null) return;
                String string = "[Classifier] " + Classifier.this.statusMessagePrefix();
                Classifier.this.m_log.logMessage(string + " (" + " run " + this.m_runNum + " fold " + this.m_setNum + ") interrupted!");
                Classifier.this.m_log.statusMessage(Classifier.this.statusMessagePrefix() + "INTERRUPTED");
                if (Classifier.this.m_executorPool.getActiveCount() != 1) return;
                String string4 = "[Classifier] " + Classifier.this.statusMessagePrefix() + " last classifier unblocking...";
                Classifier.this.m_log.logMessage(string4);
                Classifier.this.m_block = false;
                return;
            }
            if (Classifier.this.m_executorPool != null) {
                if (Classifier.this.m_executorPool.getQueue().size() != 0) return;
                if (Classifier.this.m_executorPool.getActiveCount() != 1) return;
            }
            String string = "[Classifier] " + Classifier.this.statusMessagePrefix() + " last classifier unblocking...";
            if (Classifier.this.m_log != null) {
                Classifier.this.m_log.logMessage(string);
            } else {
                System.err.println(string);
            }
            if (Classifier.this.m_log != null) {
                Classifier.this.m_log.statusMessage(Classifier.this.statusMessagePrefix() + "Finished.");
            }
            Classifier.this.m_block = false;
        }

        public TaskStatusInfo getTaskStatus() {
            return null;
        }
    }
}

