/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.parser.JFlex.ErrorMessages;
import weka.core.parser.JFlex.MacroException;
import weka.core.parser.JFlex.RegExp;
import weka.core.parser.JFlex.RegExp1;
import weka.core.parser.JFlex.RegExp2;

public final class Macros {
    private Hashtable macros = new Hashtable();
    private Hashtable used = new Hashtable();

    public boolean insert(String string, RegExp regExp) {
        this.used.put(string, Boolean.FALSE);
        return this.macros.put(string, regExp) == null;
    }

    public boolean markUsed(String string) {
        return this.used.put(string, Boolean.TRUE) != null;
    }

    public boolean isUsed(String string) {
        return (Boolean)this.used.get(string);
    }

    public Enumeration unused() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.used.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Boolean bl = (Boolean)this.used.get(string);
            if (bl.booleanValue()) continue;
            vector.addElement(string);
        }
        return vector.elements();
    }

    public RegExp getDefinition(String string) {
        return (RegExp)this.macros.get(string);
    }

    public void expand() throws MacroException {
        Enumeration enumeration = this.macros.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isUsed(string)) continue;
            this.macros.put(string, this.expandMacro(string, this.getDefinition(string)));
        }
    }

    private RegExp expandMacro(String string, RegExp regExp) throws MacroException {
        switch (regExp.type) {
            case 34: 
            case 44: {
                RegExp2 regExp2 = (RegExp2)regExp;
                regExp2.r1 = this.expandMacro(string, regExp2.r1);
                regExp2.r2 = this.expandMacro(string, regExp2.r2);
                return regExp;
            }
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                RegExp1 regExp1 = (RegExp1)regExp;
                regExp1.content = this.expandMacro(string, (RegExp)regExp1.content);
                return regExp;
            }
            case 41: {
                String string2 = (String)((RegExp1)regExp).content;
                if (string.equals(string2)) {
                    throw new MacroException(ErrorMessages.get(ErrorMessages.MACRO_CYCLE, string));
                }
                RegExp regExp2 = this.getDefinition(string2);
                if (regExp2 == null) {
                    throw new MacroException(ErrorMessages.get(ErrorMessages.MACRO_DEF_MISSING, string2, string));
                }
                this.markUsed(string2);
                return this.expandMacro(string, regExp2);
            }
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: {
                return regExp;
            }
        }
        throw new MacroException("unknown expression type " + regExp.type + " in macro expansion");
    }
}

