/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class ConsistencySubsetEval
extends ASEvaluation
implements SubsetEvaluator,
TechnicalInformationHandler {
    static final long serialVersionUID = -2880323763295270402L;
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private Discretize m_disTransform;
    private Hashtable m_table;

    public String globalInfo() {
        return "ConsistencySubsetEval :\n\nEvaluates the worth of a subset of attributes by the level of consistency in the class values when the training instances are projected onto the subset of attributes. \n\nConsistency of any subset can never be lower than that of the full set of attributes, hence the usual practice is to use this subset evaluator in conjunction with a Random or Exhaustive search which looks for the smallest subset with consistency equal to that of the full set of attributes.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "H. Liu and R. Setiono");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A probabilistic approach to feature selection - A filter solution");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "13th International Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1996");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "319-327");
        return technicalInformation;
    }

    public ConsistencySubsetEval() {
        this.resetOptions();
    }

    private void resetOptions() {
        this.m_trainInstances = null;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_trainInstances = new Instances(instances);
        this.m_trainInstances.deleteWithMissingClass();
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_disTransform = new Discretize();
        this.m_disTransform.setUseBetterEncoding(true);
        this.m_disTransform.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_disTransform);
    }

    public double evaluateSubset(BitSet bitSet) throws Exception {
        int n;
        int n2 = 0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            ++n2;
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        int[] nArray = new int[n2];
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n3++] = n;
        }
        this.m_table = new Hashtable((int)((double)this.m_numInstances * 1.5));
        for (n = 0; n < this.m_numInstances; ++n) {
            Instance instance = this.m_trainInstances.instance(n);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == this.m_classIndex) {
                    throw new Exception("A subset should not contain the class!");
                }
                dArray[i] = instance.isMissing(nArray[i]) ? Double.MAX_VALUE : instance.value(nArray[i]);
            }
            this.insertIntoTable(instance, dArray);
        }
        return this.consistencyCount();
    }

    private double consistencyCount() {
        Enumeration enumeration = this.m_table.keys();
        double d = 0.0;
        while (enumeration.hasMoreElements()) {
            hashKey hashKey2 = (hashKey)enumeration.nextElement();
            double[] dArray = (double[])this.m_table.get(hashKey2);
            d += Utils.sum(dArray);
            int n = Utils.maxIndex(dArray);
            d -= dArray[n];
        }
        return 1.0 - (d /= (double)this.m_numInstances);
    }

    private void insertIntoTable(Instance instance, double[] dArray) throws Exception {
        hashKey hashKey2 = new hashKey(dArray);
        double[] dArray2 = (double[])this.m_table.get(hashKey2);
        if (dArray2 == null) {
            double[] dArray3 = new double[this.m_trainInstances.classAttribute().numValues()];
            dArray3[(int)instance.classValue()] = instance.weight();
            this.m_table.put(hashKey2, dArray3);
        } else {
            int n = (int)instance.classValue();
            dArray2[n] = dArray2[n] + instance.weight();
            this.m_table.put(hashKey2, dArray2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_trainInstances == null) {
            stringBuffer.append("\tConsistency subset evaluator has not been built yet\n");
        } else {
            stringBuffer.append("\tConsistency Subset Evaluator\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5511 $");
    }

    public static void main(String[] stringArray) {
        ConsistencySubsetEval.runEvaluator(new ConsistencySubsetEval(), stringArray);
    }

    public class hashKey
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 6144138512017017408L;
        private double[] attributes;
        private boolean[] missing;
        private int key;

        public hashKey(Instance instance, int n) throws Exception {
            int n2 = instance.classIndex();
            this.key = -999;
            this.attributes = new double[n];
            this.missing = new boolean[n];
            for (int i = 0; i < n; ++i) {
                if (i == n2) {
                    this.missing[i] = true;
                    continue;
                }
                this.missing[i] = instance.isMissing(i);
                if (this.missing[i]) continue;
                this.attributes[i] = instance.value(i);
            }
        }

        public String toString(Instances instances, int n) {
            int n2 = instances.classIndex();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i == n2) continue;
                if (this.missing[i]) {
                    stringBuffer.append("?");
                    for (int j = 0; j < n; ++j) {
                        stringBuffer.append(" ");
                    }
                    continue;
                }
                String string = instances.attribute(i).value((int)this.attributes[i]);
                StringBuffer stringBuffer2 = new StringBuffer(string);
                for (int j = 0; j < n - string.length() + 1; ++j) {
                    stringBuffer2.append(" ");
                }
                stringBuffer.append(stringBuffer2);
            }
            return stringBuffer.toString();
        }

        public hashKey(double[] dArray) {
            int n = dArray.length;
            this.key = -999;
            this.attributes = new double[n];
            this.missing = new boolean[n];
            for (int i = 0; i < n; ++i) {
                if (dArray[i] == Double.MAX_VALUE) {
                    this.missing[i] = true;
                    continue;
                }
                this.missing[i] = false;
                this.attributes[i] = dArray[i];
            }
        }

        public int hashCode() {
            int n = 0;
            if (this.key != -999) {
                return this.key;
            }
            for (int i = 0; i < this.attributes.length; ++i) {
                if (this.missing[i]) {
                    n += i * 13;
                    continue;
                }
                n = (int)((double)n + (double)(i * 5) * (this.attributes[i] + 1.0));
            }
            if (this.key == -999) {
                this.key = n;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            boolean bl = true;
            if (object instanceof hashKey) {
                hashKey hashKey2 = (hashKey)object;
                for (int i = 0; i < this.attributes.length; ++i) {
                    boolean bl2 = hashKey2.missing[i];
                    if (this.missing[i] || bl2) {
                        if ((!this.missing[i] || bl2) && (this.missing[i] || !bl2)) continue;
                        bl = false;
                    } else {
                        if (this.attributes[i] == hashKey2.attributes[i]) continue;
                        bl = false;
                    }
                    break;
                }
            } else {
                return false;
            }
            return bl;
        }

        public void print_hash_code() {
            System.out.println("Hash val: " + this.hashCode());
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5511 $");
        }
    }
}

