/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import weka.core.Jython;
import weka.core.JythonSerializableObject;

public class SerializedObject
implements Serializable {
    private static final long serialVersionUID = 6635502953928860434L;
    private byte[] m_storedObjectArray;
    private boolean m_isCompressed;
    private boolean m_isJython;

    public SerializedObject(Object object) throws Exception {
        this(object, false);
    }

    public SerializedObject(Object object, boolean bl) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = !bl ? new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream2)) : new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(byteArrayOutputStream2)));
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
        this.m_storedObjectArray = byteArrayOutputStream.toByteArray();
        this.m_isCompressed = bl;
        this.m_isJython = object instanceof JythonSerializableObject;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        byte[] byArray = ((SerializedObject)object).m_storedObjectArray;
        if (byArray.length != this.m_storedObjectArray.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == this.m_storedObjectArray[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m_storedObjectArray.length;
    }

    public Object getObject() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.m_storedObjectArray);
            Object object = null;
            if (this.m_isJython) {
                object = !this.m_isCompressed ? Jython.deserialize(new BufferedInputStream(byteArrayInputStream)) : Jython.deserialize(new BufferedInputStream(new GZIPInputStream(byteArrayInputStream)));
            } else {
                ObjectInputStream objectInputStream = !this.m_isCompressed ? new ObjectInputStream(new BufferedInputStream(byteArrayInputStream)) : new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(byteArrayInputStream)));
                object = objectInputStream.readObject();
            }
            byteArrayInputStream.close();
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

