/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSetEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.RankedOutputSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class FCBFSearch
extends ASSearch
implements RankedOutputSearch,
StartSetHandler,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 8209699587428369942L;
    private int[] m_starting;
    private Range m_startRange;
    private int[] m_attributeList;
    private double[] m_attributeMerit;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private double m_threshold;
    private int m_numToSelect = -1;
    private int m_calculatedNumToSelect = -1;
    private boolean m_generateOutput = false;
    private ASEvaluation m_asEval;
    private double[][] m_rankedFCBF;
    private double[][] m_selectedFeatures;

    public String globalInfo() {
        return "FCBF : \n\nFeature selection method based on correlation measureand relevance&redundancy analysis. Use in conjunction with an attribute set evaluator (SymmetricalUncertAttributeEval).\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Lei Yu and Huan Liu");
        result.setValue(TechnicalInformation.Field.TITLE, "Feature Selection for High-Dimensional Data: A Fast Correlation-Based Filter Solution");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the Twentieth International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.PAGES, "856-863");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "AAAI Press");
        return result;
    }

    public FCBFSearch() {
        this.resetOptions();
    }

    public String numToSelectTipText() {
        return "Specify the number of attributes to retain. The default value (-1) indicates that all attributes are to be retained. Use either this option or a threshold to reduce the attribute set.";
    }

    public void setNumToSelect(int n) {
        this.m_numToSelect = n;
    }

    public int getNumToSelect() {
        return this.m_numToSelect;
    }

    public int getCalculatedNumToSelect() {
        if (this.m_numToSelect >= 0) {
            this.m_calculatedNumToSelect = this.m_numToSelect;
        }
        if (this.m_selectedFeatures.length > 0 && this.m_selectedFeatures.length < this.m_calculatedNumToSelect) {
            this.m_calculatedNumToSelect = this.m_selectedFeatures.length;
        }
        return this.m_calculatedNumToSelect;
    }

    public String thresholdTipText() {
        return "Set threshold by which attributes can be discarded. Default value results in no attributes being discarded. Use either this option or numToSelect to reduce the attribute set.";
    }

    public void setThreshold(double threshold) {
        this.m_threshold = threshold;
    }

    public double getThreshold() {
        return this.m_threshold;
    }

    public String generateRankingTipText() {
        return "A constant option. FCBF is capable of generating attribute rankings.";
    }

    public void setGenerateRanking(boolean doRank) {
    }

    public boolean getGenerateRanking() {
        return true;
    }

    public String generateDataOutputTipText() {
        return "Generating new dataset according to the selected features. ";
    }

    public void setGenerateDataOutput(boolean doGenerate) {
        this.m_generateOutput = doGenerate;
    }

    public boolean getGenerateDataOutput() {
        return this.m_generateOutput;
    }

    public String startSetTipText() {
        return "Specify a set of attributes to ignore.  When generating the ranking, FCBF will not evaluate the attributes  in this list. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17.";
    }

    public void setStartSet(String startSet) throws Exception {
        this.m_startRange.setRanges(startSet);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tSpecify Whether the selector generates a new dataset.", "D", 1, "-D <create dataset>"));
        newVector.addElement(new Option("\tSpecify a starting set of attributes.\n\t\tEg. 1,3,5-7.\n\tAny starting attributes specified are\n\tignored during the ranking.", "P", 1, "-P <start set>"));
        newVector.addElement(new Option("\tSpecify a theshold by which attributes\n\tmay be discarded from the ranking.", "T", 1, "-T <threshold>"));
        newVector.addElement(new Option("\tSpecify number of attributes to select", "N", 1, "-N <num to select>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('D', options);
        if (optionString.length() != 0) {
            this.setGenerateDataOutput(Boolean.getBoolean(optionString));
        }
        if ((optionString = Utils.getOption('P', options)).length() != 0) {
            this.setStartSet(optionString);
        }
        if ((optionString = Utils.getOption('T', options)).length() != 0) {
            Double temp = Double.valueOf(optionString);
            this.setThreshold(temp);
        }
        if ((optionString = Utils.getOption('N', options)).length() != 0) {
            this.setNumToSelect(Integer.parseInt(optionString));
        }
    }

    public String[] getOptions() {
        String[] options = new String[8];
        int current = 0;
        options[current++] = "-D";
        options[current++] = "" + this.getGenerateDataOutput();
        if (!this.getStartSet().equals("")) {
            options[current++] = "-P";
            options[current++] = "" + this.startSetToString();
        }
        options[current++] = "-T";
        options[current++] = "" + this.getThreshold();
        options[current++] = "-N";
        options[current++] = "" + this.getNumToSelect();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    private String startSetToString() {
        StringBuffer FString = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean didPrint = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                FString.append(this.m_starting[i] + 1);
                didPrint = true;
            }
            if (i == this.m_starting.length - 1) {
                FString.append("");
                continue;
            }
            if (!didPrint) continue;
            FString.append(",");
        }
        return FString.toString();
    }

    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        int i;
        if (!(ASEval instanceof AttributeSetEvaluator)) {
            throw new Exception(ASEval.getClass().getName() + " is not an " + "Attribute Set evaluator!");
        }
        this.m_numAttribs = data.numAttributes();
        if (ASEval instanceof UnsupervisedAttributeEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_classIndex = data.classIndex();
            this.m_hasClass = this.m_classIndex >= 0;
        }
        if (ASEval instanceof AttributeTransformer) {
            data = ((AttributeTransformer)((Object)ASEval)).transformedHeader();
            if (this.m_classIndex >= 0 && data.classIndex() >= 0) {
                this.m_classIndex = data.classIndex();
                this.m_hasClass = true;
            }
        }
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        int sl = 0;
        if (this.m_starting != null) {
            sl = this.m_starting.length;
        }
        if (this.m_starting != null && this.m_hasClass) {
            boolean ok = false;
            for (i = 0; i < sl; ++i) {
                if (this.m_starting[i] != this.m_classIndex) continue;
                ok = true;
                break;
            }
            if (!ok) {
                ++sl;
            }
        } else if (this.m_hasClass) {
            ++sl;
        }
        this.m_attributeList = new int[this.m_numAttribs - sl];
        this.m_attributeMerit = new double[this.m_numAttribs - sl];
        int j = 0;
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (this.inStarting(i)) continue;
            this.m_attributeList[j++] = i;
        }
        this.m_asEval = ASEval;
        AttributeSetEvaluator ASEvaluator = (AttributeSetEvaluator)ASEval;
        for (i = 0; i < this.m_attributeList.length; ++i) {
            this.m_attributeMerit[i] = ASEvaluator.evaluateAttribute(this.m_attributeList[i]);
        }
        double[][] tempRanked = this.rankedAttributes();
        int[] rankedAttributes = new int[this.m_selectedFeatures.length];
        for (i = 0; i < this.m_selectedFeatures.length; ++i) {
            rankedAttributes[i] = (int)tempRanked[i][0];
        }
        return rankedAttributes;
    }

    public double[][] rankedAttributes() throws Exception {
        int i;
        if (this.m_attributeList == null || this.m_attributeMerit == null) {
            throw new Exception("Search must be performed before a ranked attribute list can be obtained");
        }
        int[] ranked = Utils.sort(this.m_attributeMerit);
        double[][] bestToWorst = new double[ranked.length][2];
        int j = 0;
        for (i = ranked.length - 1; i >= 0; --i) {
            bestToWorst[j++][0] = ranked[i];
        }
        for (i = 0; i < bestToWorst.length; ++i) {
            int temp = (int)bestToWorst[i][0];
            bestToWorst[i][0] = this.m_attributeList[temp];
            bestToWorst[i][1] = this.m_attributeMerit[temp];
        }
        if (this.m_numToSelect > bestToWorst.length) {
            throw new Exception("More attributes requested than exist in the data");
        }
        this.FCBFElimination(bestToWorst);
        if (this.m_numToSelect <= 0) {
            if (this.m_threshold == -1.7976931348623157E308) {
                this.m_calculatedNumToSelect = this.m_selectedFeatures.length;
            } else {
                this.determineNumToSelectFromThreshold(this.m_selectedFeatures);
            }
        }
        return this.m_selectedFeatures;
    }

    private void determineNumToSelectFromThreshold(double[][] ranking) {
        int count = 0;
        for (int i = 0; i < ranking.length; ++i) {
            if (!(ranking[i][1] > this.m_threshold)) continue;
            ++count;
        }
        this.m_calculatedNumToSelect = count;
    }

    private void determineThreshFromNumToSelect(double[][] ranking) throws Exception {
        if (this.m_numToSelect > ranking.length) {
            throw new Exception("More attributes requested than exist in the data");
        }
        if (this.m_numToSelect == ranking.length) {
            return;
        }
        this.m_threshold = (ranking[this.m_numToSelect - 1][1] + ranking[this.m_numToSelect][1]) / 2.0;
    }

    public String toString() {
        StringBuffer BfString = new StringBuffer();
        BfString.append("\tAttribute ranking.\n");
        if (this.m_starting != null) {
            BfString.append("\tIgnored attributes: ");
            BfString.append(this.startSetToString());
            BfString.append("\n");
        }
        if (this.m_threshold != -1.7976931348623157E308) {
            BfString.append("\tThreshold for discarding attributes: " + Utils.doubleToString(this.m_threshold, 8, 4) + "\n");
        }
        BfString.append("\n\n");
        BfString.append("     J || SU(j,Class) ||    I || SU(i,j). \n");
        for (int i = 0; i < this.m_rankedFCBF.length; ++i) {
            BfString.append(Utils.doubleToString(this.m_rankedFCBF[i][0] + 1.0, 6, 0) + " ; " + Utils.doubleToString(this.m_rankedFCBF[i][1], 12, 7) + " ; ");
            if (this.m_rankedFCBF[i][2] == this.m_rankedFCBF[i][0]) {
                BfString.append("    *\n");
                continue;
            }
            BfString.append(Utils.doubleToString(this.m_rankedFCBF[i][2] + 1.0, 5, 0) + " ; " + this.m_rankedFCBF[i][3] + "\n");
        }
        return BfString.toString();
    }

    protected void resetOptions() {
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_attributeList = null;
        this.m_attributeMerit = null;
        this.m_threshold = -1.7976931348623157E308;
    }

    private boolean inStarting(int feat) {
        if (this.m_hasClass && feat == this.m_classIndex) {
            return true;
        }
        if (this.m_starting == null) {
            return false;
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            if (this.m_starting[i] != feat) continue;
            return true;
        }
        return false;
    }

    private void FCBFElimination(double[][] rankedFeatures) throws Exception {
        int i;
        this.m_rankedFCBF = new double[this.m_attributeList.length][4];
        int[] attributes = new int[1];
        int[] classAtrributes = new int[1];
        int numSelectedAttributes = 0;
        int startPoint = 0;
        double tempSUIJ = 0.0;
        AttributeSetEvaluator ASEvaluator = (AttributeSetEvaluator)this.m_asEval;
        for (i = 0; i < rankedFeatures.length; ++i) {
            this.m_rankedFCBF[i][0] = rankedFeatures[i][0];
            this.m_rankedFCBF[i][1] = rankedFeatures[i][1];
            this.m_rankedFCBF[i][2] = -1.0;
        }
        while (startPoint < rankedFeatures.length) {
            if (this.m_rankedFCBF[startPoint][2] != -1.0) {
                ++startPoint;
                continue;
            }
            this.m_rankedFCBF[startPoint][2] = this.m_rankedFCBF[startPoint][0];
            ++numSelectedAttributes;
            for (i = startPoint + 1; i < this.m_attributeList.length; ++i) {
                if (this.m_rankedFCBF[i][2] != -1.0) continue;
                attributes[0] = (int)this.m_rankedFCBF[startPoint][0];
                classAtrributes[0] = (int)this.m_rankedFCBF[i][0];
                tempSUIJ = ASEvaluator.evaluateAttribute(attributes, classAtrributes);
                if (!(this.m_rankedFCBF[i][1] < tempSUIJ) && !(Math.abs(tempSUIJ - this.m_rankedFCBF[i][1]) < 1.0E-8)) continue;
                this.m_rankedFCBF[i][2] = this.m_rankedFCBF[startPoint][0];
                this.m_rankedFCBF[i][3] = tempSUIJ;
            }
            ++startPoint;
        }
        this.m_selectedFeatures = new double[numSelectedAttributes][2];
        int j = 0;
        for (i = 0; i < this.m_attributeList.length; ++i) {
            if (this.m_rankedFCBF[i][2] != this.m_rankedFCBF[i][0]) continue;
            this.m_selectedFeatures[j][0] = this.m_rankedFCBF[i][0];
            this.m_selectedFeatures[j][1] = this.m_rankedFCBF[i][1];
            ++j;
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }
}

