/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.DecisionStump;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RacedIncrementalLogitBoost
extends RandomizableSingleClassifierEnhancer
implements UpdateableClassifier {
    static final long serialVersionUID = 908598343772170052L;
    public static final int PRUNETYPE_NONE = 0;
    public static final int PRUNETYPE_LOGLIKELIHOOD = 1;
    public static final Tag[] TAGS_PRUNETYPE = new Tag[]{new Tag(0, "No pruning"), new Tag(1, "Log likelihood pruning")};
    protected FastVector m_committees;
    protected int m_PruningType = 1;
    protected boolean m_UseResampling = false;
    protected int m_NumClasses;
    protected static final double Z_MAX = 4.0;
    protected Instances m_NumericClassData;
    protected Attribute m_ClassAttribute;
    protected int m_minChunkSize = 500;
    protected int m_maxChunkSize = 2000;
    protected int m_validationChunkSize = 1000;
    protected int m_numInstancesConsumed;
    protected Instances m_validationSet;
    protected Instances m_currentSet;
    protected Committee m_bestCommittee;
    protected ZeroR m_zeroR = null;
    protected boolean m_validationSetChanged;
    protected int m_maxBatchSizeRequired;
    protected Random m_RandomInstance = null;

    public RacedIncrementalLogitBoost() {
        this.m_Classifier = new DecisionStump();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.DecisionStump";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.m_RandomInstance = new Random(this.m_Seed);
        int classIndex = data.classIndex();
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (this.m_Classifier == null) {
            throw new Exception("A base classifier has not been specified!");
        }
        if (!(this.m_Classifier instanceof WeightedInstancesHandler) && !this.m_UseResampling) {
            this.m_UseResampling = true;
        }
        this.m_NumClasses = data.numClasses();
        this.m_ClassAttribute = data.classAttribute();
        Instances boostData = new Instances(data);
        boostData.setClassIndex(-1);
        boostData.deleteAttributeAt(classIndex);
        boostData.insertAttributeAt(new Attribute("'pseudo class'"), classIndex);
        boostData.setClassIndex(classIndex);
        this.m_NumericClassData = new Instances(boostData, 0);
        data.randomize(this.m_RandomInstance);
        this.m_committees = new FastVector();
        for (int cSize = this.m_minChunkSize; cSize <= this.m_maxChunkSize; cSize *= 2) {
            this.m_committees.addElement(new Committee(cSize));
            this.m_maxBatchSizeRequired = cSize;
        }
        this.m_validationSet = new Instances(data, this.m_validationChunkSize);
        this.m_currentSet = new Instances(data, this.m_maxBatchSizeRequired);
        this.m_bestCommittee = null;
        this.m_numInstancesConsumed = 0;
        for (int i = 0; i < data.numInstances(); ++i) {
            this.updateClassifier(data.instance(i));
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        ++this.m_numInstancesConsumed;
        if (this.m_validationSet.numInstances() < this.m_validationChunkSize) {
            this.m_validationSet.add(instance);
            this.m_validationSetChanged = true;
        } else {
            Committee c;
            int i;
            this.m_currentSet.add(instance);
            boolean hasChanged = false;
            for (i = 0; i < this.m_committees.size(); ++i) {
                c = (Committee)this.m_committees.elementAt(i);
                if (!c.update()) continue;
                hasChanged = true;
                if (this.m_PruningType == 1) {
                    double oldLL = c.logLikelihood();
                    double newLL = c.logLikelihoodAfter();
                    if (newLL >= oldLL && c.committeeSize() > 1) {
                        c.pruneLastModel();
                        if (!this.m_Debug) continue;
                        System.out.println("Pruning " + c.chunkSize() + " committee (" + oldLL + " < " + newLL + ")");
                        continue;
                    }
                    c.keepLastModel();
                    continue;
                }
                c.keepLastModel();
            }
            if (hasChanged) {
                if (this.m_Debug) {
                    System.out.println("After consuming " + this.m_numInstancesConsumed + " instances... (" + this.m_validationSet.numInstances() + " + " + this.m_currentSet.numInstances() + " instances currently in memory)");
                }
                double lowestError = 1.0;
                for (int i2 = 0; i2 < this.m_committees.size(); ++i2) {
                    Committee c2 = (Committee)this.m_committees.elementAt(i2);
                    if (c2.committeeSize() <= 0) continue;
                    double err = c2.validationError();
                    double ll = c2.logLikelihood();
                    if (this.m_Debug) {
                        System.out.println("Chunk size " + c2.chunkSize() + " with " + c2.committeeSize() + " models, has validation error of " + err + ", log likelihood of " + ll);
                    }
                    if (!(err < lowestError)) continue;
                    lowestError = err;
                    this.m_bestCommittee = c2;
                }
            }
            if (this.m_currentSet.numInstances() >= this.m_maxBatchSizeRequired) {
                this.m_currentSet = new Instances(this.m_currentSet, this.m_maxBatchSizeRequired);
                for (i = 0; i < this.m_committees.size(); ++i) {
                    c = (Committee)this.m_committees.elementAt(i);
                    c.resetConsumed();
                }
            }
        }
    }

    protected static double RtoP(double[] Fs, int j) throws Exception {
        double maxF = -1.7976931348623157E308;
        for (int i = 0; i < Fs.length; ++i) {
            if (!(Fs[i] > maxF)) continue;
            maxF = Fs[i];
        }
        double sum = 0.0;
        double[] probs = new double[Fs.length];
        for (int i = 0; i < Fs.length; ++i) {
            probs[i] = Math.exp(Fs[i] - maxF);
            sum += probs[i];
        }
        if (sum == 0.0) {
            throw new Exception("Can't normalize");
        }
        return probs[j] / sum;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_bestCommittee != null) {
            return this.m_bestCommittee.distributionForInstance(instance);
        }
        if (this.m_validationSetChanged || this.m_zeroR == null) {
            this.m_zeroR = new ZeroR();
            this.m_zeroR.buildClassifier(this.m_validationSet);
            this.m_validationSetChanged = false;
        }
        return this.m_zeroR.distributionForInstance(instance);
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(9);
        newVector.addElement(new Option("\tMinimum size of chunks.\n\t(default 500)", "C", 1, "-C <num>"));
        newVector.addElement(new Option("\tMaximum size of chunks.\n\t(default 2000)", "M", 1, "-M <num>"));
        newVector.addElement(new Option("\tSize of validation set.\n\t(default 1000)", "V", 1, "-V <num>"));
        newVector.addElement(new Option("\tCommittee pruning to perform.\n\t0=none, 1=log likelihood (default)", "P", 1, "-P <pruning type>"));
        newVector.addElement(new Option("\tUse resampling for boosting.", "Q", 0, "-Q"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String minChunkSize = Utils.getOption('C', options);
        if (minChunkSize.length() != 0) {
            this.setMinChunkSize(Integer.parseInt(minChunkSize));
        } else {
            this.setMinChunkSize(500);
        }
        String maxChunkSize = Utils.getOption('M', options);
        if (maxChunkSize.length() != 0) {
            this.setMaxChunkSize(Integer.parseInt(maxChunkSize));
        } else {
            this.setMaxChunkSize(2000);
        }
        String validationChunkSize = Utils.getOption('V', options);
        if (validationChunkSize.length() != 0) {
            this.setValidationChunkSize(Integer.parseInt(validationChunkSize));
        } else {
            this.setValidationChunkSize(1000);
        }
        String pruneType = Utils.getOption('P', options);
        if (pruneType.length() != 0) {
            this.setPruningType(new SelectedTag(Integer.parseInt(pruneType), TAGS_PRUNETYPE));
        } else {
            this.setPruningType(new SelectedTag(1, TAGS_PRUNETYPE));
        }
        this.setUseResampling(Utils.getFlag('Q', options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 9];
        int current = 0;
        if (this.getUseResampling()) {
            options[current++] = "-Q";
        }
        options[current++] = "-C";
        options[current++] = "" + this.getMinChunkSize();
        options[current++] = "-M";
        options[current++] = "" + this.getMaxChunkSize();
        options[current++] = "-V";
        options[current++] = "" + this.getValidationChunkSize();
        options[current++] = "-P";
        options[current++] = "" + this.m_PruningType;
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        current += superOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String globalInfo() {
        return "Classifier for incremental learning of large datasets by way of racing logit-boosted committees.";
    }

    public void setClassifier(Classifier newClassifier) {
        Capabilities cap = newClassifier.getCapabilities();
        if (!cap.handles(Capabilities.Capability.NUMERIC_CLASS)) {
            throw new IllegalArgumentException("Base classifier cannot handle numeric class!");
        }
        super.setClassifier(newClassifier);
    }

    public String minChunkSizeTipText() {
        return "The minimum number of instances to train the base learner with.";
    }

    public void setMinChunkSize(int chunkSize) {
        this.m_minChunkSize = chunkSize;
    }

    public int getMinChunkSize() {
        return this.m_minChunkSize;
    }

    public String maxChunkSizeTipText() {
        return "The maximum number of instances to train the base learner with. The chunk sizes used will start at minChunkSize and grow twice as large for as many times as they are less than or equal to the maximum size.";
    }

    public void setMaxChunkSize(int chunkSize) {
        this.m_maxChunkSize = chunkSize;
    }

    public int getMaxChunkSize() {
        return this.m_maxChunkSize;
    }

    public String validationChunkSizeTipText() {
        return "The number of instances to hold out for validation. These instances will be taken from the beginning of the stream, so learning will not start until these instances have been consumed first.";
    }

    public void setValidationChunkSize(int chunkSize) {
        this.m_validationChunkSize = chunkSize;
    }

    public int getValidationChunkSize() {
        return this.m_validationChunkSize;
    }

    public String pruningTypeTipText() {
        return "The pruning method to use within each committee. Log likelihood pruning will discard new models if they have a negative effect on the log likelihood of the validation data.";
    }

    public void setPruningType(SelectedTag pruneType) {
        if (pruneType.getTags() == TAGS_PRUNETYPE) {
            this.m_PruningType = pruneType.getSelectedTag().getID();
        }
    }

    public SelectedTag getPruningType() {
        return new SelectedTag(this.m_PruningType, TAGS_PRUNETYPE);
    }

    public String useResamplingTipText() {
        return "Force the use of resampling data rather than using the weight-handling capabilities of the base classifier. Resampling is always used if the base classifier cannot handle weighted instances.";
    }

    public void setUseResampling(boolean r) {
        this.m_UseResampling = r;
    }

    public boolean getUseResampling() {
        return this.m_UseResampling;
    }

    public int getBestCommitteeChunkSize() {
        if (this.m_bestCommittee != null) {
            return this.m_bestCommittee.chunkSize();
        }
        return 0;
    }

    public int getBestCommitteeSize() {
        if (this.m_bestCommittee != null) {
            return this.m_bestCommittee.committeeSize();
        }
        return 0;
    }

    public double getBestCommitteeErrorEstimate() {
        if (this.m_bestCommittee != null) {
            try {
                return this.m_bestCommittee.validationError() * 100.0;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return 100.0;
            }
        }
        return 100.0;
    }

    public double getBestCommitteeLLEstimate() {
        if (this.m_bestCommittee != null) {
            try {
                return this.m_bestCommittee.logLikelihood();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return Double.MAX_VALUE;
            }
        }
        return Double.MAX_VALUE;
    }

    public String toString() {
        if (this.m_bestCommittee != null) {
            return this.m_bestCommittee.toString();
        }
        if ((this.m_validationSetChanged || this.m_zeroR == null) && this.m_validationSet != null && this.m_validationSet.numInstances() > 0) {
            this.m_zeroR = new ZeroR();
            try {
                this.m_zeroR.buildClassifier(this.m_validationSet);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_validationSetChanged = false;
        }
        if (this.m_zeroR != null) {
            return "RacedIncrementalLogitBoost: insufficient data to build model, resorting to ZeroR:\n\n" + this.m_zeroR.toString();
        }
        return "RacedIncrementalLogitBoost: no model built yet.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        RacedIncrementalLogitBoost.runClassifier(new RacedIncrementalLogitBoost(), argv);
    }

    protected class Committee
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 5559880306684082199L;
        protected int m_chunkSize;
        protected int m_instancesConsumed;
        protected FastVector m_models;
        protected double m_lastValidationError;
        protected double m_lastLogLikelihood;
        protected boolean m_modelHasChanged;
        protected boolean m_modelHasChangedLL;
        protected double[][] m_validationFs;
        protected double[][] m_newValidationFs;

        public Committee(int chunkSize) {
            this.m_chunkSize = chunkSize;
            this.m_instancesConsumed = 0;
            this.m_models = new FastVector();
            this.m_lastValidationError = 1.0;
            this.m_lastLogLikelihood = Double.MAX_VALUE;
            this.m_modelHasChanged = true;
            this.m_modelHasChangedLL = true;
            this.m_validationFs = new double[RacedIncrementalLogitBoost.this.m_validationChunkSize][RacedIncrementalLogitBoost.this.m_NumClasses];
            this.m_newValidationFs = new double[RacedIncrementalLogitBoost.this.m_validationChunkSize][RacedIncrementalLogitBoost.this.m_NumClasses];
        }

        public boolean update() throws Exception {
            boolean hasChanged = false;
            while (RacedIncrementalLogitBoost.this.m_currentSet.numInstances() - this.m_instancesConsumed >= this.m_chunkSize) {
                Classifier[] newModel = this.boost(new Instances(RacedIncrementalLogitBoost.this.m_currentSet, this.m_instancesConsumed, this.m_chunkSize));
                for (int i = 0; i < RacedIncrementalLogitBoost.this.m_validationSet.numInstances(); ++i) {
                    this.m_newValidationFs[i] = this.updateFS(RacedIncrementalLogitBoost.this.m_validationSet.instance(i), newModel, this.m_validationFs[i]);
                }
                this.m_models.addElement(newModel);
                this.m_instancesConsumed += this.m_chunkSize;
                hasChanged = true;
            }
            if (hasChanged) {
                this.m_modelHasChanged = true;
                this.m_modelHasChangedLL = true;
            }
            return hasChanged;
        }

        public void resetConsumed() {
            this.m_instancesConsumed = 0;
        }

        public void pruneLastModel() {
            if (this.m_models.size() > 0) {
                this.m_models.removeElementAt(this.m_models.size() - 1);
                this.m_modelHasChanged = true;
                this.m_modelHasChangedLL = true;
            }
        }

        public void keepLastModel() throws Exception {
            this.m_validationFs = this.m_newValidationFs;
            this.m_newValidationFs = new double[RacedIncrementalLogitBoost.this.m_validationChunkSize][RacedIncrementalLogitBoost.this.m_NumClasses];
            this.m_modelHasChanged = true;
            this.m_modelHasChangedLL = true;
        }

        public double logLikelihood() throws Exception {
            if (this.m_modelHasChangedLL) {
                double llsum = 0.0;
                for (int i = 0; i < RacedIncrementalLogitBoost.this.m_validationSet.numInstances(); ++i) {
                    Instance inst = RacedIncrementalLogitBoost.this.m_validationSet.instance(i);
                    llsum += this.logLikelihood(this.m_validationFs[i], (int)inst.classValue());
                }
                this.m_lastLogLikelihood = llsum / (double)RacedIncrementalLogitBoost.this.m_validationSet.numInstances();
                this.m_modelHasChangedLL = false;
            }
            return this.m_lastLogLikelihood;
        }

        public double logLikelihoodAfter() throws Exception {
            double llsum = 0.0;
            for (int i = 0; i < RacedIncrementalLogitBoost.this.m_validationSet.numInstances(); ++i) {
                Instance inst = RacedIncrementalLogitBoost.this.m_validationSet.instance(i);
                llsum += this.logLikelihood(this.m_newValidationFs[i], (int)inst.classValue());
            }
            return llsum / (double)RacedIncrementalLogitBoost.this.m_validationSet.numInstances();
        }

        private double logLikelihood(double[] Fs, int classIndex) throws Exception {
            return -Math.log(this.distributionForInstance(Fs)[classIndex]);
        }

        public double validationError() throws Exception {
            if (this.m_modelHasChanged) {
                int numIncorrect = 0;
                for (int i = 0; i < RacedIncrementalLogitBoost.this.m_validationSet.numInstances(); ++i) {
                    Instance inst = RacedIncrementalLogitBoost.this.m_validationSet.instance(i);
                    if (this.classifyInstance(this.m_validationFs[i]) == inst.classValue()) continue;
                    ++numIncorrect;
                }
                this.m_lastValidationError = (double)numIncorrect / (double)RacedIncrementalLogitBoost.this.m_validationSet.numInstances();
                this.m_modelHasChanged = false;
            }
            return this.m_lastValidationError;
        }

        public int chunkSize() {
            return this.m_chunkSize;
        }

        public int committeeSize() {
            return this.m_models.size();
        }

        public double classifyInstance(double[] Fs) throws Exception {
            double[] dist = this.distributionForInstance(Fs);
            double max = 0.0;
            int maxIndex = 0;
            for (int i = 0; i < dist.length; ++i) {
                if (!(dist[i] > max)) continue;
                maxIndex = i;
                max = dist[i];
            }
            if (max > 0.0) {
                return maxIndex;
            }
            return Utils.missingValue();
        }

        public double classifyInstance(Instance instance) throws Exception {
            double[] dist = this.distributionForInstance(instance);
            switch (instance.classAttribute().type()) {
                case 1: {
                    double max = 0.0;
                    int maxIndex = 0;
                    for (int i = 0; i < dist.length; ++i) {
                        if (!(dist[i] > max)) continue;
                        maxIndex = i;
                        max = dist[i];
                    }
                    if (max > 0.0) {
                        return maxIndex;
                    }
                    return Utils.missingValue();
                }
                case 0: {
                    return dist[0];
                }
            }
            return Utils.missingValue();
        }

        public double[] distributionForInstance(double[] Fs) throws Exception {
            double[] distribution = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
            for (int j = 0; j < RacedIncrementalLogitBoost.this.m_NumClasses; ++j) {
                distribution[j] = RacedIncrementalLogitBoost.RtoP(Fs, j);
            }
            return distribution;
        }

        public double[] updateFS(Instance instance, Classifier[] newModel, double[] Fs) throws Exception {
            instance = (Instance)instance.copy();
            instance.setDataset(RacedIncrementalLogitBoost.this.m_NumericClassData);
            double[] Fi = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
            double Fsum = 0.0;
            for (int j = 0; j < RacedIncrementalLogitBoost.this.m_NumClasses; ++j) {
                Fi[j] = newModel[j].classifyInstance(instance);
                Fsum += Fi[j];
            }
            Fsum /= (double)RacedIncrementalLogitBoost.this.m_NumClasses;
            double[] newFs = new double[Fs.length];
            for (int j = 0; j < RacedIncrementalLogitBoost.this.m_NumClasses; ++j) {
                newFs[j] = Fs[j] + (Fi[j] - Fsum) * (double)(RacedIncrementalLogitBoost.this.m_NumClasses - 1) / (double)RacedIncrementalLogitBoost.this.m_NumClasses;
            }
            return newFs;
        }

        public double[] distributionForInstance(Instance instance) throws Exception {
            instance = (Instance)instance.copy();
            instance.setDataset(RacedIncrementalLogitBoost.this.m_NumericClassData);
            double[] Fs = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
            for (int i = 0; i < this.m_models.size(); ++i) {
                int j;
                double[] Fi = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
                double Fsum = 0.0;
                Classifier[] model = (Classifier[])this.m_models.elementAt(i);
                for (j = 0; j < RacedIncrementalLogitBoost.this.m_NumClasses; ++j) {
                    Fi[j] = model[j].classifyInstance(instance);
                    Fsum += Fi[j];
                }
                Fsum /= (double)RacedIncrementalLogitBoost.this.m_NumClasses;
                for (j = 0; j < RacedIncrementalLogitBoost.this.m_NumClasses; ++j) {
                    int n = j;
                    Fs[n] = Fs[n] + (Fi[j] - Fsum) * (double)(RacedIncrementalLogitBoost.this.m_NumClasses - 1) / (double)RacedIncrementalLogitBoost.this.m_NumClasses;
                }
            }
            double[] distribution = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
            for (int j = 0; j < RacedIncrementalLogitBoost.this.m_NumClasses; ++j) {
                distribution[j] = RacedIncrementalLogitBoost.RtoP(Fs, j);
            }
            return distribution;
        }

        protected Classifier[] boost(Instances data) throws Exception {
            int i;
            int j;
            Classifier[] newModel = AbstractClassifier.makeCopies(RacedIncrementalLogitBoost.this.m_Classifier, RacedIncrementalLogitBoost.this.m_NumClasses);
            Instances boostData = new Instances(data);
            boostData.deleteWithMissingClass();
            int numInstances = boostData.numInstances();
            int classIndex = data.classIndex();
            boostData.setClassIndex(-1);
            boostData.deleteAttributeAt(classIndex);
            boostData.insertAttributeAt(new Attribute("'pseudo class'"), classIndex);
            boostData.setClassIndex(classIndex);
            double[][] trainFs = new double[numInstances][RacedIncrementalLogitBoost.this.m_NumClasses];
            double[][] trainYs = new double[numInstances][RacedIncrementalLogitBoost.this.m_NumClasses];
            for (j = 0; j < RacedIncrementalLogitBoost.this.m_NumClasses; ++j) {
                i = 0;
                int k = 0;
                while (i < numInstances) {
                    while (data.instance(k).classIsMissing()) {
                        ++k;
                    }
                    trainYs[i][j] = data.instance(k).classValue() == (double)j ? 1.0 : 0.0;
                    ++i;
                    ++k;
                }
            }
            for (int x = 0; x < this.m_models.size(); ++x) {
                for (i = 0; i < numInstances; ++i) {
                    int j2;
                    double[] pred = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
                    double predSum = 0.0;
                    Classifier[] model = (Classifier[])this.m_models.elementAt(x);
                    for (j2 = 0; j2 < RacedIncrementalLogitBoost.this.m_NumClasses; ++j2) {
                        pred[j2] = model[j2].classifyInstance(boostData.instance(i));
                        predSum += pred[j2];
                    }
                    predSum /= (double)RacedIncrementalLogitBoost.this.m_NumClasses;
                    for (j2 = 0; j2 < RacedIncrementalLogitBoost.this.m_NumClasses; ++j2) {
                        double[] dArray = trainFs[i];
                        int n = j2;
                        dArray[n] = dArray[n] + (pred[j2] - predSum) * (double)(RacedIncrementalLogitBoost.this.m_NumClasses - 1) / (double)RacedIncrementalLogitBoost.this.m_NumClasses;
                    }
                }
            }
            for (j = 0; j < RacedIncrementalLogitBoost.this.m_NumClasses; ++j) {
                for (int i2 = 0; i2 < numInstances; ++i2) {
                    double z;
                    double p = RacedIncrementalLogitBoost.RtoP(trainFs[i2], j);
                    Instance current = boostData.instance(i2);
                    double actual = trainYs[i2][j];
                    if (actual == 1.0) {
                        z = 1.0 / p;
                        if (z > 4.0) {
                            z = 4.0;
                        }
                    } else if (actual == 0.0) {
                        z = -1.0 / (1.0 - p);
                        if (z < -4.0) {
                            z = -4.0;
                        }
                    } else {
                        z = (actual - p) / (p * (1.0 - p));
                    }
                    double w = (actual - p) / z;
                    current.setValue(classIndex, z);
                    current.setWeight((double)numInstances * w);
                }
                Instances trainData = boostData;
                if (RacedIncrementalLogitBoost.this.m_UseResampling) {
                    double[] weights = new double[boostData.numInstances()];
                    for (int kk = 0; kk < weights.length; ++kk) {
                        weights[kk] = boostData.instance(kk).weight();
                    }
                    trainData = boostData.resampleWithWeights(RacedIncrementalLogitBoost.this.m_RandomInstance, weights);
                }
                newModel[j].buildClassifier(trainData);
            }
            return newModel;
        }

        public String toString() {
            StringBuffer text = new StringBuffer();
            text.append("RacedIncrementalLogitBoost: Best committee on validation data\n");
            text.append("Base classifiers: \n");
            for (int i = 0; i < this.m_models.size(); ++i) {
                text.append("\nModel " + (i + 1));
                Classifier[] cModels = (Classifier[])this.m_models.elementAt(i);
                for (int j = 0; j < RacedIncrementalLogitBoost.this.m_NumClasses; ++j) {
                    text.append("\n\tClass " + (j + 1) + " (" + RacedIncrementalLogitBoost.this.m_ClassAttribute.name() + "=" + RacedIncrementalLogitBoost.this.m_ClassAttribute.value(j) + ")\n\n" + cModels[j].toString() + "\n");
                }
            }
            text.append("Number of models: " + this.m_models.size() + "\n");
            text.append("Chunk size per model: " + this.m_chunkSize + "\n");
            return text.toString();
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5987 $");
        }
    }
}

