/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.Naming;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import weka.core.FastVector;
import weka.core.Option;
import weka.core.Queue;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XMLOptions;
import weka.experiment.Compute;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.experiment.RemoteExperimentEvent;
import weka.experiment.RemoteExperimentListener;
import weka.experiment.RemoteExperimentSubTask;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.TaskStatusInfo;
import weka.experiment.xml.XMLExperiment;

public class RemoteExperiment
extends Experiment {
    static final long serialVersionUID = -7357668825635314937L;
    private FastVector m_listeners = new FastVector();
    protected DefaultListModel m_remoteHosts = new DefaultListModel();
    private Queue m_remoteHostsQueue = new Queue();
    private int[] m_remoteHostsStatus;
    private int[] m_remoteHostFailureCounts;
    protected static final int AVAILABLE = 0;
    protected static final int IN_USE = 1;
    protected static final int CONNECTION_FAILED = 2;
    protected static final int SOME_OTHER_FAILURE = 3;
    protected static final int MAX_FAILURES = 3;
    private boolean m_experimentAborted = false;
    private int m_removedHosts;
    private int m_failedCount;
    private int m_finishedCount;
    private Experiment m_baseExperiment = null;
    protected Experiment[] m_subExperiments;
    private Queue m_subExpQueue = new Queue();
    protected int[] m_subExpComplete;
    protected boolean m_splitByDataSet = true;

    public boolean getSplitByDataSet() {
        return this.m_splitByDataSet;
    }

    public void setSplitByDataSet(boolean sd) {
        this.m_splitByDataSet = sd;
    }

    public RemoteExperiment() throws Exception {
        this(new Experiment());
    }

    public RemoteExperiment(Experiment base) throws Exception {
        this.setBaseExperiment(base);
    }

    public void addRemoteExperimentListener(RemoteExperimentListener r) {
        this.m_listeners.addElement(r);
    }

    public Experiment getBaseExperiment() {
        return this.m_baseExperiment;
    }

    public void setBaseExperiment(Experiment base) throws Exception {
        if (base == null) {
            throw new Exception("Base experiment is null!");
        }
        this.m_baseExperiment = base;
        this.setRunLower(this.m_baseExperiment.getRunLower());
        this.setRunUpper(this.m_baseExperiment.getRunUpper());
        this.setResultListener(this.m_baseExperiment.getResultListener());
        this.setResultProducer(this.m_baseExperiment.getResultProducer());
        this.setDatasets(this.m_baseExperiment.getDatasets());
        this.setUsePropertyIterator(this.m_baseExperiment.getUsePropertyIterator());
        this.setPropertyPath(this.m_baseExperiment.getPropertyPath());
        this.setPropertyArray(this.m_baseExperiment.getPropertyArray());
        this.setNotes(this.m_baseExperiment.getNotes());
        this.m_ClassFirst = this.m_baseExperiment.m_ClassFirst;
        this.m_AdvanceDataSetFirst = this.m_baseExperiment.m_AdvanceDataSetFirst;
    }

    public void setNotes(String newNotes) {
        super.setNotes(newNotes);
        this.m_baseExperiment.setNotes(newNotes);
    }

    public void setRunLower(int newRunLower) {
        super.setRunLower(newRunLower);
        this.m_baseExperiment.setRunLower(newRunLower);
    }

    public void setRunUpper(int newRunUpper) {
        super.setRunUpper(newRunUpper);
        this.m_baseExperiment.setRunUpper(newRunUpper);
    }

    public void setResultListener(ResultListener newResultListener) {
        super.setResultListener(newResultListener);
        this.m_baseExperiment.setResultListener(newResultListener);
    }

    public void setResultProducer(ResultProducer newResultProducer) {
        super.setResultProducer(newResultProducer);
        this.m_baseExperiment.setResultProducer(newResultProducer);
    }

    public void setDatasets(DefaultListModel ds) {
        super.setDatasets(ds);
        this.m_baseExperiment.setDatasets(ds);
    }

    public void setUsePropertyIterator(boolean newUsePropertyIterator) {
        super.setUsePropertyIterator(newUsePropertyIterator);
        this.m_baseExperiment.setUsePropertyIterator(newUsePropertyIterator);
    }

    public void setPropertyPath(PropertyNode[] newPropertyPath) {
        super.setPropertyPath(newPropertyPath);
        this.m_baseExperiment.setPropertyPath(newPropertyPath);
    }

    public void setPropertyArray(Object newPropArray) {
        super.setPropertyArray(newPropArray);
        this.m_baseExperiment.setPropertyArray(newPropArray);
    }

    public void initialize() throws Exception {
        if (this.m_baseExperiment == null) {
            throw new Exception("No base experiment specified!");
        }
        this.m_experimentAborted = false;
        this.m_finishedCount = 0;
        this.m_failedCount = 0;
        this.m_RunNumber = this.getRunLower();
        this.m_DatasetNumber = 0;
        this.m_PropertyNumber = 0;
        this.m_CurrentProperty = -1;
        this.m_CurrentInstances = null;
        this.m_Finished = false;
        if (this.m_remoteHosts.size() == 0) {
            throw new Exception("No hosts specified!");
        }
        this.m_remoteHostsStatus = new int[this.m_remoteHosts.size()];
        this.m_remoteHostFailureCounts = new int[this.m_remoteHosts.size()];
        this.m_remoteHostsQueue = new Queue();
        for (int i = 0; i < this.m_remoteHosts.size(); ++i) {
            this.m_remoteHostsQueue.push(new Integer(i));
        }
        this.m_subExpQueue = new Queue();
        int numExps = this.getSplitByDataSet() ? this.m_baseExperiment.getDatasets().size() : this.getRunUpper() - this.getRunLower() + 1;
        this.m_subExperiments = new Experiment[numExps];
        this.m_subExpComplete = new int[numExps];
        SerializedObject so = new SerializedObject(this.m_baseExperiment);
        if (this.getSplitByDataSet()) {
            for (int i = 0; i < this.m_baseExperiment.getDatasets().size(); ++i) {
                this.m_subExperiments[i] = (Experiment)so.getObject();
                DefaultListModel temp = new DefaultListModel();
                temp.addElement(this.m_baseExperiment.getDatasets().elementAt(i));
                this.m_subExperiments[i].setDatasets(temp);
                this.m_subExpQueue.push(new Integer(i));
            }
        } else {
            for (int i = this.getRunLower(); i <= this.getRunUpper(); ++i) {
                this.m_subExperiments[i - this.getRunLower()] = (Experiment)so.getObject();
                this.m_subExperiments[i - this.getRunLower()].setRunLower(i);
                this.m_subExperiments[i - this.getRunLower()].setRunUpper(i);
                this.m_subExpQueue.push(new Integer(i - this.getRunLower()));
            }
        }
    }

    private synchronized void notifyListeners(boolean status, boolean log, boolean finished, String message) {
        if (this.m_listeners.size() > 0) {
            for (int i = 0; i < this.m_listeners.size(); ++i) {
                RemoteExperimentListener r = (RemoteExperimentListener)this.m_listeners.elementAt(i);
                r.remoteExperimentStatus(new RemoteExperimentEvent(status, log, finished, message));
            }
        } else {
            System.err.println(message);
        }
    }

    public void abortExperiment() {
        this.m_experimentAborted = true;
    }

    protected synchronized void incrementFinished() {
        ++this.m_finishedCount;
    }

    protected synchronized void incrementFailed(int hostNum) {
        ++this.m_failedCount;
        int n = hostNum;
        this.m_remoteHostFailureCounts[n] = this.m_remoteHostFailureCounts[n] + 1;
    }

    protected synchronized void waitingExperiment(int expNum) {
        this.m_subExpQueue.push(new Integer(expNum));
    }

    private boolean checkForAllFailedHosts() {
        boolean allbad = true;
        for (int i = 0; i < this.m_remoteHostsStatus.length; ++i) {
            if (this.m_remoteHostsStatus[i] == 2) continue;
            allbad = false;
            break;
        }
        if (allbad) {
            this.abortExperiment();
            this.notifyListeners(false, true, true, "Experiment aborted! All connections to remote hosts failed.");
        }
        return allbad;
    }

    private String postExperimentInfo() {
        StringBuffer text = new StringBuffer();
        text.append(this.m_finishedCount + (this.m_splitByDataSet ? " data sets" : " runs") + " completed successfully. " + this.m_failedCount + " failures during running.\n");
        System.err.print(text.toString());
        return text.toString();
    }

    protected synchronized void availableHost(int hostNum) {
        if (hostNum >= 0) {
            if (this.m_remoteHostFailureCounts[hostNum] < 3) {
                this.m_remoteHostsQueue.push(new Integer(hostNum));
            } else {
                this.notifyListeners(false, true, false, "Max failures exceeded for host " + (String)this.m_remoteHosts.elementAt(hostNum) + ". Removed from host list.");
                ++this.m_removedHosts;
            }
        }
        if (this.m_failedCount == 3 * this.m_remoteHosts.size()) {
            this.abortExperiment();
            this.notifyListeners(false, true, true, "Experiment aborted! Max failures exceeded on all remote hosts.");
            return;
        }
        if (this.getSplitByDataSet() && this.m_baseExperiment.getDatasets().size() == this.m_finishedCount || !this.getSplitByDataSet() && this.getRunUpper() - this.getRunLower() + 1 == this.m_finishedCount) {
            this.notifyListeners(false, true, false, "Experiment completed successfully.");
            this.notifyListeners(false, true, true, this.postExperimentInfo());
            return;
        }
        if (this.checkForAllFailedHosts()) {
            return;
        }
        if (this.m_experimentAborted && this.m_remoteHostsQueue.size() + this.m_removedHosts == this.m_remoteHosts.size()) {
            this.notifyListeners(false, true, true, "Experiment aborted. All remote tasks finished.");
        }
        if (!(this.m_subExpQueue.empty() || this.m_experimentAborted || this.m_remoteHostsQueue.empty())) {
            try {
                int availHost = (Integer)this.m_remoteHostsQueue.pop();
                int waitingExp = (Integer)this.m_subExpQueue.pop();
                this.launchNext(waitingExp, availHost);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void launchNext(final int wexp, final int ah) {
        Thread subExpThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                ((RemoteExperiment)RemoteExperiment.this).m_remoteHostsStatus[ah] = 1;
                RemoteExperiment.this.m_subExpComplete[wexp] = 1;
                RemoteExperimentSubTask expSubTsk = new RemoteExperimentSubTask();
                expSubTsk.setExperiment(RemoteExperiment.this.m_subExperiments[wexp]);
                String subTaskType = RemoteExperiment.this.getSplitByDataSet() ? "dataset :" + ((File)RemoteExperiment.this.m_subExperiments[wexp].getDatasets().elementAt(0)).getName() : "run :" + RemoteExperiment.this.m_subExperiments[wexp].getRunLower();
                try {
                    try {
                        String name = "//" + (String)RemoteExperiment.this.m_remoteHosts.elementAt(ah) + "/RemoteEngine";
                        Compute comp = (Compute)Naming.lookup(name);
                        RemoteExperiment.this.notifyListeners(false, true, false, "Starting " + subTaskType + " on host " + (String)RemoteExperiment.this.m_remoteHosts.elementAt(ah));
                        Object subTaskId = comp.executeTask(expSubTsk);
                        boolean finished = false;
                        TaskStatusInfo is = null;
                        while (!finished) {
                            try {
                                Thread.sleep(2000L);
                                TaskStatusInfo cs = (TaskStatusInfo)comp.checkStatus(subTaskId);
                                if (cs.getExecutionStatus() == 3) {
                                    RemoteExperiment.this.notifyListeners(false, true, false, cs.getStatusMessage());
                                    ((RemoteExperiment)RemoteExperiment.this).m_remoteHostsStatus[ah] = 0;
                                    RemoteExperiment.this.incrementFinished();
                                    RemoteExperiment.this.availableHost(ah);
                                    finished = true;
                                    continue;
                                }
                                if (cs.getExecutionStatus() == 2) {
                                    RemoteExperiment.this.notifyListeners(false, true, false, cs.getStatusMessage());
                                    ((RemoteExperiment)RemoteExperiment.this).m_remoteHostsStatus[ah] = 3;
                                    RemoteExperiment.this.m_subExpComplete[wexp] = 2;
                                    RemoteExperiment.this.notifyListeners(false, true, false, subTaskType + " " + cs.getStatusMessage() + ". Scheduling for execution on another host.");
                                    RemoteExperiment.this.incrementFailed(ah);
                                    RemoteExperiment.this.waitingExperiment(wexp);
                                    RemoteExperiment.this.availableHost(ah);
                                    finished = true;
                                    continue;
                                }
                                if (is == null) {
                                    is = cs;
                                    RemoteExperiment.this.notifyListeners(false, true, false, cs.getStatusMessage());
                                    continue;
                                }
                                if (cs.getStatusMessage().compareTo(is.getStatusMessage()) != 0) {
                                    RemoteExperiment.this.notifyListeners(false, true, false, cs.getStatusMessage());
                                }
                                is = cs;
                            }
                            catch (InterruptedException ie) {}
                        }
                        Object var10_11 = null;
                    }
                    catch (Exception ce) {
                        ((RemoteExperiment)RemoteExperiment.this).m_remoteHostsStatus[ah] = 2;
                        RemoteExperiment.this.m_subExpComplete[wexp] = 0;
                        System.err.println(ce);
                        ce.printStackTrace();
                        RemoteExperiment.this.notifyListeners(false, true, false, "Connection to " + (String)RemoteExperiment.this.m_remoteHosts.elementAt(ah) + " failed. Scheduling " + subTaskType + " for execution on another host.");
                        RemoteExperiment.this.checkForAllFailedHosts();
                        RemoteExperiment.this.waitingExperiment(wexp);
                        Object var10_12 = null;
                        if (!this.isInterrupted()) return;
                        System.err.println("Sub exp Interupted!");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    if (!this.isInterrupted()) throw throwable;
                    System.err.println("Sub exp Interupted!");
                    throw throwable;
                }
                if (!this.isInterrupted()) return;
                System.err.println("Sub exp Interupted!");
            }
        };
        subExpThread.setPriority(1);
        subExpThread.start();
    }

    public void nextIteration() throws Exception {
    }

    public void advanceCounters() {
    }

    public void postProcess() {
    }

    public void addRemoteHost(String hostname) {
        this.m_remoteHosts.addElement(hostname);
    }

    public DefaultListModel getRemoteHosts() {
        return this.m_remoteHosts;
    }

    public void setRemoteHosts(DefaultListModel list) {
        this.m_remoteHosts = list;
    }

    public String toString() {
        String result = this.m_baseExperiment.toString();
        result = result + "\nRemote Hosts:\n";
        for (int i = 0; i < this.m_remoteHosts.size(); ++i) {
            result = result + (String)this.m_remoteHosts.elementAt(i) + '\n';
        }
        return result;
    }

    public void runExperiment() {
        int totalHosts = this.m_remoteHostsQueue.size();
        for (int i = 0; i < totalHosts; ++i) {
            this.availableHost(-1);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        try {
            RemoteExperiment exp = null;
            String xmlOption = Utils.getOption("xml", args);
            if (!xmlOption.equals("")) {
                args = new XMLOptions(xmlOption).toArray();
            }
            Experiment base = null;
            String expFile = Utils.getOption('l', args);
            String saveFile = Utils.getOption('s', args);
            boolean runExp = Utils.getFlag('r', args);
            FastVector<String> remoteHosts = new FastVector<String>();
            String runHost = " ";
            while (runHost.length() != 0) {
                runHost = Utils.getOption('h', args);
                if (runHost.length() == 0) continue;
                remoteHosts.addElement(runHost);
            }
            if (expFile.length() == 0) {
                base = new Experiment();
                try {
                    base.setOptions(args);
                    Utils.checkForRemainingOptions(args);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    String result = "Usage:\n\n-l <exp file>\n\tLoad experiment from file (default use cli options)\n-s <exp file>\n\tSave experiment to file after setting other options\n\t(default don't save)\n-h <remote host name>\n\tHost to run experiment on (may be specified more than once\n\tfor multiple remote hosts)\n-r \n\tRun experiment on (default don't run)\n-xml <filename | xml-string>\n\tget options from XML-Data instead from parameters\n\n";
                    Enumeration enm = base.listOptions();
                    while (enm.hasMoreElements()) {
                        Option option = (Option)enm.nextElement();
                        result = result + option.synopsis() + "\n";
                        result = result + option.description() + "\n";
                    }
                    throw new Exception(result + "\n" + ex.getMessage());
                }
            } else {
                Object tmp;
                if (KOML.isPresent() && expFile.toLowerCase().endsWith(".koml")) {
                    tmp = KOML.read(expFile);
                } else if (expFile.toLowerCase().endsWith(".xml")) {
                    XMLExperiment xml = new XMLExperiment();
                    tmp = xml.read(expFile);
                } else {
                    FileInputStream fi = new FileInputStream(expFile);
                    ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(fi));
                    tmp = oi.readObject();
                    oi.close();
                }
                if (tmp instanceof RemoteExperiment) {
                    exp = (RemoteExperiment)tmp;
                } else {
                    base = (Experiment)tmp;
                }
            }
            if (base != null) {
                exp = new RemoteExperiment(base);
            }
            for (int i = 0; i < remoteHosts.size(); ++i) {
                exp.addRemoteHost((String)remoteHosts.elementAt(i));
            }
            System.err.println("Experiment:\n" + exp.toString());
            if (saveFile.length() != 0) {
                if (KOML.isPresent() && saveFile.toLowerCase().endsWith(".koml")) {
                    KOML.write(saveFile, (Object)exp);
                } else if (saveFile.toLowerCase().endsWith(".xml")) {
                    XMLExperiment xml = new XMLExperiment();
                    xml.write(saveFile, (Object)exp);
                } else {
                    FileOutputStream fo = new FileOutputStream(saveFile);
                    ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(fo));
                    oo.writeObject(exp);
                    oo.close();
                }
            }
            if (runExp) {
                System.err.println("Initializing...");
                exp.initialize();
                System.err.println("Iterating...");
                exp.runExperiment();
                System.err.println("Postprocessing...");
                exp.postProcess();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

