/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import weka.core.Memory;
import weka.core.Utils;
import weka.gui.visualize.VisualizeUtils;

public class MemoryUsagePanel
extends JPanel {
    private static final long serialVersionUID = -4812319791687471721L;
    protected static String PROPERTY_FILE = "weka/gui/MemoryUsage.props";
    protected static Properties PROPERTIES;
    protected Vector<Double> m_History;
    protected Memory m_Memory = new Memory();
    protected MemoryMonitor m_Monitor;
    protected JButton m_ButtonGC;
    protected Vector<Double> m_Percentages;
    protected Hashtable<Double, Color> m_Colors;
    protected Color m_DefaultColor;
    protected Color m_BackgroundColor;
    protected Point m_FrameLocation;

    public MemoryUsagePanel() {
        int interval;
        int left;
        int top;
        int width;
        int height;
        String[] percs;
        this.m_History = new Vector();
        this.m_Percentages = new Vector();
        this.m_Colors = new Hashtable();
        this.m_BackgroundColor = this.parseColor("BackgroundColor", Color.WHITE);
        this.m_DefaultColor = this.parseColor("DefaultColor", Color.GREEN);
        for (String perc2 : percs = PROPERTIES.getProperty("Percentages", "70,80,90").split(",")) {
            if (PROPERTIES.getProperty(perc2) != null) {
                double perc;
                try {
                    perc = Double.parseDouble(perc2);
                }
                catch (Exception e) {
                    System.err.println("MemoryUsagePanel: cannot parse percentage '" + perc2 + "' - ignored!");
                    continue;
                }
                Color color = this.parseColor(perc2, null);
                if (color == null) continue;
                this.m_Percentages.add(perc);
                this.m_Colors.put(perc, color);
                continue;
            }
            System.err.println("MemoryUsagePanel: cannot find color for percentage '" + perc2 + "' - ignored!");
        }
        Collections.sort(this.m_Percentages);
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "East");
        this.m_ButtonGC = new JButton("GC");
        this.m_ButtonGC.setToolTipText("Runs the garbage collector.");
        this.m_ButtonGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.gc();
            }
        });
        panel.add((Component)this.m_ButtonGC, "North");
        try {
            height = Integer.parseInt(PROPERTIES.getProperty("Height", "" + (int)this.m_ButtonGC.getPreferredSize().getHeight()));
            width = Integer.parseInt(PROPERTIES.getProperty("Width", "400"));
        }
        catch (Exception e) {
            System.err.println("MemoryUsagePanel: Problem parsing the dimensions - " + e);
            height = (int)this.m_ButtonGC.getPreferredSize().getHeight();
            width = 400;
        }
        this.setPreferredSize(new Dimension(width, height));
        try {
            top = Integer.parseInt(PROPERTIES.getProperty("Top", "0"));
            left = Integer.parseInt(PROPERTIES.getProperty("Left", "0"));
        }
        catch (Exception e) {
            System.err.println("MemoryUsagePanel: Problem parsing the position - " + e);
            top = 0;
            left = 0;
        }
        this.m_FrameLocation = new Point(left, top);
        try {
            interval = Integer.parseInt(PROPERTIES.getProperty("Interval", "1000"));
        }
        catch (Exception e) {
            System.err.println("MemoryUsagePanel: Problem parsing the refresh interval - " + e);
            interval = 1000;
        }
        this.m_Monitor = new MemoryMonitor();
        this.m_Monitor.setInterval(interval);
        this.m_Monitor.setPriority(10);
        this.m_Monitor.start();
    }

    protected Color parseColor(String prop, Color defValue) {
        Color result = defValue;
        try {
            String colorStr = PROPERTIES.getProperty(prop);
            Color color = VisualizeUtils.processColour(colorStr, result);
            if (color == null) {
                throw new Exception(colorStr);
            }
            result = color;
        }
        catch (Exception e) {
            System.err.println("MemoryUsagePanel: cannot parse color '" + e.getMessage() + "' - ignored!");
        }
        return result;
    }

    public boolean isMonitoring() {
        return this.m_Monitor.isMonitoring();
    }

    public void stopMonitoring() {
        this.m_Monitor.stopMonitoring();
    }

    public Point getFrameLocation() {
        return this.m_FrameLocation;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.m_BackgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double scale = (double)this.getHeight() / 100.0;
        for (int i = 0; i < this.m_History.size(); ++i) {
            double perc = this.m_History.get(i);
            Color color = this.m_DefaultColor;
            for (int n = this.m_Percentages.size() - 1; n >= 0; --n) {
                if (!(perc >= this.m_Percentages.get(n))) continue;
                color = this.m_Colors.get(this.m_Percentages.get(n));
                break;
            }
            g.setColor(color);
            int len = (int)Math.round(perc * scale);
            g.drawLine(i, this.getHeight() - 1, i, this.getHeight() - len);
        }
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            Enumeration<?> keys = PROPERTIES.propertyNames();
            if (!keys.hasMoreElements()) {
                throw new Exception("Failed to read a property file for the memory usage panel");
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not read a configuration file for the memory usage\npanel. An example file is included with the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\" and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "MemoryUsagePanel", 0);
        }
    }

    protected class MemoryMonitor
    extends Thread {
        protected int m_Interval;
        protected boolean m_Monitoring;

        public MemoryMonitor() {
            this.setInterval(1000);
        }

        public int getInterval() {
            return this.m_Interval;
        }

        public void setInterval(int value) {
            this.m_Interval = value;
        }

        public boolean isMonitoring() {
            return this.m_Monitoring;
        }

        public void stopMonitoring() {
            this.m_Monitoring = false;
        }

        @Override
        public void run() {
            this.m_Monitoring = true;
            while (this.m_Monitoring) {
                try {
                    Thread.sleep(this.m_Interval);
                    if (!this.m_Monitoring) continue;
                    Runnable doUpdate = new Runnable(){

                        @Override
                        public void run() {
                            MemoryMonitor.this.update();
                        }
                    };
                    SwingUtilities.invokeLater(doUpdate);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }

        protected void update() {
            double perc = (double)MemoryUsagePanel.this.m_Memory.getCurrent() / (double)MemoryUsagePanel.this.m_Memory.getMax();
            perc = Math.round(perc * 1000.0) / 10L;
            MemoryUsagePanel.this.setToolTipText("" + perc + "% used");
            MemoryUsagePanel.this.m_History.insertElementAt(perc, 0);
            Dimension size = MemoryUsagePanel.this.getSize();
            while ((double)MemoryUsagePanel.this.m_History.size() > size.getWidth()) {
                MemoryUsagePanel.this.m_History.remove(MemoryUsagePanel.this.m_History.size() - 1);
            }
            MemoryUsagePanel.this.repaint();
        }
    }
}

