/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Collection;
import weka.associations.AssociationRule;
import weka.associations.Item;
import weka.core.Tag;
import weka.core.Utils;

public class DefaultAssociationRule
extends AssociationRule
implements Serializable {
    private static final long serialVersionUID = -661269018702294489L;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(METRIC_TYPE.CONFIDENCE.ordinal(), "Confidence"), new Tag(METRIC_TYPE.LIFT.ordinal(), "Lift"), new Tag(METRIC_TYPE.LEVERAGE.ordinal(), "Leverage"), new Tag(METRIC_TYPE.CONVICTION.ordinal(), "Conviction")};
    protected METRIC_TYPE m_metricType = METRIC_TYPE.CONFIDENCE;
    protected Collection<Item> m_premise;
    protected Collection<Item> m_consequence;
    protected int m_premiseSupport;
    protected int m_consequenceSupport;
    protected int m_totalSupport;
    protected int m_totalTransactions;

    public DefaultAssociationRule(Collection<Item> premise, Collection<Item> consequence, METRIC_TYPE metric, int premiseSupport, int consequenceSupport, int totalSupport, int totalTransactions) {
        this.m_premise = premise;
        this.m_consequence = consequence;
        this.m_metricType = metric;
        this.m_premiseSupport = premiseSupport;
        this.m_consequenceSupport = consequenceSupport;
        this.m_totalSupport = totalSupport;
        this.m_totalTransactions = totalTransactions;
    }

    @Override
    public Collection<Item> getPremise() {
        return this.m_premise;
    }

    @Override
    public Collection<Item> getConsequence() {
        return this.m_consequence;
    }

    @Override
    public String getPrimaryMetricName() {
        return TAGS_SELECTION[this.m_metricType.ordinal()].getReadable();
    }

    @Override
    public double getPrimaryMetricValue() {
        return this.m_metricType.compute(this.m_premiseSupport, this.m_consequenceSupport, this.m_totalSupport, this.m_totalTransactions);
    }

    @Override
    public double getNamedMetricValue(String metricName) throws Exception {
        METRIC_TYPE requested = null;
        for (METRIC_TYPE m : METRIC_TYPE.values()) {
            if (!TAGS_SELECTION[m.ordinal()].getReadable().equals(metricName)) continue;
            requested = m;
        }
        if (requested == null) {
            throw new Exception("[AssociationRule] Unknown metric: " + metricName);
        }
        return requested.compute(this.m_premiseSupport, this.m_consequenceSupport, this.m_totalSupport, this.m_totalTransactions);
    }

    @Override
    public int getNumberOfMetricsForRule() {
        return METRIC_TYPE.values().length;
    }

    @Override
    public String[] getMetricNamesForRule() {
        String[] metricNames = new String[TAGS_SELECTION.length];
        for (int i = 0; i < TAGS_SELECTION.length; ++i) {
            metricNames[i] = TAGS_SELECTION[i].getReadable();
        }
        return metricNames;
    }

    @Override
    public double[] getMetricValuesForRule() throws Exception {
        double[] values = new double[TAGS_SELECTION.length];
        for (int i = 0; i < TAGS_SELECTION.length; ++i) {
            values[i] = this.getNamedMetricValue(TAGS_SELECTION[i].getReadable());
        }
        return values;
    }

    @Override
    public int getPremiseSupport() {
        return this.m_premiseSupport;
    }

    @Override
    public int getConsequenceSupport() {
        return this.m_consequenceSupport;
    }

    @Override
    public int getTotalSupport() {
        return this.m_totalSupport;
    }

    @Override
    public int getTotalTransactions() {
        return this.m_totalTransactions;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.m_premise.toString() + ": " + this.m_premiseSupport + " ==> " + this.m_consequence.toString() + ": " + this.m_totalSupport + "   ");
        for (METRIC_TYPE m : METRIC_TYPE.values()) {
            if (m.equals((Object)this.m_metricType)) {
                result.append("<" + m.toStringMetric(this.m_premiseSupport, this.m_consequenceSupport, this.m_totalSupport, this.m_totalTransactions) + "> ");
                continue;
            }
            result.append("" + m.toStringMetric(this.m_premiseSupport, this.m_consequenceSupport, this.m_totalSupport, this.m_totalTransactions) + " ");
        }
        return result.toString();
    }

    public static enum METRIC_TYPE {
        CONFIDENCE("conf"){

            @Override
            double compute(int premiseSupport, int consequenceSupport, int totalSupport, int totalTransactions) {
                return (double)totalSupport / (double)premiseSupport;
            }
        }
        ,
        LIFT("lift"){

            @Override
            double compute(int premiseSupport, int consequenceSupport, int totalSupport, int totalTransactions) {
                double confidence = CONFIDENCE.compute(premiseSupport, consequenceSupport, totalSupport, totalTransactions);
                return confidence / ((double)consequenceSupport / (double)totalTransactions);
            }
        }
        ,
        LEVERAGE("lev"){

            @Override
            double compute(int premiseSupport, int consequenceSupport, int totalSupport, int totalTransactions) {
                double coverageForItemSet = (double)totalSupport / (double)totalTransactions;
                double expectedCoverageIfIndependent = (double)premiseSupport / (double)totalTransactions * ((double)consequenceSupport / (double)totalTransactions);
                return coverageForItemSet - expectedCoverageIfIndependent;
            }
        }
        ,
        CONVICTION("conv"){

            @Override
            double compute(int premiseSupport, int consequenceSupport, int totalSupport, int totalTransactions) {
                double num = (double)premiseSupport * (double)(totalTransactions - consequenceSupport) / (double)totalTransactions;
                double denom = premiseSupport - totalSupport + 1;
                return num / denom;
            }
        };

        private final String m_stringVal;

        private METRIC_TYPE(String name) {
            this.m_stringVal = name;
        }

        abstract double compute(int var1, int var2, int var3, int var4);

        public String toString() {
            return this.m_stringVal;
        }

        public String toStringMetric(int premiseSupport, int consequenceSupport, int totalSupport, int totalTransactions) {
            return this.m_stringVal + ":(" + Utils.doubleToString(this.compute(premiseSupport, consequenceSupport, totalSupport, totalTransactions), 2) + ")";
        }

        public String toXML(int premiseSupport, int consequenceSupport, int totalSupport, int totalTransactions) {
            String result = "<CRITERE name=\"" + this.m_stringVal + "\" value=\" " + Utils.doubleToString(this.compute(premiseSupport, consequenceSupport, totalSupport, totalTransactions), 2) + "\"/>";
            return result;
        }
    }
}

