/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class MergeManyValues
extends PotentialClassIgnorer
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    private static final long serialVersionUID = 4649332102154713625L;
    protected SingleIndex m_AttIndex = new SingleIndex("last");
    protected String m_Label = "merged";
    protected Range m_MergeRange = new Range("1,2");

    public String globalInfo() {
        return "Merges many values of a nominal attribute into one value.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tSets the attribute index\n\t(default: last)", "C", 1, "-C <col>"));
        newVector.addElement(new Option("\tSets the label of the newly merged classes\n\t(default: 'merged')", "L", 1, "-L <label>"));
        newVector.addElement(new Option("\tSets the merge range. 'first and 'last' are accepted as well.'\n\tE.g.: first-5,7,9,20-last\n\t(default: 1,2)", "R", 1, "-R <range>"));
        Enumeration<Option> superOpts = super.listOptions();
        while (superOpts.hasMoreElements()) {
            newVector.add(superOpts.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndex(tmpStr);
        } else {
            this.setAttributeIndex("last");
        }
        tmpStr = Utils.getOption('L', options);
        if (tmpStr.length() != 0) {
            this.setLabel(tmpStr);
        } else {
            this.setLabel("merged");
        }
        tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setMergeValueRange(tmpStr);
        } else {
            this.setMergeValueRange("1,2");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-C");
        result.add(this.getAttributeIndex());
        result.add("-L");
        result.add(this.getLabel());
        result.add("-R");
        result.add(this.getMergeValueRange());
        String[] superOpts = super.getOptions();
        result.addAll(Arrays.asList(superOpts));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(this.inputFormatPeek().numAttributes() - 1);
        this.m_MergeRange.setUpper(this.inputFormatPeek().attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (this.inputFormatPeek().classIndex() > -1 && this.inputFormatPeek().classIndex() == this.m_AttIndex.getIndex()) {
            throw new Exception("Cannot process class attribute.");
        }
        if (!this.inputFormatPeek().attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not nominal.");
        }
        if (this.inputFormatPeek().attribute(this.m_AttIndex.getIndex()).numValues() < 2) {
            throw new UnsupportedAttributeTypeException("Chosen attribute has less than two values.");
        }
        this.setOutputFormat();
        return true;
    }

    private void setOutputFormat() {
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>(this.getInputFormat().numAttributes());
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (j != this.m_AttIndex.getIndex()) {
                newAtts.add((Attribute)att.copy());
                continue;
            }
            ArrayList<String> newVals = new ArrayList<String>(att.numValues() - 1);
            for (int i = 0; i < att.numValues(); ++i) {
                boolean inMergeList = false;
                inMergeList = att.value(i).equalsIgnoreCase(this.m_Label) ? true : this.m_MergeRange.isInRange(i);
                if (inMergeList) continue;
                newVals.add(att.value(i));
            }
            newVals.add(this.m_Label);
            Attribute newAtt = new Attribute(att.name(), newVals);
            newAtt.setWeight(this.getInputFormat().attribute(j).weight());
            newAtts.add(newAtt);
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(newData);
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Attribute att = this.getInputFormat().attribute(this.m_AttIndex.getIndex());
        ArrayList<String> newVals = new ArrayList<String>(att.numValues() - 1);
        for (int i = 0; i < att.numValues(); ++i) {
            boolean inMergeList = false;
            inMergeList = att.value(i).equalsIgnoreCase(this.m_Label) ? true : this.m_MergeRange.isInRange(i);
            if (inMergeList) continue;
            newVals.add(att.value(i));
        }
        newVals.add(this.m_Label);
        Attribute temp = new Attribute(att.name(), newVals);
        Instance newInstance = (Instance)instance.copy();
        if (!newInstance.isMissing(this.m_AttIndex.getIndex())) {
            String currValue = newInstance.stringValue(this.m_AttIndex.getIndex());
            if (temp.indexOfValue(currValue) == -1) {
                newInstance.setValue(this.m_AttIndex.getIndex(), (double)temp.indexOfValue(this.m_Label));
            } else {
                newInstance.setValue(this.m_AttIndex.getIndex(), (double)temp.indexOfValue(currValue));
            }
        }
        this.push(newInstance);
        return true;
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be nominal (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_AttIndex.setSingleIndex(attIndex);
    }

    public String labelTipText() {
        return "The new label for the merged values.";
    }

    public String getLabel() {
        return this.m_Label;
    }

    public void setLabel(String alabel) {
        this.m_Label = alabel;
    }

    public String getMergeValueRange() {
        return this.m_MergeRange.getRanges();
    }

    public String mergeValueRangeTipText() {
        return "The range of values to merge.";
    }

    public void setMergeValueRange(String range) {
        this.m_MergeRange.setRanges(range);
    }

    @Override
    public String getRevision() {
        return "$Revision: 11919 $";
    }

    public static void main(String[] args) {
        MergeManyValues.runFilter(new MergeManyValues(), args);
    }
}

