/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.JSONLoader;
import weka.core.json.JSONInstances;
import weka.core.json.JSONNode;

public class JSONSaver
extends AbstractFileSaver
implements BatchConverter {
    private static final long serialVersionUID = -1047134047244534557L;
    protected SingleIndex m_ClassIndex = new SingleIndex();
    protected boolean m_CompressOutput = false;

    public JSONSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in JSON format.\nThe data can be compressed with gzip, in order to save space.\n\nFor more information, see JSON homepage:\nhttp://www.json.org/";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        result.addElement(new Option("\tThe class index (first and last are valid as well).\n\t(default: last)", "C", 1, "-C <class index>"));
        result.addElement(new Option("\tCompresses the data (uses '" + JSONLoader.FILE_EXTENSION_COMPRESSED + "' as extension instead of '" + JSONLoader.FILE_EXTENSION + "')\n" + "\t(default: off)", "compress", 0, "-compress"));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getClassIndex().length() != 0) {
            result.add("-C");
            result.add(this.getClassIndex());
        }
        if (this.getCompressOutput()) {
            result.add("-compress");
        }
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setClassIndex(tmpStr);
        } else {
            this.setClassIndex("last");
        }
        this.setCompressOutput(Utils.getFlag("compress", options));
        super.setOptions(options);
    }

    public String getFileDescription() {
        return "JSON data files";
    }

    public String[] getFileExtensions() {
        return new String[]{JSONLoader.FILE_EXTENSION, JSONLoader.FILE_EXTENSION_COMPRESSED};
    }

    public void setFile(File outputFile) throws IOException {
        if (outputFile.getAbsolutePath().endsWith(JSONLoader.FILE_EXTENSION_COMPRESSED)) {
            this.setCompressOutput(true);
        }
        super.setFile(outputFile);
    }

    public void resetOptions() {
        super.resetOptions();
        if (this.getCompressOutput()) {
            this.setFileExtension(JSONLoader.FILE_EXTENSION_COMPRESSED);
        } else {
            this.setFileExtension(JSONLoader.FILE_EXTENSION);
        }
    }

    public String classIndexTipText() {
        return "Sets the class index (\"first\" and \"last\" are valid values)";
    }

    public String getClassIndex() {
        return this.m_ClassIndex.getSingleIndex();
    }

    public void setClassIndex(String value) {
        this.m_ClassIndex.setSingleIndex(value);
    }

    public String compressOutputTipText() {
        return "Optional compression of the output data";
    }

    public boolean getCompressOutput() {
        return this.m_CompressOutput;
    }

    public void setCompressOutput(boolean value) {
        this.m_CompressOutput = value;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void setInstances(Instances instances) {
        if (this.m_ClassIndex.getSingleIndex().length() != 0) {
            this.m_ClassIndex.setUpper(instances.numAttributes() - 1);
            instances.setClassIndex(this.m_ClassIndex.getIndex());
        }
        super.setInstances(instances);
    }

    public void setDestination(OutputStream output) throws IOException {
        if (this.getCompressOutput()) {
            super.setDestination(new GZIPOutputStream(output));
        } else {
            super.setDestination(output);
        }
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        PrintWriter outW = this.retrieveFile() == null && this.getWriter() == null ? new PrintWriter(System.out) : new PrintWriter(this.getWriter());
        JSONNode json = JSONInstances.toJSON(this.getInstances());
        StringBuffer buffer = new StringBuffer();
        json.toString(buffer);
        outW.println(buffer.toString());
        outW.flush();
        if (this.getWriter() != null) {
            outW.close();
        }
        this.setWriteMode(1);
        outW = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }

    public static void main(String[] args) {
        JSONSaver.runFileSaver(new JSONSaver(), args);
    }
}

