/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.associations.AssociationRules;
import weka.associations.AssociationRulesProducer;
import weka.associations.Associator;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Drawable;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.plugins.AssociationRuleVisualizePlugin;
import weka.gui.visualize.plugins.TreeVisualizePlugin;

public class AssociationsPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    static final long serialVersionUID = -6867871711865476971L;
    protected Explorer m_Explorer = null;
    protected GenericObjectEditor m_AssociatorEditor = new GenericObjectEditor();
    protected PropertyPanel m_CEPanel = new PropertyPanel(this.m_AssociatorEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    protected SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    protected JCheckBox m_storeOutput = new JCheckBox("Store output for visualization");
    protected Instances m_Instances;
    protected Instances m_TestInstances;
    protected Thread m_RunThread;

    public AssociationsPanel() {
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    AssociationsPanel.this.m_OutText.selectAll();
                }
            }
        });
        this.m_History.setBorder(BorderFactory.createTitledBorder("Result list (right-click for options)"));
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = AssociationsPanel.this.m_History.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        String name = AssociationsPanel.this.m_History.getNameAtIndex(index);
                        AssociationsPanel.this.historyRightClickPopup(name, e.getX(), e.getY());
                    } else {
                        AssociationsPanel.this.historyRightClickPopup(null, e.getX(), e.getY());
                    }
                }
            }
        });
        this.m_AssociatorEditor.setClassType(Associator.class);
        this.m_AssociatorEditor.setValue(ExplorerDefaults.getAssociator());
        this.m_AssociatorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                AssociationsPanel.this.m_StartBut.setEnabled(true);
                Capabilities currentFilter = AssociationsPanel.this.m_AssociatorEditor.getCapabilitiesFilter();
                Associator associator = (Associator)AssociationsPanel.this.m_AssociatorEditor.getValue();
                Capabilities currentSchemeCapabilities = null;
                if (associator != null && currentFilter != null && associator instanceof CapabilitiesHandler && !(currentSchemeCapabilities = ((CapabilitiesHandler)((Object)associator)).getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
                    AssociationsPanel.this.m_StartBut.setEnabled(false);
                }
                AssociationsPanel.this.repaint();
            }
        });
        this.m_StartBut.setToolTipText("Starts the associator");
        this.m_StopBut.setToolTipText("Stops the associator");
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AssociationsPanel.this.startAssociator();
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AssociationsPanel.this.stopAssociator();
            }
        });
        boolean showStoreOutput = GenericObjectEditor.getClassnames(AssociationRuleVisualizePlugin.class.getName()).size() > 0 || GenericObjectEditor.getClassnames(TreeVisualizePlugin.class.getName()).size() > 0;
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Associator"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_CEPanel, "North");
        JPanel buttons = new JPanel();
        buttons.setLayout(new BorderLayout());
        JPanel buttonsP = new JPanel();
        buttonsP.setLayout(new GridLayout(1, 2));
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ssButs.setLayout(new GridLayout(1, 2, 5, 5));
        ssButs.add(this.m_StartBut);
        ssButs.add(this.m_StopBut);
        buttonsP.add(ssButs);
        buttons.add((Component)buttonsP, "South");
        if (showStoreOutput) {
            buttons.add((Component)this.m_storeOutput, "North");
        }
        JPanel p3 = new JPanel();
        p3.setBorder(BorderFactory.createTitledBorder("Associator output"));
        p3.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_OutText);
        p3.add((Component)js, "Center");
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        GridBagLayout gbL = new GridBagLayout();
        GridBagConstraints gbC = new GridBagConstraints();
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(buttons, gbC);
        mondo.add(buttons);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints(this.m_History, gbC);
        mondo.add(this.m_History);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.gridheight = 3;
        gbC.weightx = 100.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        this.setLayout(new BorderLayout());
        this.add((Component)p1, "North");
        this.add((Component)mondo, "Center");
    }

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        String[] attribNames = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < attribNames.length; ++i) {
            String type = "(" + Attribute.typeToStringShort(this.m_Instances.attribute(i)) + ") ";
            attribNames[i] = type + this.m_Instances.attribute(i).name();
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
    }

    protected void startAssociator() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    String cname;
                    block28: {
                        Vector<Object> visVect2222;
                        String name;
                        AssociationRules rulesList;
                        block29: {
                            AssociationsPanel.this.m_Log.statusMessage("Setting up...");
                            Instances inst = new Instances(AssociationsPanel.this.m_Instances);
                            String grph = null;
                            rulesList = null;
                            Associator associator = (Associator)AssociationsPanel.this.m_AssociatorEditor.getValue();
                            StringBuffer outBuff = new StringBuffer();
                            name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                            cname = associator.getClass().getName();
                            name = cname.startsWith("weka.associations.") ? name + cname.substring("weka.associations.".length()) : name + cname;
                            String cmd = AssociationsPanel.this.m_AssociatorEditor.getValue().getClass().getName();
                            if (AssociationsPanel.this.m_AssociatorEditor.getValue() instanceof OptionHandler) {
                                cmd = cmd + " " + Utils.joinOptions(((OptionHandler)AssociationsPanel.this.m_AssociatorEditor.getValue()).getOptions());
                            }
                            try {
                                try {
                                    AssociationsPanel.this.m_Log.logMessage("Started " + cname);
                                    AssociationsPanel.this.m_Log.logMessage("Command: " + cmd);
                                    if (AssociationsPanel.this.m_Log instanceof TaskLogger) {
                                        ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskStarted();
                                    }
                                    outBuff.append("=== Run information ===\n\n");
                                    outBuff.append("Scheme:       " + cname);
                                    if (associator instanceof OptionHandler) {
                                        String[] o = ((OptionHandler)((Object)associator)).getOptions();
                                        outBuff.append(" " + Utils.joinOptions(o));
                                    }
                                    outBuff.append("\n");
                                    outBuff.append("Relation:     " + inst.relationName() + '\n');
                                    outBuff.append("Instances:    " + inst.numInstances() + '\n');
                                    outBuff.append("Attributes:   " + inst.numAttributes() + '\n');
                                    if (inst.numAttributes() < 100) {
                                        for (int i = 0; i < inst.numAttributes(); ++i) {
                                            outBuff.append("              " + inst.attribute(i).name() + '\n');
                                        }
                                    } else {
                                        outBuff.append("              [list of attributes omitted]\n");
                                    }
                                    AssociationsPanel.this.m_History.addResult(name, outBuff);
                                    AssociationsPanel.this.m_History.setSingle(name);
                                    AssociationsPanel.this.m_Log.statusMessage("Building model on training data...");
                                    associator.buildAssociations(inst);
                                    outBuff.append("=== Associator model (full training set) ===\n\n");
                                    outBuff.append(associator.toString() + '\n');
                                    AssociationsPanel.this.m_History.updateResult(name);
                                    if (AssociationsPanel.this.m_storeOutput.isSelected()) {
                                        if (associator instanceof Drawable) {
                                            grph = null;
                                            try {
                                                grph = ((Drawable)((Object)associator)).graph();
                                            }
                                            catch (Exception ex) {
                                                // empty catch block
                                            }
                                        }
                                        if (associator instanceof AssociationRulesProducer) {
                                            rulesList = null;
                                            try {
                                                rulesList = ((AssociationRulesProducer)((Object)associator)).getAssociationRules();
                                            }
                                            catch (Exception ex) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    AssociationsPanel.this.m_Log.logMessage("Finished " + cname);
                                    AssociationsPanel.this.m_Log.statusMessage("OK");
                                }
                                catch (Exception ex) {
                                    AssociationsPanel.this.m_Log.logMessage(ex.getMessage());
                                    AssociationsPanel.this.m_Log.statusMessage("See error log");
                                    Object var11_15 = null;
                                    if (grph != null || rulesList != null) {
                                        Vector<Object> visVect2222 = new Vector<Object>();
                                        if (grph != null) {
                                            visVect2222.add(grph);
                                        }
                                        if (rulesList != null) {
                                            visVect2222.add(rulesList);
                                        }
                                        AssociationsPanel.this.m_History.addObject(name, visVect2222);
                                    }
                                    if (this.isInterrupted()) {
                                        AssociationsPanel.this.m_Log.logMessage("Interrupted " + cname);
                                        AssociationsPanel.this.m_Log.statusMessage("See error log");
                                    }
                                    AssociationsPanel.this.m_RunThread = null;
                                    AssociationsPanel.this.m_StartBut.setEnabled(true);
                                    AssociationsPanel.this.m_StopBut.setEnabled(false);
                                    if (!(AssociationsPanel.this.m_Log instanceof TaskLogger)) return;
                                    ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskFinished();
                                    return;
                                }
                                Object var11_14 = null;
                                if (grph == null && rulesList == null) break block28;
                                visVect2222 = new Vector<Object>();
                                if (grph == null) break block29;
                                visVect2222.add(grph);
                            }
                            catch (Throwable throwable) {
                                Object var11_16 = null;
                                if (grph != null || rulesList != null) {
                                    Vector<Object> visVect2222 = new Vector<Object>();
                                    if (grph != null) {
                                        visVect2222.add(grph);
                                    }
                                    if (rulesList != null) {
                                        visVect2222.add(rulesList);
                                    }
                                    AssociationsPanel.this.m_History.addObject(name, visVect2222);
                                }
                                if (this.isInterrupted()) {
                                    AssociationsPanel.this.m_Log.logMessage("Interrupted " + cname);
                                    AssociationsPanel.this.m_Log.statusMessage("See error log");
                                }
                                AssociationsPanel.this.m_RunThread = null;
                                AssociationsPanel.this.m_StartBut.setEnabled(true);
                                AssociationsPanel.this.m_StopBut.setEnabled(false);
                                if (!(AssociationsPanel.this.m_Log instanceof TaskLogger)) throw throwable;
                                ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskFinished();
                                throw throwable;
                            }
                        }
                        if (rulesList != null) {
                            visVect2222.add(rulesList);
                        }
                        AssociationsPanel.this.m_History.addObject(name, visVect2222);
                    }
                    if (this.isInterrupted()) {
                        AssociationsPanel.this.m_Log.logMessage("Interrupted " + cname);
                        AssociationsPanel.this.m_Log.statusMessage("See error log");
                    }
                    AssociationsPanel.this.m_RunThread = null;
                    AssociationsPanel.this.m_StartBut.setEnabled(true);
                    AssociationsPanel.this.m_StopBut.setEnabled(false);
                    if (!(AssociationsPanel.this.m_Log instanceof TaskLogger)) return;
                    ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskFinished();
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void stopAssociator() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void saveBuffer(String name) {
        StringBuffer sb = this.m_History.getNamedBuffer(name);
        if (sb != null && this.m_SaveOut.save(sb)) {
            this.m_Log.logMessage("Save successful.");
        }
    }

    protected void visualizeTree(String dottyString, String treeName) {
        final JFrame jf = new JFrame("Weka Classifier Tree Visualizer: " + treeName);
        jf.setSize(500, 400);
        jf.getContentPane().setLayout(new BorderLayout());
        TreeVisualizer tv = new TreeVisualizer(null, dottyString, (NodePlace)new PlaceNode2());
        jf.getContentPane().add((Component)tv, "Center");
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                jf.dispose();
            }
        });
        jf.setVisible(true);
        tv.fitToScreen();
    }

    protected void historyRightClickPopup(String name, int x, int y) {
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        JMenuItem visMainBuffer = new JMenuItem("View in main window");
        if (selectedName != null) {
            visMainBuffer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.m_History.setSingle(selectedName);
                }
            });
        } else {
            visMainBuffer.setEnabled(false);
        }
        resultListMenu.add(visMainBuffer);
        JMenuItem visSepBuffer = new JMenuItem("View in separate window");
        if (selectedName != null) {
            visSepBuffer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.m_History.openFrame(selectedName);
                }
            });
        } else {
            visSepBuffer.setEnabled(false);
        }
        resultListMenu.add(visSepBuffer);
        JMenuItem saveOutput = new JMenuItem("Save result buffer");
        if (selectedName != null) {
            saveOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.saveBuffer(selectedName);
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        JMenuItem deleteOutput = new JMenuItem("Delete result buffer");
        if (selectedName != null) {
            deleteOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AssociationsPanel.this.m_History.removeResult(selectedName);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        Vector visVect = null;
        if (selectedName != null) {
            visVect = (Vector)this.m_History.getNamedObject(selectedName);
        }
        JMenu visPlugins = new JMenu("Plugins");
        boolean availablePlugins = false;
        if (visVect != null) {
            for (Object o : visVect) {
                JMenuItem pluginMenuItem;
                Object plugin;
                String className;
                int i;
                Vector<String> pluginsVector;
                if (o instanceof AssociationRules) {
                    pluginsVector = GenericObjectEditor.getClassnames(AssociationRuleVisualizePlugin.class.getName());
                    for (i = 0; i < pluginsVector.size(); ++i) {
                        className = pluginsVector.elementAt(i);
                        try {
                            plugin = (AssociationRuleVisualizePlugin)Class.forName(className).newInstance();
                            if (plugin == null) continue;
                            availablePlugins = true;
                            pluginMenuItem = plugin.getVisualizeMenuItem((AssociationRules)o, selectedName);
                            if (pluginMenuItem == null) continue;
                            visPlugins.add(pluginMenuItem);
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (!(o instanceof String)) continue;
                pluginsVector = GenericObjectEditor.getClassnames(TreeVisualizePlugin.class.getName());
                for (i = 0; i < pluginsVector.size(); ++i) {
                    className = pluginsVector.elementAt(i);
                    try {
                        plugin = (TreeVisualizePlugin)Class.forName(className).newInstance();
                        if (plugin == null) continue;
                        availablePlugins = true;
                        pluginMenuItem = plugin.getVisualizeMenuItem((String)o, selectedName);
                        if (pluginMenuItem == null) continue;
                        visPlugins.add(pluginMenuItem);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        if (availablePlugins) {
            resultListMenu.add(visPlugins);
        }
        resultListMenu.show(this.m_History.getList(), x, y);
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_AssociatorEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(-1);
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_AssociatorEditor.setCapabilitiesFilter(filterClass);
        this.m_StartBut.setEnabled(true);
        Capabilities currentFilter = this.m_AssociatorEditor.getCapabilitiesFilter();
        Associator associator = (Associator)this.m_AssociatorEditor.getValue();
        Capabilities currentSchemeCapabilities = null;
        if (associator != null && currentFilter != null && associator instanceof CapabilitiesHandler && !(currentSchemeCapabilities = ((CapabilitiesHandler)((Object)associator)).getCapabilities()).supportsMaybe(currentFilter) && !currentSchemeCapabilities.supports(currentFilter)) {
            this.m_StartBut.setEnabled(false);
        }
    }

    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    public String getTabTitle() {
        return "Associate";
    }

    public String getTabTitleToolTip() {
        return "Discover association rules";
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Explorer: Associator");
            jf.getContentPane().setLayout(new BorderLayout());
            AssociationsPanel sp = new AssociationsPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog(lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            if (args.length == 1) {
                System.err.println("Loading instances from " + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

