/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.PairedStats;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixCSV;
import weka.experiment.ResultMatrixHTML;
import weka.experiment.ResultMatrixLatex;
import weka.experiment.ResultMatrixPlainText;
import weka.experiment.ResultMatrixSignificance;
import weka.experiment.Tester;

public class PairedTTester
implements OptionHandler,
Tester,
RevisionHandler {
    static final long serialVersionUID = 8370014624008728610L;
    protected Instances m_Instances;
    protected int m_RunColumn = 0;
    protected int m_RunColumnSet = -1;
    protected int m_FoldColumn = -1;
    protected int m_SortColumn = -1;
    protected int[] m_SortOrder = null;
    protected int[] m_ColOrder = null;
    protected double m_SignificanceLevel = 0.05;
    protected Range m_DatasetKeyColumnsRange = new Range();
    protected int[] m_DatasetKeyColumns;
    protected DatasetSpecifiers m_DatasetSpecifiers = new DatasetSpecifiers();
    protected Range m_ResultsetKeyColumnsRange = new Range();
    protected int[] m_ResultsetKeyColumns;
    protected int[] m_DisplayedResultsets = null;
    protected FastVector m_Resultsets = new FastVector();
    protected boolean m_ResultsetsValid;
    protected boolean m_ShowStdDevs = false;
    protected ResultMatrix m_ResultMatrix = new ResultMatrixPlainText();

    protected String templateString(Instance template) {
        String result = "";
        for (int i = 0; i < this.m_DatasetKeyColumns.length; ++i) {
            result = result + template.toString(this.m_DatasetKeyColumns[i]) + ' ';
        }
        if (result.startsWith("weka.classifiers.")) {
            result = result.substring("weka.classifiers.".length());
        }
        return result.trim();
    }

    public void setResultMatrix(ResultMatrix matrix) {
        this.m_ResultMatrix = matrix;
    }

    public ResultMatrix getResultMatrix() {
        return this.m_ResultMatrix;
    }

    public void setShowStdDevs(boolean s) {
        this.m_ShowStdDevs = s;
    }

    public boolean getShowStdDevs() {
        return this.m_ShowStdDevs;
    }

    protected void prepareData() throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances have been set");
        }
        this.m_RunColumn = this.m_RunColumnSet == -1 ? this.m_Instances.numAttributes() - 1 : this.m_RunColumnSet;
        if (this.m_ResultsetKeyColumnsRange == null) {
            throw new Exception("No result specifier columns have been set");
        }
        this.m_ResultsetKeyColumnsRange.setUpper(this.m_Instances.numAttributes() - 1);
        this.m_ResultsetKeyColumns = this.m_ResultsetKeyColumnsRange.getSelection();
        if (this.m_DatasetKeyColumnsRange == null) {
            throw new Exception("No dataset specifier columns have been set");
        }
        this.m_DatasetKeyColumnsRange.setUpper(this.m_Instances.numAttributes() - 1);
        this.m_DatasetKeyColumns = this.m_DatasetKeyColumnsRange.getSelection();
        this.m_Resultsets.removeAllElements();
        this.m_DatasetSpecifiers.removeAllSpecifiers();
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            int j;
            Instance current = this.m_Instances.instance(i);
            if (current.isMissing(this.m_RunColumn)) {
                throw new Exception("Instance has missing value in run column!\n" + current);
            }
            for (j = 0; j < this.m_ResultsetKeyColumns.length; ++j) {
                if (!current.isMissing(this.m_ResultsetKeyColumns[j])) continue;
                throw new Exception("Instance has missing value in resultset key column " + (this.m_ResultsetKeyColumns[j] + 1) + "!\n" + current);
            }
            for (j = 0; j < this.m_DatasetKeyColumns.length; ++j) {
                if (!current.isMissing(this.m_DatasetKeyColumns[j])) continue;
                throw new Exception("Instance has missing value in dataset key column " + (this.m_DatasetKeyColumns[j] + 1) + "!\n" + current);
            }
            boolean found = false;
            for (int j2 = 0; j2 < this.m_Resultsets.size(); ++j2) {
                Resultset resultset = (Resultset)this.m_Resultsets.elementAt(j2);
                if (!resultset.matchesTemplate(current)) continue;
                resultset.add(current);
                found = true;
                break;
            }
            if (!found) {
                Resultset resultset = new Resultset(current);
                this.m_Resultsets.addElement(resultset);
            }
            this.m_DatasetSpecifiers.add(current);
        }
        for (int j = 0; j < this.m_Resultsets.size(); ++j) {
            Resultset resultset = (Resultset)this.m_Resultsets.elementAt(j);
            if (this.m_FoldColumn >= 0) {
                resultset.sort(this.m_FoldColumn);
            }
            resultset.sort(this.m_RunColumn);
        }
        this.m_ResultsetsValid = true;
    }

    public int getNumDatasets() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0;
            }
        }
        return this.m_DatasetSpecifiers.numSpecifiers();
    }

    public int getNumResultsets() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0;
            }
        }
        return this.m_Resultsets.size();
    }

    public String getResultsetName(int index) {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return ((Resultset)this.m_Resultsets.elementAt(index)).templateString();
    }

    public boolean displayResultset(int index) {
        boolean result = true;
        if (this.m_DisplayedResultsets != null) {
            result = false;
            for (int i = 0; i < this.m_DisplayedResultsets.length; ++i) {
                if (this.m_DisplayedResultsets[i] != index) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public PairedStats calculateStatistics(Instance datasetSpecifier, int resultset1Index, int resultset2Index, int comparisonColumn) throws Exception {
        if (this.m_Instances.attribute(comparisonColumn).type() != 0) {
            throw new Exception("Comparison column " + (comparisonColumn + 1) + " (" + this.m_Instances.attribute(comparisonColumn).name() + ") is not numeric");
        }
        if (!this.m_ResultsetsValid) {
            this.prepareData();
        }
        Resultset resultset1 = (Resultset)this.m_Resultsets.elementAt(resultset1Index);
        Resultset resultset2 = (Resultset)this.m_Resultsets.elementAt(resultset2Index);
        FastVector dataset1 = resultset1.dataset(datasetSpecifier);
        FastVector dataset2 = resultset2.dataset(datasetSpecifier);
        String datasetName = this.templateString(datasetSpecifier);
        if (dataset1 == null) {
            throw new Exception("No results for dataset=" + datasetName + " for resultset=" + resultset1.templateString());
        }
        if (dataset2 == null) {
            throw new Exception("No results for dataset=" + datasetName + " for resultset=" + resultset2.templateString());
        }
        if (dataset1.size() != dataset2.size()) {
            throw new Exception("Results for dataset=" + datasetName + " differ in size for resultset=" + resultset1.templateString() + " and resultset=" + resultset2.templateString());
        }
        PairedStats pairedStats = new PairedStats(this.m_SignificanceLevel);
        for (int k = 0; k < dataset1.size(); ++k) {
            Instance current1 = (Instance)dataset1.elementAt(k);
            Instance current2 = (Instance)dataset2.elementAt(k);
            if (current1.isMissing(comparisonColumn)) {
                System.err.println("Instance has missing value in comparison column!\n" + current1);
                continue;
            }
            if (current2.isMissing(comparisonColumn)) {
                System.err.println("Instance has missing value in comparison column!\n" + current2);
                continue;
            }
            if (current1.value(this.m_RunColumn) != current2.value(this.m_RunColumn)) {
                System.err.println("Run numbers do not match!\n" + current1 + current2);
            }
            if (this.m_FoldColumn != -1 && current1.value(this.m_FoldColumn) != current2.value(this.m_FoldColumn)) {
                System.err.println("Fold numbers do not match!\n" + current1 + current2);
            }
            double value1 = current1.value(comparisonColumn);
            double value2 = current2.value(comparisonColumn);
            pairedStats.add(value1, value2);
        }
        pairedStats.calculateDerived();
        return pairedStats;
    }

    public String resultsetKey() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return ex.getMessage();
            }
        }
        String result = "";
        for (int j = 0; j < this.getNumResultsets(); ++j) {
            result = result + "(" + (j + 1) + ") " + this.getResultsetName(j) + '\n';
        }
        return result + '\n';
    }

    public String header(int comparisonColumn) {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return ex.getMessage();
            }
        }
        this.initResultMatrix();
        this.m_ResultMatrix.addHeader("Tester", this.getClass().getName());
        this.m_ResultMatrix.addHeader("Analysing", this.m_Instances.attribute(comparisonColumn).name());
        this.m_ResultMatrix.addHeader("Datasets", Integer.toString(this.getNumDatasets()));
        this.m_ResultMatrix.addHeader("Resultsets", Integer.toString(this.getNumResultsets()));
        this.m_ResultMatrix.addHeader("Confidence", this.getSignificanceLevel() + " (two tailed)");
        this.m_ResultMatrix.addHeader("Sorted by", this.getSortColumnName());
        this.m_ResultMatrix.addHeader("Date", new SimpleDateFormat().format(new Date()));
        return this.m_ResultMatrix.toStringHeader() + "\n";
    }

    public int[][] multiResultsetWins(int comparisonColumn, int[][] nonSigWin) throws Exception {
        int numResultsets = this.getNumResultsets();
        int[][] win = new int[numResultsets][numResultsets];
        for (int i = 0; i < numResultsets; ++i) {
            for (int j = i + 1; j < numResultsets; ++j) {
                System.err.print("Comparing (" + (i + 1) + ") with (" + (j + 1) + ")\r");
                System.err.flush();
                for (int k = 0; k < this.getNumDatasets(); ++k) {
                    try {
                        PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(k), i, j, comparisonColumn);
                        if (pairedStats.differencesSignificance < 0) {
                            int[] nArray = win[i];
                            int n = j;
                            nArray[n] = nArray[n] + 1;
                        } else if (pairedStats.differencesSignificance > 0) {
                            int[] nArray = win[j];
                            int n = i;
                            nArray[n] = nArray[n] + 1;
                        }
                        if (pairedStats.differencesStats.mean < 0.0) {
                            int[] nArray = nonSigWin[i];
                            int n = j;
                            nArray[n] = nArray[n] + 1;
                            continue;
                        }
                        if (!(pairedStats.differencesStats.mean > 0.0)) continue;
                        int[] nArray = nonSigWin[j];
                        int n = i;
                        nArray[n] = nArray[n] + 1;
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            }
        }
        return win;
    }

    protected void initResultMatrix() {
        this.m_ResultMatrix.setSize(this.getNumResultsets(), this.getNumDatasets());
        this.m_ResultMatrix.setShowStdDev(this.m_ShowStdDevs);
        for (int i = 0; i < this.getNumDatasets(); ++i) {
            this.m_ResultMatrix.setRowName(i, this.templateString(this.m_DatasetSpecifiers.specifier(i)));
        }
        for (int j = 0; j < this.getNumResultsets(); ++j) {
            this.m_ResultMatrix.setColName(j, this.getResultsetName(j));
            this.m_ResultMatrix.setColHidden(j, !this.displayResultset(j));
        }
    }

    public String multiResultsetSummary(int comparisonColumn) throws Exception {
        int[][] nonSigWin = new int[this.getNumResultsets()][this.getNumResultsets()];
        int[][] win = this.multiResultsetWins(comparisonColumn, nonSigWin);
        this.initResultMatrix();
        this.m_ResultMatrix.setSummary(nonSigWin, win);
        return this.m_ResultMatrix.toStringSummary();
    }

    public String multiResultsetRanking(int comparisonColumn) throws Exception {
        int[][] nonSigWin = new int[this.getNumResultsets()][this.getNumResultsets()];
        int[][] win = this.multiResultsetWins(comparisonColumn, nonSigWin);
        this.initResultMatrix();
        this.m_ResultMatrix.setRanking(win);
        return this.m_ResultMatrix.toStringRanking();
    }

    public String multiResultsetFull(int baseResultset, int comparisonColumn) throws Exception {
        int i;
        int maxWidthMean = 2;
        int maxWidthStdDev = 2;
        double[] sortValues = new double[this.getNumDatasets()];
        for (int i2 = 0; i2 < this.getNumDatasets(); ++i2) {
            sortValues[i2] = Double.POSITIVE_INFINITY;
            for (int j = 0; j < this.getNumResultsets(); ++j) {
                if (!this.displayResultset(j)) continue;
                try {
                    double width;
                    PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(i2), baseResultset, j, comparisonColumn);
                    if (!Double.isInfinite(pairedStats.yStats.mean) && !Double.isNaN(pairedStats.yStats.mean) && (width = Math.log(Math.abs(pairedStats.yStats.mean)) / Math.log(10.0) + 1.0) > (double)maxWidthMean) {
                        maxWidthMean = (int)width;
                    }
                    if (j == baseResultset) {
                        sortValues[i2] = this.getSortColumn() != -1 ? this.calculateStatistics((Instance)this.m_DatasetSpecifiers.specifier((int)i2), (int)baseResultset, (int)j, (int)this.getSortColumn()).xStats.mean : (double)i2;
                    }
                    if (!this.m_ShowStdDevs || Double.isInfinite(pairedStats.yStats.stdDev) || Double.isNaN(pairedStats.yStats.stdDev) || !((width = Math.log(Math.abs(pairedStats.yStats.stdDev)) / Math.log(10.0) + 1.0) > (double)maxWidthStdDev)) continue;
                    maxWidthStdDev = (int)width;
                    continue;
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
            }
        }
        this.m_SortOrder = Utils.sort(sortValues);
        this.m_ColOrder = new int[this.getNumResultsets()];
        this.m_ColOrder[0] = baseResultset;
        int index = 1;
        for (i = 0; i < this.getNumResultsets(); ++i) {
            if (i == baseResultset) continue;
            this.m_ColOrder[index] = i;
            ++index;
        }
        this.initResultMatrix();
        this.m_ResultMatrix.setRowOrder(this.m_SortOrder);
        this.m_ResultMatrix.setColOrder(this.m_ColOrder);
        this.m_ResultMatrix.setMeanWidth(maxWidthMean);
        this.m_ResultMatrix.setStdDevWidth(maxWidthStdDev);
        this.m_ResultMatrix.setSignificanceWidth(1);
        for (i = 0; i < this.m_ResultMatrix.getColCount(); ++i) {
            if (i != baseResultset || !this.m_ResultMatrix.getColHidden(i)) continue;
            this.m_ResultMatrix.setColHidden(i, false);
            System.err.println("Note: test base was hidden - set visible!");
        }
        for (i = 0; i < this.getNumDatasets(); ++i) {
            this.m_ResultMatrix.setRowName(i, this.templateString(this.m_DatasetSpecifiers.specifier(i)));
            for (int j = 0; j < this.getNumResultsets(); ++j) {
                try {
                    PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(i), baseResultset, j, comparisonColumn);
                    this.m_ResultMatrix.setCount(i, pairedStats.count);
                    this.m_ResultMatrix.setMean(j, i, pairedStats.yStats.mean);
                    this.m_ResultMatrix.setStdDev(j, i, pairedStats.yStats.stdDev);
                    if (pairedStats.differencesSignificance < 0) {
                        this.m_ResultMatrix.setSignificance(j, i, 1);
                        continue;
                    }
                    if (pairedStats.differencesSignificance > 0) {
                        this.m_ResultMatrix.setSignificance(j, i, 2);
                        continue;
                    }
                    this.m_ResultMatrix.setSignificance(j, i, 0);
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
        StringBuffer result = new StringBuffer(1000);
        try {
            result.append(this.m_ResultMatrix.toStringMatrix());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result.append("\n\n" + this.m_ResultMatrix.toStringKey());
        return result.toString();
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSpecify list of columns that specify a unique\n\tdataset.\n\tFirst and last are valid indexes. (default none)", "D", 1, "-D <index,index2-index4,...>"));
        newVector.addElement(new Option("\tSet the index of the column containing the run number", "R", 1, "-R <index>"));
        newVector.addElement(new Option("\tSet the index of the column containing the fold number", "F", 1, "-F <index>"));
        newVector.addElement(new Option("\tSpecify list of columns that specify a unique\n\t'result generator' (eg: classifier name and options).\n\tFirst and last are valid indexes. (default none)", "G", 1, "-G <index1,index2-index4,...>"));
        newVector.addElement(new Option("\tSet the significance level for comparisons (default 0.05)", "S", 1, "-S <significance level>"));
        newVector.addElement(new Option("\tShow standard deviations", "V", 0, "-V"));
        newVector.addElement(new Option("\tProduce table comparisons in Latex table format", "L", 0, "-L"));
        newVector.addElement(new Option("\tProduce table comparisons in CSV table format", "csv", 0, "-csv"));
        newVector.addElement(new Option("\tProduce table comparisons in HTML table format", "html", 0, "-html"));
        newVector.addElement(new Option("\tProduce table comparisons with only the significance values", "significance", 0, "-significance"));
        newVector.addElement(new Option("\tProduce table comparisons output suitable for GNUPlot", "gnuplot", 0, "-gnuplot"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setShowStdDevs(Utils.getFlag('V', options));
        if (Utils.getFlag('L', options)) {
            this.setResultMatrix(new ResultMatrixLatex());
        }
        if (Utils.getFlag("csv", options)) {
            this.setResultMatrix(new ResultMatrixCSV());
        }
        if (Utils.getFlag("html", options)) {
            this.setResultMatrix(new ResultMatrixHTML());
        }
        if (Utils.getFlag("significance", options)) {
            this.setResultMatrix(new ResultMatrixSignificance());
        }
        String datasetList = Utils.getOption('D', options);
        Range datasetRange = new Range();
        if (datasetList.length() != 0) {
            datasetRange.setRanges(datasetList);
        }
        this.setDatasetKeyColumns(datasetRange);
        String indexStr = Utils.getOption('R', options);
        if (indexStr.length() != 0) {
            if (indexStr.equals("first")) {
                this.setRunColumn(0);
            } else if (indexStr.equals("last")) {
                this.setRunColumn(-1);
            } else {
                this.setRunColumn(Integer.parseInt(indexStr) - 1);
            }
        } else {
            this.setRunColumn(-1);
        }
        String foldStr = Utils.getOption('F', options);
        if (foldStr.length() != 0) {
            this.setFoldColumn(Integer.parseInt(foldStr) - 1);
        } else {
            this.setFoldColumn(-1);
        }
        String sigStr = Utils.getOption('S', options);
        if (sigStr.length() != 0) {
            this.setSignificanceLevel(new Double(sigStr));
        } else {
            this.setSignificanceLevel(0.05);
        }
        String resultsetList = Utils.getOption('G', options);
        Range generatorRange = new Range();
        if (resultsetList.length() != 0) {
            generatorRange.setRanges(resultsetList);
        }
        this.setResultsetKeyColumns(generatorRange);
    }

    public String[] getOptions() {
        String[] options = new String[11];
        int current = 0;
        if (!this.getResultsetKeyColumns().getRanges().equals("")) {
            options[current++] = "-G";
            options[current++] = this.getResultsetKeyColumns().getRanges();
        }
        if (!this.getDatasetKeyColumns().getRanges().equals("")) {
            options[current++] = "-D";
            options[current++] = this.getDatasetKeyColumns().getRanges();
        }
        options[current++] = "-R";
        options[current++] = "" + (this.getRunColumn() + 1);
        options[current++] = "-S";
        options[current++] = "" + this.getSignificanceLevel();
        if (this.getShowStdDevs()) {
            options[current++] = "-V";
        }
        if (this.getResultMatrix() instanceof ResultMatrixLatex) {
            options[current++] = "-L";
        }
        if (this.getResultMatrix() instanceof ResultMatrixCSV) {
            options[current++] = "-csv";
        }
        if (this.getResultMatrix() instanceof ResultMatrixHTML) {
            options[current++] = "-html";
        }
        if (this.getResultMatrix() instanceof ResultMatrixSignificance) {
            options[current++] = "-significance";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public Range getResultsetKeyColumns() {
        return this.m_ResultsetKeyColumnsRange;
    }

    public void setResultsetKeyColumns(Range newResultsetKeyColumns) {
        this.m_ResultsetKeyColumnsRange = newResultsetKeyColumns;
        this.m_ResultsetsValid = false;
    }

    public int[] getDisplayedResultsets() {
        return this.m_DisplayedResultsets;
    }

    public void setDisplayedResultsets(int[] cols) {
        this.m_DisplayedResultsets = cols;
    }

    public double getSignificanceLevel() {
        return this.m_SignificanceLevel;
    }

    public void setSignificanceLevel(double newSignificanceLevel) {
        this.m_SignificanceLevel = newSignificanceLevel;
    }

    public Range getDatasetKeyColumns() {
        return this.m_DatasetKeyColumnsRange;
    }

    public void setDatasetKeyColumns(Range newDatasetKeyColumns) {
        this.m_DatasetKeyColumnsRange = newDatasetKeyColumns;
        this.m_ResultsetsValid = false;
    }

    public int getRunColumn() {
        return this.m_RunColumnSet;
    }

    public void setRunColumn(int newRunColumn) {
        this.m_RunColumnSet = newRunColumn;
        this.m_ResultsetsValid = false;
    }

    public int getFoldColumn() {
        return this.m_FoldColumn;
    }

    public void setFoldColumn(int newFoldColumn) {
        this.m_FoldColumn = newFoldColumn;
        this.m_ResultsetsValid = false;
    }

    public String getSortColumnName() {
        if (this.getSortColumn() == -1) {
            return "-";
        }
        return this.m_Instances.attribute(this.getSortColumn()).name();
    }

    public int getSortColumn() {
        return this.m_SortColumn;
    }

    public void setSortColumn(int newSortColumn) {
        if (newSortColumn >= -1) {
            this.m_SortColumn = newSortColumn;
        }
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setInstances(Instances newInstances) {
        this.m_Instances = newInstances;
        this.m_ResultsetsValid = false;
    }

    public void assign(Tester tester) {
        this.setInstances(tester.getInstances());
        this.setResultMatrix(tester.getResultMatrix());
        this.setShowStdDevs(tester.getShowStdDevs());
        this.setResultsetKeyColumns(tester.getResultsetKeyColumns());
        this.setDisplayedResultsets(tester.getDisplayedResultsets());
        this.setSignificanceLevel(tester.getSignificanceLevel());
        this.setDatasetKeyColumns(tester.getDatasetKeyColumns());
        this.setRunColumn(tester.getRunColumn());
        this.setFoldColumn(tester.getFoldColumn());
        this.setSortColumn(tester.getSortColumn());
    }

    public String getToolTipText() {
        return "Performs test using t-test statistic";
    }

    public String getDisplayName() {
        return "Paired T-Tester";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        try {
            PairedTTester tt = new PairedTTester();
            String datasetName = Utils.getOption('t', args);
            String compareColStr = Utils.getOption('c', args);
            String baseColStr = Utils.getOption('b', args);
            boolean summaryOnly = Utils.getFlag('s', args);
            boolean rankingOnly = Utils.getFlag('r', args);
            try {
                if (datasetName.length() == 0 || compareColStr.length() == 0) {
                    throw new Exception("-t and -c options are required");
                }
                tt.setOptions(args);
                Utils.checkForRemainingOptions(args);
            }
            catch (Exception ex) {
                String result = "";
                Enumeration enu = tt.listOptions();
                while (enu.hasMoreElements()) {
                    Option option = (Option)enu.nextElement();
                    result = result + option.synopsis() + '\n' + option.description() + '\n';
                }
                throw new Exception("Usage:\n\n-t <file>\n\tSet the dataset containing data to evaluate\n-b <index>\n\tSet the resultset to base comparisons against (optional)\n-c <index>\n\tSet the column to perform a comparison on\n-s\n\tSummarize wins over all resultset pairs\n\n-r\n\tGenerate a resultset ranking\n\n" + result);
            }
            Instances data = new Instances(new BufferedReader(new FileReader(datasetName)));
            tt.setInstances(data);
            int compareCol = Integer.parseInt(compareColStr) - 1;
            System.out.println(tt.header(compareCol));
            if (rankingOnly) {
                System.out.println(tt.multiResultsetRanking(compareCol));
            } else if (summaryOnly) {
                System.out.println(tt.multiResultsetSummary(compareCol));
            } else {
                System.out.println(tt.resultsetKey());
                if (baseColStr.length() == 0) {
                    for (int i = 0; i < tt.getNumResultsets(); ++i) {
                        if (!tt.displayResultset(i)) continue;
                        System.out.println(tt.multiResultsetFull(i, compareCol));
                    }
                } else {
                    int baseCol = Integer.parseInt(baseColStr) - 1;
                    System.out.println(tt.multiResultsetFull(baseCol, compareCol));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
    }

    protected class Resultset
    implements RevisionHandler,
    Serializable {
        private static final long serialVersionUID = 1543786683821339978L;
        Instance m_Template;
        FastVector m_Datasets;

        public Resultset(Instance template) {
            this.m_Template = template;
            this.m_Datasets = new FastVector();
            this.add(template);
        }

        protected boolean matchesTemplate(Instance first) {
            for (int i = 0; i < PairedTTester.this.m_ResultsetKeyColumns.length; ++i) {
                if (first.value(PairedTTester.this.m_ResultsetKeyColumns[i]) == this.m_Template.value(PairedTTester.this.m_ResultsetKeyColumns[i])) continue;
                return false;
            }
            return true;
        }

        protected String templateString() {
            String result = "";
            String tempResult = "";
            for (int i = 0; i < PairedTTester.this.m_ResultsetKeyColumns.length; ++i) {
                tempResult = this.m_Template.toString(PairedTTester.this.m_ResultsetKeyColumns[i]) + ' ';
                tempResult = Utils.removeSubstring(tempResult, "weka.classifiers.");
                tempResult = Utils.removeSubstring(tempResult, "weka.filters.");
                tempResult = Utils.removeSubstring(tempResult, "weka.attributeSelection.");
                result = result + tempResult;
            }
            return result.trim();
        }

        public FastVector dataset(Instance inst) {
            for (int i = 0; i < this.m_Datasets.size(); ++i) {
                if (!((Dataset)this.m_Datasets.elementAt(i)).matchesTemplate(inst)) continue;
                return ((Dataset)this.m_Datasets.elementAt(i)).contents();
            }
            return null;
        }

        public void add(Instance newInst) {
            for (int i = 0; i < this.m_Datasets.size(); ++i) {
                if (!((Dataset)this.m_Datasets.elementAt(i)).matchesTemplate(newInst)) continue;
                ((Dataset)this.m_Datasets.elementAt(i)).add(newInst);
                return;
            }
            Dataset newDataset = new Dataset(newInst);
            this.m_Datasets.addElement(newDataset);
        }

        public void sort(int runColumn) {
            for (int i = 0; i < this.m_Datasets.size(); ++i) {
                ((Dataset)this.m_Datasets.elementAt(i)).sort(runColumn);
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    protected class Dataset
    implements RevisionHandler,
    Serializable {
        private static final long serialVersionUID = -2801397601839433282L;
        Instance m_Template;
        FastVector m_Dataset;

        public Dataset(Instance template) {
            this.m_Template = template;
            this.m_Dataset = new FastVector();
            this.add(template);
        }

        protected boolean matchesTemplate(Instance first) {
            for (int i = 0; i < PairedTTester.this.m_DatasetKeyColumns.length; ++i) {
                if (first.value(PairedTTester.this.m_DatasetKeyColumns[i]) == this.m_Template.value(PairedTTester.this.m_DatasetKeyColumns[i])) continue;
                return false;
            }
            return true;
        }

        protected void add(Instance inst) {
            this.m_Dataset.addElement(inst);
        }

        protected FastVector contents() {
            return this.m_Dataset;
        }

        public void sort(int runColumn) {
            double[] runNums = new double[this.m_Dataset.size()];
            for (int j = 0; j < runNums.length; ++j) {
                runNums[j] = ((Instance)this.m_Dataset.elementAt(j)).value(runColumn);
            }
            int[] index = Utils.stableSort(runNums);
            FastVector newDataset = new FastVector(runNums.length);
            for (int j = 0; j < index.length; ++j) {
                newDataset.addElement(this.m_Dataset.elementAt(index[j]));
            }
            this.m_Dataset = newDataset;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    protected class DatasetSpecifiers
    implements RevisionHandler,
    Serializable {
        private static final long serialVersionUID = -9020938059902723401L;
        FastVector m_Specifiers = new FastVector();

        protected DatasetSpecifiers() {
        }

        protected void removeAllSpecifiers() {
            this.m_Specifiers.removeAllElements();
        }

        protected void add(Instance inst) {
            for (int i = 0; i < this.m_Specifiers.size(); ++i) {
                Instance specifier = (Instance)this.m_Specifiers.elementAt(i);
                boolean found = true;
                for (int j = 0; j < PairedTTester.this.m_DatasetKeyColumns.length; ++j) {
                    if (inst.value(PairedTTester.this.m_DatasetKeyColumns[j]) == specifier.value(PairedTTester.this.m_DatasetKeyColumns[j])) continue;
                    found = false;
                }
                if (!found) continue;
                return;
            }
            this.m_Specifiers.addElement(inst);
        }

        protected Instance specifier(int i) {
            return (Instance)this.m_Specifiers.elementAt(i);
        }

        protected int numSpecifiers() {
            return this.m_Specifiers.size();
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }
}

