/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.gui.CustomPanelSupplier;

public class EnvironmentField
extends JPanel
implements EnvironmentHandler,
PropertyEditor,
CustomPanelSupplier {
    private static final long serialVersionUID = -3125404573324734121L;
    protected JLabel m_label;
    protected JComboBox m_combo;
    protected Environment m_env;
    protected String m_currentContents = "";
    protected int m_firstCaretPos = 0;
    protected int m_previousCaretPos = 0;
    protected int m_currentCaretPos = 0;
    protected PropertyChangeSupport m_support = new PropertyChangeSupport(this);

    public EnvironmentField() {
        this("");
        this.setEnvironment(Environment.getSystemWide());
    }

    public EnvironmentField(Environment env) {
        this("");
        this.setEnvironment(env);
    }

    public EnvironmentField(String label, Environment env) {
        this(label);
        this.setEnvironment(env);
    }

    public EnvironmentField(String label) {
        this.setLayout(new BorderLayout());
        this.m_label = new JLabel(label);
        if (label.length() > 0) {
            this.m_label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
        this.add((Component)this.m_label, "West");
        this.m_combo = new JComboBox();
        this.m_combo.setEditable(true);
        Component theEditor = this.m_combo.getEditor().getEditorComponent();
        if (theEditor instanceof JTextField) {
            ((JTextField)this.m_combo.getEditor().getEditorComponent()).addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    EnvironmentField.this.m_firstCaretPos = EnvironmentField.this.m_previousCaretPos;
                    EnvironmentField.this.m_previousCaretPos = EnvironmentField.this.m_currentCaretPos;
                    EnvironmentField.this.m_currentCaretPos = e.getDot();
                }
            });
            this.m_combo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    EnvironmentField.this.m_support.firePropertyChange("", null, null);
                }
            });
            ((JTextField)this.m_combo.getEditor().getEditorComponent()).addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    EnvironmentField.this.m_support.firePropertyChange("", null, null);
                }
            });
        }
        this.add((Component)this.m_combo, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void setLabel(String label) {
        this.m_label.setText(label);
    }

    public void setText(String text) {
        this.m_currentContents = text;
        Component theEditor = this.m_combo.getEditor().getEditorComponent();
        if (theEditor instanceof JTextField) {
            ((JTextField)theEditor).setText(text);
        } else {
            this.m_combo.setSelectedItem(this.m_currentContents);
        }
        this.m_support.firePropertyChange("", null, null);
    }

    public String getText() {
        Component theEditor = this.m_combo.getEditor().getEditorComponent();
        String text = this.m_combo.getSelectedItem().toString();
        if (theEditor instanceof JTextField) {
            text = ((JTextField)theEditor).getText();
        }
        return text;
    }

    public void setAsText(String s) {
        this.setText(s);
    }

    public String getAsText() {
        return this.getText();
    }

    public void setValue(Object o) {
        this.setAsText((String)o);
    }

    public Object getValue() {
        return this.getAsText();
    }

    public String getJavaInitializationString() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public String[] getTags() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public JPanel getCustomPanel() {
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_support.removePropertyChangeListener(pcl);
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    private String processSelected(String selected) {
        if (selected.equals(this.m_currentContents)) {
            return selected;
        }
        if (this.m_firstCaretPos == 0) {
            this.m_currentContents = selected + this.m_currentContents;
        } else if (this.m_firstCaretPos >= this.m_currentContents.length()) {
            this.m_currentContents = this.m_currentContents + selected;
        } else {
            String left = this.m_currentContents.substring(0, this.m_firstCaretPos);
            String right = this.m_currentContents.substring(this.m_firstCaretPos, this.m_currentContents.length());
            this.m_currentContents = left + selected + right;
        }
        this.m_combo.setSelectedItem(this.m_currentContents);
        this.m_support.firePropertyChange("", null, null);
        return this.m_currentContents;
    }

    public void setEnvironment(final Environment env) {
        this.m_env = env;
        Vector<String> varKeys = new Vector<String>(env.getVariableNames());
        DefaultComboBoxModel dm = new DefaultComboBoxModel(varKeys){

            public Object getSelectedItem() {
                Object item = super.getSelectedItem();
                if (item instanceof String && env.getVariableValue((String)item) != null) {
                    String newS = "${" + (String)item + "}";
                    item = newS;
                }
                return item;
            }
        };
        this.m_combo.setModel(dm);
        this.m_combo.setSelectedItem("");
        this.m_combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selected = (String)EnvironmentField.this.m_combo.getSelectedItem();
                try {
                    selected = EnvironmentField.this.processSelected(selected);
                    selected = EnvironmentField.this.m_env.substitute(selected);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EnvironmentField.this.m_combo.setToolTipText(selected);
            }
        });
        this.m_combo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                Component theEditor = EnvironmentField.this.m_combo.getEditor().getEditorComponent();
                if (theEditor instanceof JTextField) {
                    String selected;
                    EnvironmentField.this.m_currentContents = selected = ((JTextField)theEditor).getText();
                    if (EnvironmentField.this.m_env != null) {
                        try {
                            selected = EnvironmentField.this.m_env.substitute(selected);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    EnvironmentField.this.m_combo.setToolTipText(selected);
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.m_combo.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.m_combo.setEditable(editable);
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("EnvironmentField");
            jf.getContentPane().setLayout(new BorderLayout());
            EnvironmentField f = new EnvironmentField("A label here");
            jf.getContentPane().add((Component)f, "Center");
            Environment env = Environment.getSystemWide();
            f.setEnvironment(env);
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

