% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.optim.R
\name{get.optim}
\alias{get.optim}
\title{Get the Result of the Optimization Operation}
\usage{
get.optim(opt, n = NULL)
}
\arguments{
\item{opt}{the result of the optimization operation performed by \code{\link{do.optim}}}

\item{n}{the optimized order of anchors to return; defaults to NULL, 
which returns the best identified combination}
}
\value{
a character vector of the anchor names, ordered as in the n^th^ step of 
the optimization
}
\description{
Once the order of anchors has been optimized using \code{\link{do.optim}}
this function can be used to recover the optimized anchors or any intermediate step
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
sim.mat <- cosine(iris[,das])
in.da(S,sim.mat) # the starting value
new <- do.optim(S,sim.mat,iter=10,n=100)
get.optim(new) # the optimal order
get.optim(new,2) # the second step of the optimization

}
\author{
Yann Abraham
}
