% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repmat.R
\name{repmat}
\alias{repmat}
\title{Auxiliary function that extends the matrix X}
\usage{
repmat(X, m, n)
}
\arguments{
\item{X}{A vector of inputs}

\item{m}{the first dimension of the desired output matrix}

\item{n}{the second dimension of the desired output matrix}
}
\value{
A matrix os size (dim(X)[1]*m,dim(X)[2]*n)
}
\description{
Auxiliary function that extends the matrix X
}
\examples{
library(orthopolynom)
library(polynom)
library(tmvtnorm)
library(ks)
library(sfsmisc)
library(snowfall)
library(fourierin)
library(rdetools)
library(statmod)
library(RCEIM)
library(robustbase)
library(VGAM)
library(RandomCoefficients)
K=3
u <- sqrt(1/(4-1/seq(1,(K-1))^2))
n = length(u)+1
trans = myDiag(matrix(0,n, n),u,1) + myDiag(matrix(0,n, n),u,-1)
eigen_trans <- eigen(trans)
V<- eigen_trans$vectors
Lambda <- eigen_trans$values
t = sort(Lambda)
i= sort(seq(1, length(Lambda)), decreasing=TRUE)
V = V[,i,drop=FALSE]
Vtop = V[1,,drop=FALSE]
w = 2*Vtop^2
Pbarmat = V/repmat(Vtop*sqrt(2),K,1)

}
