% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-conf-int.R
\name{confidence_interval}
\alias{confidence_interval}
\title{Confidence Interval}
\usage{
confidence_interval(.vector, .interval = 0.95)
}
\arguments{
\item{.vector}{A numeric vector of data points}

\item{.interval}{A numeric value representing the confidence level
(e.g., 0.95 for 95\% confidence interval) The default is 0.95}
}
\value{
A named vector with the lower and upper bounds of the confidence interval
}
\description{
Calculate the confidence interval
}
\details{
This function calculates the confidence interval for a given vector and interval.
}
\examples{
confidence_interval(rnorm(100), 0.95)

}
\seealso{
Other Utility Functions: 
\code{\link{convert_snake_to_title_case}()},
\code{\link{generate_caption}()},
\code{\link{get_attributes}()},
\code{\link{rand_walk_column_names}()},
\code{\link{rand_walk_helper}()},
\code{\link{running_quantile}()},
\code{\link{std_cum_max_augment}()},
\code{\link{std_cum_mean_augment}()},
\code{\link{std_cum_min_augment}()},
\code{\link{std_cum_prod_augment}()},
\code{\link{std_cum_sum_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility Functions}
