% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rapfunc.R
\name{gwascat.download}
\alias{gwascat.download}
\title{Retrieve GWAS summary datasets from GWAS catalog
'\code{gwascat.download} takes a PMID from the user and downloads the associated summary statistics datasets published in GWAS catalog}
\usage{
gwascat.download(ID, harmonised = TRUE)
}
\arguments{
\item{ID}{a numeric. A PubMed ID (PMID) reference number from a GWAS paper.}

\item{harmonised}{a logical. Should GWAS catalog harmonised files be pursued?
If not available, the function will fall back to non-harmonised}
}
\value{
a character vector containing the url(s) to the dataset(s).
}
\description{
This function, takes PUBMED ids as an input, searches at the GWAS catalog
for harmonised datasets associated to that, interactively asking the
user to choose if there are more than one, and fetches the dataset.
}
\details{
If multiple files are available for the same study, R will prompt an interactive
dialogue to select a specific file, by number.
}
\author{
Guillermo Reales
}
