% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_hyd_read.R
\name{rvn_hyd_read}
\alias{rvn_hyd_read}
\title{Read in Raven Hydrograph file}
\usage{
rvn_hyd_read(ff = NA, tzone = "UTC")
}
\arguments{
\item{ff}{full file path to the Hydrographs.csv file}

\item{tzone}{string indicating the timezone of the data in ff (default "UTC")}
}
\value{
\item{hyd}{data frame from the file with standardized names}
}
\description{
rvn_hyd_read is used to read in the Hydrographs.csv file produced by the
modelling Framework Raven.
}
\details{
Expects a full file path to the Hydrographs.csv file, then
reads in the file using fread. The main advantage of this function is
renaming the columns to nicer names and extracting the units into something
much easier to read.

This function is also built to support the \code{\link{rvn_hyd_extract}} function, which uses
the object created here for extracting by reference to the columns named
here, for example sub24.

ff is the full file path of the Hydrographs.csv file. If the file is located
in the current working directory, then simply the name of the file is
sufficient.

tzone is a string indicating the timezone of the supplied Hydrographs file. The
timezone provided is coded into the resulting hyd data frame using the as.POSIXct
function. The timezone is provided as "UTC" by default, and should be adjusted by
the user to the local time zone as needed, based on the model run.
}
\examples{
# read in hydrograph sample csv data from RavenR package
ff <- system.file("extdata","run1_Hydrographs.csv", package="RavenR")

# read in Raven Hydrographs file, store into myhyd
myhyd <- rvn_hyd_read(ff)

# view contents
head(myhyd$hyd)
myhyd$units

}
\seealso{
\code{\link{rvn_hyd_extract}} for extraction tools related to the
rvn_hyd_read output file
}
