% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{RblParse}
\alias{RblParse}
\title{Parse Bloomberg response file and import data}
\usage{
RblParse(file, auto.assign = FALSE, env = parent.frame(),
  verbose = TRUE)
}
\arguments{
\item{file}{character string representing the local file to parse (see \code{\link{RblDownload}})}

\item{auto.assign}{logical. Should results be loaded to env when using PROGRAMNAME=gethistory?}

\item{env}{where to create objects if auto.assign = TRUE}

\item{verbose}{logical. Should R report extra information on progress?}
}
\value{
\describe{
 \item{PROGRAMNAME=getdata}{data.frame containig identifiers (rows) and fields (columns). NULL on failure.}
 \item{PROGRAMNAME=gethistory}{list of xts objects. If \emph{auto.assign}=TRUE the xts objects are loaded in \emph{env} and the object names are returned. NULL on failure.}
}
}
\description{
Parse Bloomberg local response files and import the data in R. The PROGRAMNAME in use is auto detected: 'getdata' and 'gethistory' are supported.
}
\examples{
\dontrun{
# Run RblConnect first

# Build a request file to download the daily closing prices of 
#  EURO STOXX Index from 2005-01-01 to 2015-12-31.
RblRequest <- 
     RblRequestBuilder(
          header = c(FIRMNAME = RblUser(), 
                     PROGRAMNAME = 'gethistory', 
                     DATERANGE = '20050101|20151231'),
          fields = c('PX_LAST'), 
          identifiers = c('SXXE Index')
     )
                                
# Upload the request file
req <- RblUpload(RblRequest)

# Download the response file
out <- RblDownload(req$out)

# Import the data
data <- RblParse(out)
str(data)
}

}
