% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{saveManualProtos}
\alias{saveManualProtos}
\title{Manual prototypes saving}
\usage{
saveManualProtos(data.sample, protos)
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{protos}{list of selected prototypes (with index and name).}
}
\value{
profiles and images of prototypes selected, csv file with detail.
}
\description{
Save the profiles and images of prototypes selected manually by user in a scatterplot.
}
\details{
saveManualProtos saves the profiles and images of prototypes selected manually by user in a scatterplot
}
\examples{
\donttest{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

x <- importSample(file.features=tf1, dir.save=tempdir())

new.protos <- visualizeSampleClustering(x, selection.mode = "prototypes", 
			 profile.mode="whole sample", wait.close=FALSE)
saveManualProtos(x, new.protos)


}
}
