% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softensemble.R
\name{soft.vote.ensemble}
\alias{soft.vote.ensemble}
\title{Soft Voting Cluster Ensemble}
\usage{
soft.vote.ensemble(data, seed, method = "FCM", K = 2, m = 2, gamma = 0,
  rho = rep(1, K), threshold = 10^-5, max.iteration = 100, core)
}
\arguments{
\item{data}{data frame nxp}

\item{seed}{number of ensemble}

\item{method}{fuzzy clustering method that will be used ("FCM" or "GK")}

\item{K}{specific number of cluster (must be >1)}

\item{m}{fuzzifier / degree of fuzziness}

\item{gamma}{parameter of Gustafson Kessel Clustering}

\item{rho}{parameter of volume clustering in Gustafson Kessel Clustering}

\item{threshold}{threshold of convergence}

\item{max.iteration}{maximum iteration to convergence}

\item{core}{number of core that used for parallelization}
}
\value{
func.obj objective function that calculated.

U matrix n x K consist fuzzy membership matrix

V matrix K x p consist fuzzy centroid

D matrix n x K consist distance of data to centroid that calculated

Clust.desc cluster description (dataset with additional column of cluster label)

seeding list of random number that used as seeding

Call call argument
}
\description{
This function used to perform Soft Voting Cluster Ensemble.
}
\details{
Soft vote cluster ensemble used to stabilize the result of cluster analysis. It can be define combine several result of clustering
to be one robust result.

The simple method of ensemble is voting method, vote label that resulted and use maximum
number of voting as partition. For fuzzy clustering, voting method use membership matrix. This function implemented voting method with sum rule approach.
For standarize the label, this function use hungary algorithm for optimal labelization.
}
\examples{
#library(RcmdrPlugin.FuzzyClust)
#soft.vote.ensemble(iris[1:50,1:4],seed=2,method="FCM",core=1,max.iteration=20,threshold=10^-3)->Cl
}
\references{
Sevillano, X., Alias, F., & Socoro, J. C. (2013). Posisional and Confidence voting-based Consensus Function For Fuzzy Cluster Ensemble. Fuzzy Sets and System, 1-40.
}

