% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_compare.R
\name{cdb_compare}
\alias{cdb_compare}
\title{Compare two versions or subsets of a COM(P)ADRE database}
\usage{
cdb_compare(cdb1, cdb2, verbose = FALSE)
}
\arguments{
\item{cdb1, cdb2}{CompadreDB objects to compare}

\item{verbose}{Logical argument indicating whether or not to return lots of
detail}
}
\value{
NULL. Output is printed rather than returned.
}
\description{
Prints a summary of the differences between two CompadreDB objects, including
the number of species, studies, and matrices in each. If argument
\code{verbose == TRUE}, additionally prints a list of the species and studies
that are present in one database but not the other.
}
\examples{
Compadre1 <- subset(Compadre, Continent == "Asia")
Compadre2 <- subset(Compadre, Continent == "Africa")

cdb_compare(Compadre1, Compadre2)

}
\seealso{
Other data checking: 
\code{\link{cdb_check_species}()},
\code{\link{cdb_collapse}()},
\code{\link{cdb_flag}()},
\code{\link{mpm_methods}}
}
\author{
Owen R. Jones <jones@biology.sdu.dk>
}
\concept{data checking}
