% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{attribute_size}
\alias{attribute_size}
\alias{cpos2str}
\alias{cpos2id}
\alias{struc2cpos}
\alias{id2str}
\title{Rcpp wrappers for CWB Corpus Library functions}
\usage{
attribute_size(corpus, attribute, attribute_type, registry)

cpos2str(corpus, p_attribute, registry, cpos)

cpos2id(corpus, p_attribute, registry, cpos)

struc2cpos(corpus, s_attribute, registry, struc)

id2str(corpus, p_attribute, registry, id)
}
\arguments{
\item{corpus}{The ID of a CWB corpus.}

\item{attribute}{Either a positional, or a structural attribute.}

\item{attribute_type}{Either "p" (positional attribute) or "s" (structural attribute).}

\item{registry}{Path to the corpus registry.}

\item{p_attribute}{A positional attribute.}

\item{cpos}{An integer vector of corpus positions.}

\item{s_attribute}{A structural attribute.}

\item{struc}{An integer value with struc.}

\item{id}{An \code{integer} vector with token ids.}
}
\description{
Rcpp wrappers for CWB Corpus Library functions
}
