% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DeepNetwork.R
\name{DeepNetworkTrain}
\alias{DeepNetworkTrain}
\title{Training a simple deep network.}
\usage{
DeepNetworkTrain(x, y, nHidden1 = 8L, nHidden2 = 8L,
  unsupRegularisation = 0.001, noiseStrength = 0.3,
  unsupIterations = 100L, regularisation = 1e-04, iterations = 200L,
  verbose = FALSE)
}
\arguments{
\item{x}{matrix with input data}

\item{y}{vector with labels}

\item{nHidden1}{number of nodes of first hidden layer (part of network model)}

\item{nHidden2}{number of nodes of second hidden layer (part of network model)}

\item{unsupRegularisation}{regularization factor of supervised training}

\item{noiseStrength}{noise strength for unsupervised training}

\item{unsupIterations}{iteration number for unsupervised training}

\item{regularisation}{regularisation factor for supervised training}

\item{iterations}{iteration number for supervised training}

\item{verbose}{print extra information?}
}
\description{
This will train a simple 'deep' neural network with two hidden layers.
It will use an autoencoder for pretraining.
For more information refer to the Shark tutorial at http://image.diku.dk/shark/sphinx_pages/build/html/rest_sources/tutorials/algorithms/deep_denoising_autoencoder_network.html
}
\examples{
x = as.matrix(iris[,1:4])
		y = as.vector(as.numeric(iris[,5]))
		y = replace(y, y == 2, 0)
		y = replace(y, y == 3, 0)
		model = DeepNetworkTrain (x, y, nHidden1 = 32, nHidden2 = 32)
		results = DeepNetworkPredict (x, model)
		networkPrediction = apply (results$prediction, 1, which.max) - 1
		errors = sum(abs(y - networkPrediction))/length(y)
		cat("Network produced ", errors, "errors.\\n")
}

