% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{shortcuts}
\alias{shortcuts}
\alias{Rd_alias}
\alias{Rd_aliases}
\alias{Rd_author}
\alias{Rd_arguments}
\alias{Rd_code}
\alias{Rd_concept}
\alias{Rd_concepts}
\alias{Rd_description}
\alias{Rd_enumerate}
\alias{Rd_examples}
\alias{Rd_item}
\alias{Rd_itemize}
\alias{Rd_keyword}
\alias{Rd_keywords}
\alias{Rd_name}
\alias{Rd_title}
\alias{Rd_usage}
\alias{Rd_value}
\title{Convenience Construction Shortcuts.}
\usage{
Rd_alias(alias)

Rd_aliases(aliases)

Rd_author(author)

Rd_arguments(..., items = list(...), indent = getOption("Rd::indent",
  TRUE), indent.with = getOption("Rd::indent.with", "  "))

Rd_code(code)

Rd_concept(concept)

Rd_concepts(concepts)

Rd_description(..., content = Rd(...))

Rd_enumerate(..., items = list(...), indent = getOption("Rd::indent",
  TRUE), indent.with = getOption("Rd::indent.with", "  "))

Rd_examples(..., content = list(...))

Rd_item(item, description = NULL)

Rd_itemize(..., items = list(...), indent = getOption("Rd::indent",
  TRUE), indent.with = getOption("Rd::indent.with", "  "))

Rd_keyword(key, .check = TRUE)

Rd_keywords(keys, .check = TRUE)

Rd_name(name)

Rd_title(title)

Rd_usage(..., usages = list(...))

Rd_value(value)
}
\arguments{
\item{alias}{an alias as a plain string.}

\item{aliases}{a character vector, each element a separate alias.}

\item{author}{a string, a person object, or another Rd object.}

\item{..., content}{\link{Rd} elements to be contained in the tag.}

\item{items}{arguments each should be an 'item' tag,
newlines to separate items are added automatically.}

\item{indent}{indent content}

\item{indent.with}{string to use for indent.}

\item{code}{a string to be converted to \code{RCODE} then wrapped in the 'code' tag.}

\item{concept}{the concept name, as a plain string.}

\item{concepts}{a vector of concepts each to be put in a concept tag.}

\item{item}{the item text}

\item{description}{an optional description that if provided
changes the 'item' tag into a two parameter, rather
than a single item tag followed by the item text.}

\item{key}{A string denoting a valid Rd keyword.}

\item{.check}{perform validity checks?}

\item{keys}{A character vector denoting valid Rd keywords.}

\item{name}{A string for a name of the Rd document.}

\item{title}{A string giving the title.}

\item{usages}{lines of usage, all should be bare strings
or \code{\link[=Rd_string]{RCODE}} strings.}

\item{value}{The return value, must be a correctly formatted \link{Rd} object.}
}
\description{
These functions are provided to construct Rd structure.
In some cases additional compliance checks are included.
}
\section{Functions}{
\itemize{
\item \code{Rd_alias}: Create an alias tag.

\item \code{Rd_aliases}: Create multiple aliases

\item \code{Rd_author}: Create author tags

\item \code{Rd_arguments}: create an arguments tag

\item \code{Rd_code}: Create a code tag.

\item \code{Rd_concept}: Create a 'concept' tag.

\item \code{Rd_concepts}: Create multiple concepts.

\item \code{Rd_description}: Create a description tag.

\item \code{Rd_enumerate}: Create an enumerated list.

\item \code{Rd_examples}: Create an examples tag.

\item \code{Rd_item}: Create an item tag.

\item \code{Rd_itemize}: Create an itemized list.

\item \code{Rd_keyword}: Create a keyword tag.

\item \code{Rd_keywords}: Create multiple keyword tags.

\item \code{Rd_name}: Create a name tag.

\item \code{Rd_title}: Create a title tag.

\item \code{Rd_usage}: Create a usage tag.

\item \code{Rd_value}: Create a value tag section.
}}

\examples{
Rd_enumerate(Rd_item("first"), Rd_item("second"))
Rd_enumerate( Rd_item("first", "comes before second.")
            , Rd_item("second", "comes after first."))
Rd_item("an item")
Rd_item('a', 'the first letter of the alphabet.')
Rd_itemize(Rd_item("first"), Rd_item("second"))
Rd_itemize( Rd_item("first", "comes before second.")
          , Rd_item("second", "comes after first."))
Rd_keyword('documentation')
}
