% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SLPP.R
\name{do.slpp}
\alias{do.slpp}
\title{Supervised Locality Preserving Projection}
\usage{
do.slpp(X, label, ndim = 2, preprocess = c("center", "decorrelate", "whiten"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
As its names suggests, Supervised Locality Preserving Projection (SLPP) is a variant of LPP
in that it replaces neighborhood network construction schematic with class information in that
if two nodes belong to the same class, it assigns weight of 1, i.e., \eqn{S_{ij}=1} if \eqn{x_i} and
\eqn{x_j} have same class labelings.
}
\examples{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150, 50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## compare SLPP with LPP
outLPP  <- do.lpp(X)
outSLPP <- do.slpp(X, label)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(outLPP$Y,  pch=19, col=label, main="LPP")
plot(outSLPP$Y, pch=19, col=label, main="SLPP")
par(opar)

}
\references{
\insertRef{zheng_gabor_2007}{Rdimtools}
}
\seealso{
\code{\link{do.lpp}}
}
\author{
Kisung You
}
\concept{linear_methods}
