/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;

public class ObjectHashSet
extends AbstractHashTable {
    private static final long serialVersionUID = 510L;

    public ObjectHashSet() {
        this(16, 0.75f);
    }

    public ObjectHashSet(int capacity, float loadFactor) {
        super(capacity, loadFactor);
    }

    public ObjectHashSet(Entry[] table) {
        super(0.75f, table);
    }

    public ObjectHashSet(float loadFactor, Entry[] table) {
        super(loadFactor, table);
    }

    public boolean add(Object value) {
        return this.add(value, true);
    }

    public void clear() {
        this.table = new Entry[Math.min(this.table.length, 16)];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    public boolean add(Object value, boolean checkExists) {
        int hashCode = this.comparator.hashCodeOf(value);
        int index = ObjectHashSet.indexOf(hashCode, this.table.length);
        if (checkExists) {
            for (ObjectEntry current = (ObjectEntry)this.table[index]; current != null; current = (ObjectEntry)current.getNext()) {
                if (hashCode != current.cachedHashCode || !this.comparator.equal(value, current.value)) continue;
                Object oldValue = current.value;
                current.value = value;
                return true;
            }
        }
        ObjectEntry entry = new ObjectEntry(value, hashCode);
        entry.next = this.table[index];
        this.table[index] = entry;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return false;
    }

    public boolean contains(Object value) {
        int hashCode = this.comparator.hashCodeOf(value);
        int index = ObjectHashSet.indexOf(hashCode, this.table.length);
        for (ObjectEntry current = (ObjectEntry)this.table[index]; current != null; current = (ObjectEntry)current.getNext()) {
            if (hashCode != current.cachedHashCode || !this.comparator.equal(value, current.value)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object value) {
        ObjectEntry previous;
        int hashCode = this.comparator.hashCodeOf(value);
        int index = ObjectHashSet.indexOf(hashCode, this.table.length);
        ObjectEntry current = previous = (ObjectEntry)this.table[index];
        while (current != null) {
            ObjectEntry next = (ObjectEntry)current.getNext();
            if (hashCode == current.cachedHashCode && this.comparator.equal(value, current.value)) {
                if (previous == current) {
                    this.table[index] = next;
                } else {
                    previous.setNext(next);
                }
                current.setNext(null);
                --this.size;
                return true;
            }
            previous = current;
            current = next;
        }
        return false;
    }

    public Entry getBucket(Object object) {
        int hashCode = this.comparator.hashCodeOf(object);
        int index = ObjectHashSet.indexOf(hashCode, this.table.length);
        return this.table[index];
    }

    public Object[] toArray(Object[] objects) {
        Iterator it = this.iterator();
        int i = 0;
        ObjectEntry entry = (ObjectEntry)it.next();
        while (entry != null) {
            objects[i++] = entry.getValue();
            entry = (ObjectEntry)it.next();
        }
        return objects;
    }

    public int getResizeHashcode(Entry entry) {
        return ((ObjectEntry)entry).cachedHashCode;
    }

    public static class ObjectEntry
    implements Entry,
    Externalizable {
        private static final long serialVersionUID = 510L;
        private Object value;
        private int cachedHashCode;
        private Entry next;

        public ObjectEntry() {
        }

        public ObjectEntry(Object value, int hashCode) {
            this.value = value;
            this.cachedHashCode = hashCode;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readObject();
            this.cachedHashCode = in.readInt();
            this.next = (Entry)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.value);
            out.writeInt(this.cachedHashCode);
            out.writeObject(this.next);
        }

        public Object getValue() {
            return this.value;
        }

        public Entry getNext() {
            return this.next;
        }

        public void setNext(Entry next) {
            this.next = next;
        }

        public int hashCode() {
            return this.cachedHashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            ObjectEntry other = (ObjectEntry)object;
            return this.value.equals(other.value);
        }
    }
}

