/*
 * Decompiled with CFR 0.152.
 */
package org.drools.type;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.type.DateFormats;

public class DateFormatsImpl
implements DateFormats,
Externalizable {
    private static final long serialVersionUID = 510L;
    private Map<String, DateFormat> map = new ConcurrentHashMap<String, DateFormat>();
    private static ThreadLocal<Map<String, DateFormat>> localMap = new ThreadLocal<Map<String, DateFormat>>(){

        @Override
        protected Map<String, DateFormat> initialValue() {
            return new HashMap<String, DateFormat>();
        }
    };
    public static ThreadLocal<DateFormats> dateFormats = new ThreadLocal<DateFormats>(){};

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.map = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.map);
    }

    public DateFormat get(String identifier) {
        return this.map.get(identifier);
    }

    public void set(String identifier, DateFormat calendar) {
        this.map.put(identifier, calendar);
    }

    public Date parse(String identifier, String date) {
        DateFormat df = localMap.get().get(identifier);
        if (df == null) {
            df = this.map.get(identifier);
            if (df == null) {
                throw new RuntimeException("Unable to find DateFormat for id '" + identifier + "'");
            }
            localMap.get().put(identifier, (DateFormat)df.clone());
        }
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid date input format: [" + date + "] using the DateFormat: [" + df + "]");
        }
    }
}

