% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foster.plot.R
\name{foster.plot}
\alias{foster.plot}
\title{Plots Based on Foster-Stuart and Diersen-Trenkler Statistics}
\usage{
foster.plot(
  X,
  weights = function(t) 1,
  statistic = c("D", "d", "S", "s", "U", "L", "W"),
  point.col = "black",
  point.shape = 19,
  conf.int = TRUE,
  conf.level = 0.9,
  conf.aes = c("ribbon", "errorbar"),
  conf.col = "grey69"
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{weights}{A function indicating the weight given to the different 
records according to their position in the series,
e.g., if \code{function(t) t-1} then \eqn{\omega_t = t-1}.}

\item{statistic}{A character string indicating the type of statistic to be 
calculated, i.e., one of \code{"D"}, \code{"d"}, \code{"S"}, \code{"s"},
\code{"U"}, \code{"L"} or \code{"W"} (see \code{\link{foster.test}}).}

\item{point.col, point.shape}{Value with the colour and shape of the points.}

\item{conf.int}{Logical. Indicates if the RIs are also shown.}

\item{conf.level}{(If \code{conf.int == TRUE}) Confidence level of the RIs.}

\item{conf.aes}{(If \code{conf.int == TRUE}) A character string indicating 
the aesthetic to display for the RIs, \code{"ribbon"} (grey area) or 
\code{"errorbar"} (vertical lines).}

\item{conf.col}{Colour used to plot the expected value and (if 
\code{conf.int == TRUE}) RIs.}
}
\value{
A ggplot graph object.
}
\description{
This function builds a ggplot object to display two-sided
  reference intervals based on Foster-Stuart and Diersen-Trenkler 
  statistics to study the hypothesis of the classical record model (i.e., 
  of IID continuous RVs).
}
\details{
The function plots the observed values of the statistic selected with 
  \code{statistic}, obtained with the series up to time \eqn{t} for 
  \eqn{t=1,\ldots,T}. The plot also includes the expected values and 
  reference intervals (RIs) based on the asymptotic normal distribution 
  of the statistics under the null hypothesis.

  This function implements the same ideas that \code{\link{N.plot}}, but with
  the statistics computed in \code{\link{foster.test}}. 
  
  These plots are useful to see the evolution in the record occurrence 
  and to follow the evolution of the trend. The plot was proposed by 
  Cebrián, Castillo-Mateo, Asín (2022) where its application is shown.
}
\examples{
# D-statistic
foster.plot(ZaragozaSeries)
# D-statistic with linear weights
foster.plot(ZaragozaSeries, weights = function(t) t-1)
# S-statistic with linear weights
foster.plot(ZaragozaSeries, statistic = "S", weights = function(t) t-1)
# U-statistic with weights (upper tail)
foster.plot(ZaragozaSeries, statistic = "U", weights = function(t) t-1)
# L-statistic with weights (lower tail)
foster.plot(ZaragozaSeries, statistic = "L", weights = function(t) t-1)

}
\references{
Cebrián AC, Castillo-Mateo J, Asín J (2022).
“Record Tests to Detect Non Stationarity in the Tails with an Application to Climate Change.”
\emph{Stochastic Environmental Research and Risk Assessment}, \strong{36}(2): 313-330. 
\doi{10.1007/s00477-021-02122-w}

Diersen J, Trenkler G (1996). “Records Tests for Trend in Location.”
\emph{Statistics}, \strong{28}(1), 1-12.
\doi{10.1080/02331889708802543}

Diersen J, Trenkler G (2001). 
“Weighted Records Tests for Splitted Series of Observations.”
In J Kunert, G Trenkler (eds.), 
\emph{Mathematical Statistics with Applications in Biometry: Festschrift in Honour of Prof. Dr. Siegfried Schach}, 
pp. 163–178. Lohmar: Josef Eul Verlag.

Foster FG, Stuart A (1954). 
“Distribution-Free Tests in Time-Series Based on the Breaking of Records.”
\emph{Journal of the Royal Statistical Society. Series B (Methodological)}, 
\strong{16}(1), 1-22.
}
\seealso{
\code{\link{foster.test}}, \code{\link{N.plot}}, 
  \code{\link{N.test}}
}
\author{
Jorge Castillo-Mateo
}
