% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMutexAB.R
\name{getMutexAB}
\alias{getMutexAB}
\title{getMutexAB function}
\usage{
getMutexAB(
  A,
  PMA = getPM(A),
  B,
  PMB = getPM(B),
  lower.tail = TRUE,
  mixed = FALSE,
  th = 0.01,
  verbose = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{A}{The binary matrix of events A}

\item{PMA}{The corresponding probability matrix of A. It can be computed using function getPM. By default equal to getPM(A)}

\item{B}{The binary matrix of events B}

\item{PMB}{The corresponding probability matrix of B. It can be computed using function getPM. By default equal to getPM(B)}

\item{lower.tail}{True if mutually exclusive test. False for co-ocurrence. By default is TRUE.}

\item{mixed}{option to compute lower p.values with an exact method. By default TRUE}

\item{th}{upper threshold of p.value to apply the exact method.}

\item{verbose}{The verbosity of the output}

\item{parallel}{If the exact method is executed with a parallel process.}
}
\value{
A  matrix with the p.value of the corresponding test.
}
\description{
Given two binary matrices and its corresponding probability matrices PAij and PBij, compute the Poisson Binomial
method to estimate mutual exclusive events between A and B
}
\examples{
  
  #This first example is a basic 
  #example of how to perform getMutexAB. 
  
  data("A_example")
  data("B_example")
  PMA <- getPM(A_example)
  PMB <- getPM(B_example)
  mismutex <- getMutexAB(A=A_example, PM=PMA, B=B_example, PMB = PMB)
  
  \donttest{
  #The next example, is the same as the first
  # one but, using a matrix of class Matrix. 
  
  data("A_Matrix")
  data("B_Matrix")
  PMA <- getPM(A_Matrix)
  PMB <- getPM(B_Matrix)
  mismutex <- getMutexAB(A=A_Matrix, PM=PMA, B=B_Matrix, PMB = PMB)
  
  #Finally, the last example, shows a 
  #real example of how to perform this function
  # when using data from TCGA, Colon Adenocarcinoma in this case. 
  
  data("TCGA_COAD_AMP")
  data("AMP_COAD")
  data("PM_TCGA_COAD_AMP")
  data("PM_AMP_COAD")
  
  mismutex <- getMutexAB(A=TCGA_COAD_AMP, 
                         PMA=PM_TCGA_COAD_AMP,
                         B=AMP_COAD,
                         PMB = PM_AMP_COAD)
 }

}
