% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSizeReplicationSuccess.R
\name{sampleSizeReplicationSuccess}
\alias{sampleSizeReplicationSuccess}
\title{Computes the required relative sample size to achieve replication success
with the sceptical p-value}
\usage{
sampleSizeReplicationSuccess(
  zo,
  power = NA,
  level = 0.025,
  alternative = c("one.sided", "two.sided"),
  type = c("golden", "nominal", "controlled"),
  designPrior = c("conditional", "predictive", "EB"),
  shrinkage = 0,
  h = 0
)
}
\arguments{
\item{zo}{Numeric vector of z-values from original studies.}

\item{power}{The power to achieve replication success.}

\item{level}{Threshold for the calibrated sceptical p-value.
Default is 0.025.}

\item{alternative}{Specifies if \code{level} is "one.sided" (default) or
"two.sided". If "one.sided" then sample size calculations are based
on a one-sided assessment of replication success in the direction of the
original effect estimates.}

\item{type}{Type of recalibration. Can be either "golden" (default),
"nominal" (no recalibration), or "controlled". "golden" ensures that for
an original study just significant at the specified \code{level},
replication success is only possible for replication effect estimates
larger than the original one. "controlled" ensures exact overall Type-I
error control at level \code{level}^2.}

\item{designPrior}{Is only taken into account when \code{power} is specified.
Either "conditional" (default), "predictive", or "EB". If "EB", the power
is computed under a predictive distribution where the contribution of the
original study is shrunken towards zero based on the evidence in the
original study (with an empirical Bayes shrinkage estimator).}

\item{shrinkage}{Is only taken into account when \code{power} is specified. A
number in [0,1) with default 0. Specifies the shrinkage of the original
effect estimate towards zero (e.g., the effect is shrunken by a factor of
25\% for \code{shrinkage = 0.25}). Is only taken into account when the
\code{designPrior} is "conditional" or "predictive".}

\item{h}{Is only taken into account when \code{power} is specified and
\code{designPrior} is "predictive" or "EB". The relative between-study
heterogeneity, i.e., the ratio of the heterogeneity variance to the
variance of the original effect estimate. Default is 0 (no
heterogeneity).}
}
\value{
The relative sample size for replication success. If impossible to
    achieve the desired power for specified inputs \code{NaN} is returned.
}
\description{
The relative sample size to achieve replication success is computed based on
the z-value of the original study,  the type of
recalibration, the power and the design prior.
}
\details{
\code{sampleSizeReplicationSuccess} is the vectorized version of
    the internal function \code{.sampleSizeReplicationSuccess_}.
    \code{\link[base]{Vectorize}} is used to vectorize the function.
}
\examples{
## based on power
sampleSizeReplicationSuccess(zo = p2z(0.0025), power = 0.8, level = 0.025,
                             type = "golden")
sampleSizeReplicationSuccess(zo = p2z(0.0025), power = 0.8, level = 0.025,
                             type = "golden", designPrior = "predictive")
}
\references{
Held, L. (2020). A new standard for the analysis and design of replication
studies (with discussion). \emph{Journal of the Royal Statistical Society:
Series A (Statistics in Society)}, \bold{183}, 431-448.
\doi{10.1111/rssa.12493}

Held, L., Micheloud, C., Pawel, S. (2022). The assessment of replication
    success based on relative effect size. \emph{The Annals of Applied
Statistics}. 16:706-720. \doi{10.1214/21-AOAS1502}

Micheloud, C., Balabdaoui, F., Held, L. (2023). Assessing replicability
with the sceptical p-value: Type-I error control and
sample size planning. \emph{Statistica Neerlandica}. \doi{10.1111/stan.12312}
}
\seealso{
\code{\link{pSceptical}}, \code{\link{powerReplicationSuccess}},
    \code{\link{levelSceptical}}
}
\author{
Leonhard Held, Charlotte Micheloud, Samuel Pawel, Florian Gerber
}
