/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.formats;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import org.docx4j.dml.CTTextNoBullet;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.dml.CTTextSpacing;
import org.docx4j.dml.CTTextSpacingPoint;
import org.docx4j.dml.STTextAlignType;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.lysis.reporters.formats.BorderProperties;
import org.lysis.reporters.lists.LevelDefinition;
import org.lysis.reporters.lists.NumberingDefinition;

public class ParProperties {
    private String textalign;
    private int paddingbottom;
    private int paddingtop;
    private int paddingleft;
    private int paddingright;
    private int marginleft;
    private int marginright;
    private int margintop;
    private int marginbottom;
    private String liststyle;
    private int level;
    private BorderProperties borderBottom;
    private BorderProperties borderLeft;
    private BorderProperties borderTop;
    private BorderProperties borderRight;
    private String shading_color;
    private long ordered_num_id = -1L;
    private long unordered_num_id = -1L;

    public ParProperties(String textalign, int paddingbottom, int paddingtop, int paddingleft, int paddingright, int marginbottom, int margintop, int marginleft, int marginright, String liststyle, int level, BorderProperties borderBottom, BorderProperties borderLeft, BorderProperties borderTop, BorderProperties borderRight) {
        this.borderBottom = borderBottom;
        this.borderLeft = borderLeft;
        this.borderTop = borderTop;
        this.borderRight = borderRight;
        this.textalign = textalign;
        this.paddingbottom = paddingbottom;
        this.paddingtop = paddingtop;
        this.paddingleft = paddingleft;
        this.paddingright = paddingright;
        this.liststyle = liststyle;
        this.level = level;
        this.marginleft = marginleft;
        this.marginright = marginright;
        this.margintop = margintop;
        this.marginbottom = marginbottom;
    }

    public void setOrderedNumid(long id) {
        this.ordered_num_id = id;
    }

    public void setUnorderedNumid(long id) {
        this.unordered_num_id = id;
    }

    public String getTextalign() {
        return this.textalign;
    }

    public String getListStyle() {
        return this.liststyle;
    }

    public int getLevel() {
        return this.level;
    }

    public int getPaddingbottom() {
        return this.paddingbottom;
    }

    public int getPaddingtop() {
        return this.paddingtop;
    }

    public int getPaddingleft() {
        return this.paddingleft;
    }

    public int getPaddingright() {
        return this.paddingright;
    }

    public void setShadingColor(String shadingColor) {
        this.shading_color = shadingColor;
    }

    public void setPaddingLeft(int padding) {
        this.paddingleft = padding;
    }

    public void setMarginLeft(int margin) {
        this.marginleft = margin;
    }

    public void setMarginRight(int margin) {
        this.marginright = margin;
    }

    public void setMarginTop(int margin) {
        this.margintop = margin;
    }

    public void setMarginBottom(int margin) {
        this.marginbottom = margin;
    }

    public String getShadingColor() {
        return this.shading_color;
    }

    public boolean hasShadingColor() {
        return this.shading_color != null;
    }

    public ParProperties getClone() {
        ParProperties parProp = new ParProperties(this.textalign, this.paddingbottom, this.paddingtop, this.paddingleft, this.paddingright, this.marginbottom, this.margintop, this.marginleft, this.marginright, this.liststyle, this.level, this.borderBottom, this.borderLeft, this.borderTop, this.borderRight);
        if (this.shading_color != null) {
            parProp.setShadingColor(this.shading_color);
        }
        parProp.setOrderedNumid(this.ordered_num_id);
        parProp.setUnorderedNumid(this.unordered_num_id);
        return parProp;
    }

    public PPr get_docx_pp() {
        PPr parProperties = new PPr();
        Jc alignment = new Jc();
        if (this.textalign.equals("left")) {
            alignment.setVal(JcEnumeration.LEFT);
        } else if (this.textalign.equals("center")) {
            alignment.setVal(JcEnumeration.CENTER);
        } else if (this.textalign.equals("right")) {
            alignment.setVal(JcEnumeration.RIGHT);
        } else if (this.textalign.equals("justify")) {
            alignment.setVal(JcEnumeration.BOTH);
        }
        parProperties.setJc(alignment);
        PPrBase.Spacing space = new PPrBase.Spacing();
        space.setBefore(BigInteger.valueOf((long)this.paddingtop * 20L));
        space.setAfter(BigInteger.valueOf((long)this.paddingbottom * 20L));
        parProperties.setSpacing(space);
        if (this.shading_color != null) {
            CTShd shading = new CTShd();
            shading.setFill(this.shading_color);
            parProperties.setShd(shading);
        }
        PPrBase.PBdr parBorder = new PPrBase.PBdr();
        if (this.borderLeft.hasBorder()) {
            parBorder.setLeft(this.borderLeft.get_docx_bd());
        }
        if (this.borderBottom.hasBorder()) {
            parBorder.setBottom(this.borderBottom.get_docx_bd());
        }
        if (this.borderRight.hasBorder()) {
            parBorder.setRight(this.borderRight.get_docx_bd());
        }
        if (this.borderTop.hasBorder()) {
            parBorder.setTop(this.borderTop.get_docx_bd());
        }
        parProperties.setPBdr(parBorder);
        if ((this.getListStyle().equals("ordered") || this.getListStyle().equals("unordered")) && this.ordered_num_id > 0L) {
            PPrBase.NumPr.Ilvl ilvl = new PPrBase.NumPr.Ilvl();
            ilvl.setVal(BigInteger.valueOf(this.getLevel() - 1));
            PPrBase.NumPr.NumId numid = new PPrBase.NumPr.NumId();
            if (this.getListStyle().equals("ordered")) {
                numid.setVal(BigInteger.valueOf(this.ordered_num_id));
            } else if (this.getListStyle().equals("unordered")) {
                numid.setVal(BigInteger.valueOf(this.unordered_num_id));
            }
            PPrBase.NumPr numPr = new PPrBase.NumPr();
            numPr.setIlvl(ilvl);
            numPr.setNumId(numid);
            parProperties.setNumPr(numPr);
        } else if (this.getListStyle().equals("blockquote")) {
            PPrBase.Ind padding = new PPrBase.Ind();
            padding.setLeft(BigInteger.valueOf((long)this.paddingleft * 20L * (long)(this.getLevel() + 1)));
            padding.setRight(BigInteger.valueOf((long)this.paddingright * 20L * (long)(this.getLevel() + 1)));
            parProperties.setInd(padding);
        } else {
            PPrBase.Ind padding = new PPrBase.Ind();
            padding.setLeft(BigInteger.valueOf((long)this.paddingleft * 20L));
            padding.setRight(BigInteger.valueOf((long)this.paddingright * 20L));
            parProperties.setInd(padding);
        }
        return parProperties;
    }

    public CTTextParagraphProperties get_pptx_pp() {
        CTTextParagraphProperties parProperties = new CTTextParagraphProperties();
        if (this.textalign.equals("left")) {
            parProperties.setAlgn(STTextAlignType.L);
        } else if (this.textalign.equals("center")) {
            parProperties.setAlgn(STTextAlignType.CTR);
        } else if (this.textalign.equals("right")) {
            parProperties.setAlgn(STTextAlignType.R);
        } else if (this.textalign.equals("justify")) {
            parProperties.setAlgn(STTextAlignType.JUST);
        }
        CTTextSpacing spaceafter = new CTTextSpacing();
        CTTextSpacingPoint pointafter = new CTTextSpacingPoint();
        pointafter.setVal(this.paddingbottom * 100);
        spaceafter.setSpcPts(pointafter);
        parProperties.setSpcAft(spaceafter);
        CTTextSpacing spacebefore = new CTTextSpacing();
        CTTextSpacingPoint pointbefore = new CTTextSpacingPoint();
        pointbefore.setVal(this.paddingtop * 100);
        spacebefore.setSpcPts(pointbefore);
        parProperties.setSpcBef(spacebefore);
        parProperties.setMarR(Integer.valueOf(this.paddingright * 12700));
        parProperties.setMarL(Integer.valueOf(this.level * this.paddingleft * 12700));
        parProperties.setIndent(Integer.valueOf(0));
        parProperties.setBuNone(new CTTextNoBullet());
        return parProperties;
    }

    public CTTextParagraphProperties get_pptx_pp(NumberingDefinition nb, int startNumbering) {
        CTTextParagraphProperties parProperties = new CTTextParagraphProperties();
        if (this.textalign.equals("left")) {
            parProperties.setAlgn(STTextAlignType.L);
        } else if (this.textalign.equals("center")) {
            parProperties.setAlgn(STTextAlignType.CTR);
        } else if (this.textalign.equals("right")) {
            parProperties.setAlgn(STTextAlignType.R);
        } else if (this.textalign.equals("justify")) {
            parProperties.setAlgn(STTextAlignType.JUST);
        }
        CTTextSpacing spaceafter = new CTTextSpacing();
        CTTextSpacingPoint pointafter = new CTTextSpacingPoint();
        pointafter.setVal(this.paddingbottom * 100);
        spaceafter.setSpcPts(pointafter);
        parProperties.setSpcAft(spaceafter);
        CTTextSpacing spacebefore = new CTTextSpacing();
        CTTextSpacingPoint pointbefore = new CTTextSpacingPoint();
        pointbefore.setVal(this.paddingtop * 100);
        spacebefore.setSpcPts(pointbefore);
        parProperties.setSpcBef(spacebefore);
        parProperties.setMarR(Integer.valueOf(this.paddingright * 12700));
        if (this.getListStyle().equals("ordered") || this.getListStyle().equals("unordered")) {
            LevelDefinition ld = this.getListStyle().equals("ordered") ? nb.getOrdered().getLevelDefintion(this.level) : nb.getUnordered().getLevelDefintion(this.level);
            ld.set_pptx_scheme(parProperties, startNumbering);
        } else {
            parProperties.setMarL(Integer.valueOf(this.level * this.paddingleft * 12700));
            parProperties.setIndent(Integer.valueOf(0));
            parProperties.setBuNone(new CTTextNoBullet());
        }
        return parProperties;
    }

    public LinkedHashMap<String, String> get_html_pp() {
        LinkedHashMap<String, String> parProperties = new LinkedHashMap<String, String>();
        if (this.textalign.equals("left")) {
            parProperties.put("text-align", "left");
        } else if (this.textalign.equals("center")) {
            parProperties.put("text-align", "center");
        } else if (this.textalign.equals("right")) {
            parProperties.put("text-align", "right");
        } else if (this.textalign.equals("justify")) {
            parProperties.put("text-align", "justify");
        } else {
            parProperties.put("text-align", "left");
        }
        parProperties.put("padding-top", String.valueOf(this.paddingtop) + "pt");
        parProperties.put("padding-bottom", String.valueOf(this.paddingbottom) + "pt");
        parProperties.put("padding-right", String.valueOf(this.paddingright) + "pt");
        parProperties.put("padding-left", String.valueOf(this.paddingleft) + "pt");
        if (this.shading_color != null) {
            parProperties.put("background-color", this.shading_color);
        }
        if (this.marginleft > 0) {
            parProperties.put("margin-left", String.valueOf(this.marginleft) + "pt");
        }
        if (this.marginright > 0) {
            parProperties.put("margin-right", String.valueOf(this.marginright) + "pt");
        }
        if (this.margintop > 0) {
            parProperties.put("margin-top", String.valueOf(this.margintop) + "pt");
        }
        if (this.marginbottom > 0) {
            parProperties.put("margin-bottom", String.valueOf(this.marginbottom) + "pt");
        }
        if (this.borderBottom.hasBorder()) {
            parProperties.put("border-bottom-color", this.borderBottom.getBorderColor());
            parProperties.put("border-bottom-style", this.borderBottom.getBorderStyle());
            parProperties.put("border-bottom-width", String.valueOf(this.borderBottom.getBorderWidth()) + "px");
        }
        if (this.borderTop.hasBorder()) {
            parProperties.put("border-top-color", this.borderTop.getBorderColor());
            parProperties.put("border-top-style", this.borderTop.getBorderStyle());
            parProperties.put("border-top-width", String.valueOf(this.borderTop.getBorderWidth()) + "px");
        }
        if (this.borderRight.hasBorder()) {
            parProperties.put("border-right-color", this.borderRight.getBorderColor());
            parProperties.put("border-right-style", this.borderRight.getBorderStyle());
            parProperties.put("border-right-width", String.valueOf(this.borderRight.getBorderWidth()) + "px");
        }
        if (this.borderLeft.hasBorder()) {
            parProperties.put("border-left-color", this.borderLeft.getBorderColor());
            parProperties.put("border-left-style", this.borderLeft.getBorderStyle());
            parProperties.put("border-left-width", String.valueOf(this.borderLeft.getBorderWidth()) + "px");
        }
        return parProperties;
    }
}

