/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.docx4j.TraversalUtil;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.Body;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTObject;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.Pict;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainDocumentPartMceIgnorableHelper {
    private static Logger log = LoggerFactory.getLogger(MainDocumentPartMceIgnorableHelper.class);
    private static final List<String> w14SdtPrNames = new ArrayList<String>();
    private static final List<String> w15SdtPrNames = new ArrayList<String>();

    protected String getMceIgnorable(Body body) {
        PPr ppr;
        List<Object> content = body.getContent();
        if (content.size() == 0) {
            return null;
        }
        P p = null;
        for (Object o : content) {
            if (!(o instanceof P)) continue;
            p = (P)o;
            break;
        }
        if (p == null) {
            log.debug("traversing for w14, w15");
            IgnorablePrefixFinder finder = new IgnorablePrefixFinder();
            if (body.getSectPr() != null && body.getSectPr().getFootnoteColumns() != null) {
                finder.needW15 = true;
            }
            new TraversalUtil(content, finder);
            String mceIgnorableVal = "";
            if (finder.needW14) {
                mceIgnorableVal = "w14";
            }
            if (finder.needW15) {
                mceIgnorableVal = mceIgnorableVal + " w15";
            }
            return mceIgnorableVal;
        }
        if (p.getParaId() == null) {
            String uuid = UUID.randomUUID().toString();
            uuid = uuid.replace("-", "").substring(0, 8);
            p.setParaId(uuid);
            p.setTextId(uuid);
        }
        if ((ppr = p.getPPr()) == null) {
            ppr = Context.getWmlObjectFactory().createPPr();
            p.setPPr(ppr);
        }
        if (ppr.getCollapsed() == null) {
            BooleanDefaultTrue notCollapsed = new BooleanDefaultTrue();
            notCollapsed.setVal(Boolean.FALSE);
            ppr.setCollapsed(notCollapsed);
        }
        return "w14 w15";
    }

    static {
        w14SdtPrNames.add("checkbox");
        w14SdtPrNames.add("entityPicker");
        w15SdtPrNames.add("appearance");
        w15SdtPrNames.add("color");
        w15SdtPrNames.add("repeatingSection");
        w15SdtPrNames.add("repeatingSectionItem");
        w15SdtPrNames.add("webExtensionCreated");
        w15SdtPrNames.add("webExtensionLinked");
        w15SdtPrNames.add("dataBinding");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnorablePrefixFinder
    extends TraversalUtil.CallbackImpl {
        boolean needW14 = false;
        boolean needW15 = false;

        private IgnorablePrefixFinder() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof P) {
                PPr ppr;
                P p = (P)o;
                if (p.getParaId() != null) {
                    this.needW14 = true;
                }
                if (!this.needW15 && (ppr = p.getPPr()) != null) {
                    if (ppr.getCollapsed() != null) {
                        this.needW15 = true;
                    }
                    if (ppr.getSectPr() != null && ppr.getSectPr().getFootnoteColumns() != null) {
                        this.needW15 = true;
                    }
                }
            } else if (o instanceof SdtElement) {
                SdtPr sdtPr = ((SdtElement)o).getSdtPr();
                if (sdtPr != null) {
                    if (this.contains(sdtPr.getRPrOrAliasOrLock(), "http://schemas.microsoft.com/office/word/2010/wordml", w14SdtPrNames)) {
                        this.needW14 = true;
                    }
                    if (this.contains(sdtPr.getRPrOrAliasOrLock(), "http://schemas.microsoft.com/office/word/2012/wordml", w15SdtPrNames)) {
                        this.needW15 = true;
                    }
                }
            } else if (o instanceof Tr) {
                if (((Tr)o).getParaId() != null) {
                    this.needW14 = true;
                }
            } else if (o instanceof CTObject) {
                if (((CTObject)o).getAnchorId() != null) {
                    this.needW14 = true;
                }
            } else if (o instanceof Pict && ((Pict)o).getAnchorId() != null) {
                this.needW14 = true;
            }
            return null;
        }

        private boolean contains(List<Object> list, String namespace, List<String> elementNames) {
            for (Object o : list) {
                QName qname;
                if (!(o instanceof JAXBElement) || !namespace.equals((qname = ((JAXBElement)o).getName()).getNamespaceURI()) || !elementNames.contains(qname.getLocalPart())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            if (o instanceof P) {
                return false;
            }
            return !this.needW14 || !this.needW15;
        }
    }
}

