% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{combine_rs_res}
\alias{combine_rs_res}
\title{Combine the results of 'step by step GRSA'}
\usage{
combine_rs_res(kodf, group, metadata, ko_stat, reporter_s, modulelist = NULL)
}
\arguments{
\item{kodf}{KO_abundance table, rowname are feature ids (e.g. K00001 if feature="ko"; PEX11A if feature="gene"; C00024 if feature="compound"), colnames are samples.}

\item{group}{The comparison groups (at least two categories) in your data, one column name of metadata when metadata exist or a vector whose length equal to columns number of kodf. And you can use factor levels to change order.}

\item{metadata}{sample information data.frame contains group}

\item{ko_stat}{result of \code{\link{pvalue2zs}}}

\item{reporter_s}{result of \code{\link{get_reporter_score}}}

\item{modulelist}{NULL or customized modulelist dataframe, must contain 'id','K_num','KOs','Description' columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}
}
\value{
reporter_score object
}
\description{
Combine the results of 'step by step GRSA'
}
\examples{
\donttest{
data("KO_abundance_test")
ko_pvalue <- ko.test(KO_abundance, "Group", metadata)
ko_stat <- pvalue2zs(ko_pvalue, mode = "directed")
reporter_s1 <- get_reporter_score(ko_stat, perm = 499)
reporter_res <- combine_rs_res(KO_abundance, "Group", metadata, ko_stat, reporter_s1)
}
}
\seealso{
Other GRSA: 
\code{\link{get_reporter_score}()},
\code{\link{ko.test}()},
\code{\link{pvalue2zs}()},
\code{\link{reporter_score}()}
}
\concept{GRSA}
