% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_features_network}
\alias{plot_features_network}
\alias{plot_KOs_network}
\title{Plot features network}
\usage{
plot_features_network(
  ko_stat,
  map_id = "map00780",
  near_pathway = FALSE,
  modulelist = NULL,
  kos_color = c(Depleted = "seagreen", Enriched = "orange", None = "grey", Significant =
    "red2", Pathway = "#80b1d3"),
  pathway_label = TRUE,
  kos_label = TRUE,
  mark_module = FALSE,
  mark_color = NULL,
  return_net = FALSE,
  ...
)
}
\arguments{
\item{ko_stat}{ko_stat result from \code{\link{pvalue2zs}} or result of `get_reporter_score`}

\item{map_id}{the pathway or module id}

\item{near_pathway}{show the near_pathway if any features exist.}

\item{modulelist}{NULL or customized modulelist dataframe, must contain "id","K_num","KOs","Description" columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{kos_color}{default, c("Depleted"="seagreen","Enriched"="orange","None"="grey","Significant"="red2")}

\item{pathway_label}{show pathway_label?}

\item{kos_label}{show kos_label?}

\item{mark_module}{mark the modules?}

\item{mark_color}{mark colors, default, c("Depleted"="seagreen","Enriched"="orange","None"="grey","Significant"="red2")}

\item{return_net}{return the network}

\item{...}{additional arguments for \code{\link[MetaNet]{c_net_plot}}}
}
\value{
network plot
}
\description{
Plot features network
}
\examples{
if (requireNamespace("MetaNet")) {
  data("reporter_score_res")
  plot_features_network(reporter_score_res, map_id = "map05230")
  plot_features_network(reporter_score_res, map_id = "map00780", near_pathway = TRUE)
}
}
