% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{seedset-class}
\alias{seedset-class}
\title{\code{seedset-class}}
\description{
Object representing the seed sets of a given metabolic network
}
\section{Slots}{

\describe{
\item{\code{GsMN,}}{a igraph network}

\item{\code{seeds,}}{a character list represents seeds of a given metabolic
     network which is composed of  the KEGG compound index.}
}}
\section{method}{

   \itemize{
     \item{getGsMN, \code{signature(object = "seedset")}:
       get the genome scale metabolic network whose seed set is caculated}
     \item{len, \code{signature(object = "seedset")}:
       return the number of source SCC}
     \item{seedSize, \code{signature(object = "seedset")}:
       returns the sizes of each source SCCs}
     \item{nonseed, \code{signature(object = "seedset")}:
       the non seeds of the GsMN}
     \item{show, \code{signature(object = "seedset")}:
       show the short summary of a seedset class}
     \item{confidencescore, \code{signature(object = "seedset")}:
       confidence score of the seed set}
 }
}
\seealso{
\code{\link{getSeedSets}}
}

