% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processPostPredStats.R
\name{processPostPredStats}
\alias{processPostPredStats}
\title{process Posterior Predictive Statistics}
\usage{
processPostPredStats(path_sim, path_emp)
}
\arguments{
\item{path_sim}{(character string; no default) Path to the .csv file
containing the simulated data results}

\item{path_emp}{(character string; no default) Path to the .csv file
containing the empirical values}
}
\value{
A list of data frames
}
\description{
Reads in and processes posterior-predictive statistics
}
\examples{

\donttest{
# download the example datasets to working directory

url_emp <-
   "https://revbayes.github.io/tutorials/intro/data/empirical_data_pps_example.csv"
dest_path_emp <- "empirical_data_pps_example.csv"
download.file(url_emp, dest_path_emp)

url_sim <-
   "https://revbayes.github.io/tutorials/intro/data/simulated_data_pps_example.csv"
dest_path_sim <- "simulated_data_pps_example.csv"
download.file(url_sim, dest_path_sim)

# to run on your own data, change this to the path to your data file
file_sim <- dest_path_sim
file_emp <- dest_path_emp

t <- processPostPredStats(path_sim = file_sim,
                         path_emp = file_emp)

# remove files
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_sim, dest_path_emp)
}


}
