% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestry.R
\name{getOOBpreds-forestry}
\alias{getOOBpreds-forestry}
\alias{getOOBpreds}
\title{getOOBpreds-forestry}
\usage{
getOOBpreds(object, newdata = NULL, doubleOOB = FALSE, noWarning = FALSE)
}
\arguments{
\item{object}{A trained model object of class "forestry".}

\item{newdata}{A possible new data frame on which to run out of bag
predictions. If this is not NULL, we assume that the indices of
newdata are the same as the indices of the training set, and will use
these to find which trees the observation is considered in/out of bag for.}

\item{doubleOOB}{A flag specifying whether or not we should use the double OOB
set for the OOB predictions. This is the set of observations for each tree which
were in neither the averaging set nor the splitting set. Note that the forest
must have been trained with doubleBootstrap = TRUE for this to be used. Default
is FALSE.}

\item{noWarning}{Flag to not display warnings.}
}
\value{
The vector of all training observations, with their out of bag
 predictions. Note each observation is out of bag for different trees, and so
 the predictions will be more or less stable based on the observation. Some
 observations may not be out of bag for any trees, and here the predictions
 are returned as NA.
}
\description{
Calculate the out-of-bag predictions of a given forest.
}
\seealso{
\code{\link{forestry}}
}
