% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fforecast.R
\name{plot.fforecast}
\alias{plot.fforecast}
\title{Plot Method for FSSA Forecast (fforecast) Class}
\usage{
\method{plot}{fforecast}(
  x,
  group_index = NULL,
  ask = TRUE,
  npts = 100,
  obs = 1,
  main = NULL,
  col = NULL,
  ori_col = NULL,
  type = "l",
  lty = 1,
  ...
)
}
\arguments{
\item{x}{an object of class \code{fforecast}.}

\item{group_index}{an integer specifying the group index for the plot.}

\item{ask}{logical: If `TRUE`, and  `group_index` be `NULL`, after printing the first grouping graphic, it will pause when the user asks for the next group graphic and wait.}

\item{npts}{number of grid points for the plots.}

\item{obs}{observation number (for two-dimensional domains).}

\item{main}{main title for the plot.}

\item{col}{specify the predicted FTS color; if it is `NULL`, it will be set as the default.}

\item{ori_col}{specify the original FTS color; if it is `NULL`, it will be set as the default.}

\item{type}{type of plot ("l" for line, "p" for points, etc.).}

\item{lty}{line type (1 for solid, 2 for dashed, etc.).}

\item{...}{additional graphical parameters passed to plotting functions.}
}
\description{
Create visualizations of FSSA Forecast (fforecast) class. This function supports
plotting `fforecast` data with one-dimensional or two-dimensional domains.
}
\seealso{
\code{\link{fforecast}}
}
