% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_SCORE2_func.R
\name{SCORE2/OP}
\alias{SCORE2/OP}
\alias{SCORE2}
\title{Systematic COronary Risk Evaluation (SCORE) model}
\usage{
SCORE2(
  Age = Age,
  Gender = Gender,
  smoker = smoker,
  systolic.bp = systolic.bp,
  diabetes = diabetes,
  total.chol = total.chol,
  total.hdl = total.hdl,
  classify
)
}
\arguments{
\item{Age}{a numeric vector of age values, in years}

\item{Gender}{a binary character vector of Gender values. Categories should include only 'male' or 'female'.}

\item{smoker}{a binary numeric vector, 1 = yes and 0 = no}

\item{systolic.bp}{a numeric vector of systolic blood pressure continuous values}

\item{diabetes}{a binary numeric vector, 1 = yes and 0 = no}

\item{total.chol}{a numeric vector of total cholesterol values, in mmol/L}

\item{total.hdl}{a numeric vector of total high density lipoprotein total.hdl values, in mmol/L}

\item{classify}{set TRUE if wish to add a column with the scores' categories}
}
\value{
A vector with SCORE2/OP score calculations
and/or a vector of their classifications if indicated
}
\description{
This function implements the SCORE2 and SCORE2 older population (OP) score calculation as a vector

formula in SCORE2 Updated Supplementary Material page  9. paper:
"SCORE2 risk prediction algorithms: new models to estimate 10-year risk of cardiovascular disease in Europe"

Age	10-year risk of fatal and non-fatal cardiovascular disease

                | Low risk      |  Moderate risk  | High risk  |\cr
| ------------- | ------------- | :-------------: | ----------:|\cr
| < 50 years    |   <2.5%	     |  2.5 to <7.5%   |    =>7.5%   |\cr
| 50 - 69 years |    <5%        |   5 to <10%	   |     =>10%   |\cr
| => 70 years    |   <7.5%	     |  7.5 to <15% 	 |     =>15%   |\cr


above classifications referred from https://www.inanutshell.ch/en/digital-doctors-bag/score2-and-score2-op/#:~:text=SCORE2%20(%C2%ABSystematic%20COronary%20Risk%20Evaluation,Society%20of%20Cardiology%20(ESC).
}
\examples{

# Create a data frame or list with the necessary variables
# Set the number of rows
num_rows <- 100

# Create a larger dataset with 100 rows
cohort_xx <- data.frame(
  typical_symptoms.num = as.numeric(sample(0:6, num_rows, replace = TRUE)),
  ecg.normal = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  abn.repolarisation = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  ecg.st.depression = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  Age = as.numeric(sample(30:80, num_rows, replace = TRUE)),
  diabetes = sample(c(1, 0), num_rows, replace = TRUE),
  smoker = sample(c(1, 0), num_rows, replace = TRUE),
  hypertension = sample(c(1, 0), num_rows, replace = TRUE),
  hyperlipidaemia = sample(c(1, 0), num_rows, replace = TRUE),
  family.history = sample(c(1, 0), num_rows, replace = TRUE),
  atherosclerotic.disease = sample(c(1, 0), num_rows, replace = TRUE),
  presentation_hstni = as.numeric(sample(10:100, num_rows, replace = TRUE)),
  Gender = sample(c("male", "female"), num_rows, replace = TRUE),
  sweating = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  pain.radiation = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  pleuritic = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  palpation = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  ecg.twi = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  second_hstni = as.numeric(sample(1:200, num_rows, replace = TRUE)),
  killip.class = as.numeric(sample(1:4, num_rows, replace = TRUE)),
  systolic.bp = as.numeric(sample(0:300, num_rows, replace = TRUE)),
  heart.rate = as.numeric(sample(0:300, num_rows, replace = TRUE)),
  creat = as.numeric(sample(0:4, num_rows, replace = TRUE)),
  cardiac.arrest = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  previous.pci = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  previous.cabg = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  aspirin = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  number.of.episodes.24h = as.numeric(sample(0:20, num_rows, replace = TRUE)),
  total.chol = as.numeric(sample(5:100, num_rows, replace = TRUE)),
  total.hdl = as.numeric(sample(2:5, num_rows, replace = TRUE)),
  Ethnicity = sample(c("white", "black", "asian", "other"), num_rows, replace = TRUE)
)

# Call the function with the cohort_xx

  results <- cohort_xx \%>\% rowwise() \%>\%
  mutate(SCORE2OP_score = SCORE2(Age, Gender, smoker, systolic.bp, diabetes,
  total.chol, total.hdl, classify = FALSE))

}
\keyword{Age}
\keyword{Gender}
\keyword{SCORE2/OP}
\keyword{classify}
\keyword{diabetes}
\keyword{smoker}
\keyword{systolic.bp}
\keyword{total.chol}
\keyword{total.hdl}
