% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_Tests.R
\name{JBTest}
\alias{JBTest}
\title{Jarque-Bera Test}
\usage{
JBTest(data, alpha = 0.05, j = 1, N_Sample = 10000)
}
\arguments{
\item{data}{Data of a univariate distribution for which the test statistic is computed
(vector)}

\item{alpha}{The two-sided decision threshold used for hypothesis-testing}

\item{j}{The # hypotheses tested; used to compute a Bonferonni correction, if applicable;
should remain at its default if multiple testing is not an issue (scalar)}

\item{N_Sample}{The # samples used to generate the bootstrapped sampling distribution,
in cases when N <= 2000 (scalar)}
}
\value{
An object including the test statistic, p-value, and a significance flag (list)
}
\description{
This function performs the Jarque-Bera test for normality using adjusted Fisher-
Pearson skewness and kurtosis coefficients.
}
\details{
Large samples (N >= 2000) use p-values obtained with reference to the chi-square
distribution, whereas smaller samples output p-values obtained via bootstrapping.
}
\examples{
values <- rnorm(100)
x <- JBTest(data = values)
}
\references{
Jarque, C. M. and Bera, A. K. (1980). Efficient test for normality, homoscedasticity and serial independence of residuals. Economic Letters, 6(3), pp. 255-259.

            Shreve, Joni N. and Donna Dea Holland . 2018. SAS® Certification Prep
            Guide: Statistical Business Analysis Using SAS®9. Cary, NC: SAS Institute Inc.
}
