/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.LinkedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFile
extends LinkedNode
implements Comparable<DataFile> {
    protected final File file;
    protected final Integer dataFileId;
    protected final int preferedSize;
    protected int length;
    protected int referenceCount;

    DataFile(File file, int number, int preferedSize) {
        this.file = file;
        this.preferedSize = preferedSize;
        this.dataFileId = number;
        this.length = (int)(file.exists() ? file.length() : 0L);
    }

    File getFile() {
        return this.file;
    }

    public Integer getDataFileId() {
        return this.dataFileId;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public synchronized void incrementLength(int size) {
        this.length += size;
    }

    public synchronized int increment() {
        return ++this.referenceCount;
    }

    public synchronized int decrement() {
        return --this.referenceCount;
    }

    public synchronized int getReferenceCount() {
        return this.referenceCount;
    }

    public synchronized boolean isUnused() {
        return this.referenceCount <= 0;
    }

    public synchronized String toString() {
        String result = this.file.getName() + " number = " + this.dataFileId + " , length = " + this.length + " refCount = " + this.referenceCount;
        return result;
    }

    public synchronized RandomAccessFile openRandomAccessFile(boolean appender) throws IOException {
        RandomAccessFile rc = new RandomAccessFile(this.file, "rw");
        if (appender && this.length < this.preferedSize) {
            try {
                rc.setLength(this.preferedSize);
            }
            catch (IOException ioe) {
                try {
                    rc.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw ioe;
            }
        }
        return rc;
    }

    public synchronized void closeRandomAccessFile(RandomAccessFile file) throws IOException {
        if ((long)this.length != file.length()) {
            file.setLength(this.getLength());
        }
        file.close();
    }

    public synchronized boolean delete() throws IOException {
        return this.file.delete();
    }

    public synchronized void move(File targetDirectory) throws IOException {
        IOHelper.moveFile(this.file, targetDirectory);
    }

    @Override
    public int compareTo(DataFile df) {
        return this.dataFileId - df.dataFileId;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DataFile) {
            result = this.compareTo((DataFile)o) == 0;
        }
        return result;
    }

    public int hashCode() {
        return this.dataFileId;
    }
}

