% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceemdan.R
\name{ceemdan}
\alias{ceemdan}
\title{CEEMDAN decomposition}
\usage{
ceemdan(input, num_imfs = 0, ensemble_size = 250L, noise_strength = 0.2,
  S_number = 4L, num_siftings = 50L, rng_seed = 0L, threads = 0L)
}
\arguments{
\item{input}{Vector of length N. The input signal to decompose.}

\item{num_imfs}{Number of Intrinsic Mode Functions (IMFs) to compute. If num_imfs is set to zero,
a value of num_imfs = emd_num_imfs(N) will be used, which corresponds to a maximal number of 
IMFs. Note that the final residual is also counted as an IMF in this respect, so you most 
likely want at least num_imfs=2.}

\item{ensemble_size}{Number of copies of the input signal to use as the ensemble.}

\item{noise_strength}{Standard deviation of the Gaussian random numbers used as additional noise.
\bold{This value is relative} to the standard deviation of the input signal.}

\item{S_number}{Integer. Use the S-number stopping criterion for the EMD procedure with the given
values of $S$. That is, iterate until the number of extrema and zero crossings in the signal 
differ at most by one, and stay the same for S consecutive iterations. Typical values are in 
the range 3--8. If \code{S_number} is zero, this stopping criterion is ignored. Default is 4.}

\item{num_siftings}{Use a maximum number of siftings as a stopping criterion. If 
\code{num_siftings} is zero, this stopping criterion is ignored. Default is 50.}

\item{rng_seed}{A seed for the GSL's Mersenne twister random number generator. A value of zero 
(default) denotes an implementation-defined default value. For \code{ceemdan} this does not guarantee
reproducible results if multiple threads are used.}

\item{threads}{Non-negative integer defining the maximum number of parallel threads (via OpenMP's
\code{omp_set_num_threads}. Default value 0 uses all available threads defined by OpenMP's 
\code{omp_get_max_threads}.}
}
\value{
Time series object of class \code{"mts"} where series corresponds to
       IMFs of the input signal, with the last series being the final residual.
}
\description{
Decompose input data to Intrinsic Mode Functions (IMFs) with the
Complete Ensemble Empirical Mode Decomposition with Adaptive Noise (CEEMDAN)
algorithm [1], a variant of EEMD.
}
\details{
The size of the ensemble and the relative magnitude of the added noise are
given by parameters \code{ensemble_size} and \code{noise_strength}, respectively.  The
stopping criterion for the decomposition is given by either a S-number [2] or
an absolute number of siftings. In the case that both are positive numbers,
the sifting ends when either of the conditions is fulfilled.
}
\examples{
imfs <- ceemdan(UKgas, threads = 1)
# trend extraction
ts.plot(UKgas, imfs[, ncol(imfs)], col = 1:2, 
        main = "Quarterly UK gas consumption", ylab = "Million therms")

# CEEMDAN for logarithmic demand, note that increasing ensemble size 
# will produce smoother results
imfs <- ceemdan(log(UKgas), ensemble_size = 50, threads = 1)
plot(ts.union("log(obs)" = log(UKgas), Seasonal = imfs[, 1], 
     Irregular = rowSums(imfs[, 2:5]), Trend = imfs[, 6]), 
     main = "Quarterly UK gas consumption")
}
\references{
\enumerate{ 
 \item{M. Torres et al, "A Complete Ensemble Empirical Mode Decomposition with Adaptive Noise"
  IEEE Int. Conf. on Acoust., Speech and Signal Proc. ICASSP-11,
  (2011) 4144--4147}
 \item{N. E. Huang, Z. Shen and S. R. Long, "A new view of nonlinear water
      waves: The Hilbert spectrum", Annual Review of Fluid Mechanics, Vol. 31
      (1999) 417--457}
      }
}
\seealso{
\code{\link{eemd}}
}
