\name{scagNav}
\alias{scagNav}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Start a navGraph session and filter the navigation graph's node
  according to some scagnostic measures
}
\description{
  Scanotstics assigns each possible scatterplot combination a weight for
  the attribute "Outlying", "Skewed", "Clumpy", "Sparse", "Striated",
  "Convex", "Skinny", "Stringy", "Monotonic".

  With \code{scagNav} one can start a \code{navGraph} session that
  constructs a navigation graph that shows certain properties most.

  See the vignette for more examples.
}
\usage{
scagNav(data,
	 	scags = c("Clumpy", "NotClumpy", "Monotonic", "NotMonotonic",
				"Convex", "NotConvex", "Stringy", "NotStringy",
				"Skinny", "NotSkinny", "Outlying","NotOutlying",
				"Sparse", "NotSparse", "Striated", "NotStriated",
				"Skewed", "NotSkewed"),
        topFrac = 0.2, combineFn = NULL,
        settings = NULL, glyphs = NULL,
        images = NULL, sep = ":",
        layout = "circle")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
    a single- or a \code{list} of objects generated by the
    \code{\link{ng_graph}} function. I.e. objects from the NG_data
    class.
  }
  \item{scags}{
    Single element or a subset of (with possible a "Not" preceding): \cr
      "Outlying", "Skewed", "Clumpy", "Sparse", "Striated",\cr
      "Convex", "Skinny", "Stringy", "Monotonic"
}
  \item{topFrac}{
    Keep the nodes with the \code{topFrac} fraction of the scagnostic
    weights.
}
  \item{combineFn}{
    Must be a function that takes in a vector of length \code{scags} and
    returns a single value. This return value comprises the new weights
    of the nodes get selected from.
}
  \item{settings}{
        a list of pailists. See the \code{\link{navGraph}} documentation.
}
  \item{glyphs}{
        Vector of character strings matching either the \code{names} or
	\code{shortnames} of the NG_data object.
}
  \item{images}{
    NG_image object. Order of the images must match the order of the
    data in the NG_data object. 
}
  \item{sep}{
    Node names represent a set of variables whose name are separated by
    the character string \code{sep} (containing no spaces).
}
\item{layout}{
  One of the following strings: "circle", "kamadaKawaiSpring",
  "fruchtermanReingold" or "random".
}
}
%\details{  %%  ~~ If necessary, more details than the description above ~~}
\value{
  navGraph handler.
}
%\references{%% ~put references to the literature/web site here ~}
\author{
  Adrian Waddell and R. Wayne Oldford
}
%\note{%%  ~~further notes~~}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{navGraph}}, \code{\link{scagEdgeWeights}},
  \code{\link{scagGraph}}, \code{\link{ng_data}}
}

\examples{
## Define a NG_data object
data(olive)
ng.olive <- ng_data(name = "Olive",
		data = olive[,-c(1,2)],
		shortnames = c("p1","p2","s","ol","l1","l2","a","e"),
		group = as.numeric(olive$Area)+1
)

\donttest{nav <- scagNav(data = ng.olive,
		scags = c("Skinny", "Sparse", "NotConvex"),
		topFrac = 0.2,
		combineFn = max,
		glyphs = shortnames(ng.olive)[1:8],
		sep = ':')}

\donttest{nav <- scagNav(data = ng.olive,
		scags = c("Skinny", "Sparse", "NotConvex"),
		topFrac = 0.2,
		glyphs = shortnames(ng.olive)[1:8],
		sep = ':')}

}
