% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/masq.R
\name{masqOLS}
\alias{masqOLS}
\title{Extract raster pixel values within the boundaries of a polygon}
\usage{
masqOLS(shp, rast, i, retVal)
}
\arguments{
\item{shp}{the country Polygon layer as SpatialPolygon}

\item{rast}{the clipped country raster}

\item{i}{the index of the polygon in the country polygon layer (shp)}

\item{retVal}{Whether to return the raster data as a vector, or 
data.frame with spatial context NULL returns a vector of all
values, colrowval returns a data.frame with row, col and raster
value while lonlatval returns a data.frame with lon,lat and val.}
}
\value{
numeric vector of radiances
}
\description{
Extract raster pixel values within the boundaries of a polygon
}
\examples{
\dontrun{
ctryPoly <- rgdal::readOGR(getPolyFnamePath("KEN"), getCtryShpLyrNames("KEN", 1))
ctryRaster <- raster::raster(getCtryRasterOutputFnamePath("KEN", "OLS", "1999"))
temp <- NULL
KenAdm1Sum <- NULL
for (i in 1:length(ctryPoly@polygons))
{
 temp$name <- as.character(ctryPoly@data$NAME_1[i])
 temp$sum <- sum(masqOLS(ctryPoly, ctryRaster, i), na.rm=T)

 KenAdm1Sum <- rbind(KenAdm1Sum)
}
}

}
