% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{myZonal}
\alias{myZonal}
\title{Calculate zonal statistics. Used internally}
\usage{
myZonal(rast, zone, nlStats, digits = 0, retVal = NULL, na.rm = TRUE, ...)
}
\arguments{
\item{rast}{the country raster}

\item{zone}{the zonal country polygon layer}

\item{nlStats}{a character list of statistics to calculate}

\item{digits}{round off to how many decimals}

\item{retVal}{Whether to return the raster data as a vector, or 
data.frame with spatial context NULL returns a vector of all
values, colrowval returns a data.frame with row, col and raster
value while lonlatval returns a data.frame with lon,lat and val.}

\item{na.rm}{how to handle NAs}

\item{...}{Other params to pass to the nlStats functions e.g. na.rm}
}
\value{
numeric value result of the given nlStat function
}
\description{
Calculate zonal statistics. Used internally by zonalpipe. Modified from 
    \url{http://www.guru-gis.net/efficient-zonal-statistics-using-r-and-gdal/}
}
