\encoding{latin1}
\name{Mrk421}
\docType{data}
\alias{Mrk421}
\title{Data: Light curve from Mrk 421}
\description{
Gamma ray light curve from Markarian 421.
}
\usage{Mrk421}
\format{A data frame of three variables, with a time series of length 655 appropriate to \code{\link{RobPer}}.}
\source{Data kindly provided by the Deutsches Elektronen-Synchrotron, Gamma Astronomy group (see Details).}
\details{
	The data in Mrk421 and Mrk501 have been collected from various original sources, combined, and published by Tluczykont et al. (2010) of the Deutsches Elektronen-Synchrotron, available from \url{http://astro.desy.de/gamma_astronomy/magic/projects/light_curve_archive/index_eng.html}.
	
	Their sources are data from the experiments:
	
	Whipple (Kerrick et al. 1995; Schubnell et al. 1996; Buckley et al. 1996; Maraschi et al. 1999)
	
	HEGRA (Aharonian et al. 1999a, 1999b; Krawczynski et al. 2001; Aharonian et al. 2001, 2002, 2003, 2004; Kestel 2003)
	
	CAT (Piron 2000; Piron et al. 2001)
	
	HESS (Aharonian et al. 2005, 2006)
	
	MAGIC (Albert et al. 2008; Donnarumma et al. 2009)
	
	VERITAS (Rebillot et al. 2006; Donnarumma et al. 2009)
}
\references{
Tluczykont, M., Bernardini, E., Satalecka, K., Clavero, R., Shayduk, M. and Kalekin, O. (2010): Long-term lightcurves from combined united very high energy gamma-ray data. Astronomy & Astrophysics, 524, A48

Their data sources:

Aharonian, F., Akhperjanian, A., Barrio, J., et al. (1999a): The temporal characteristics of the TeV gamma-radiation from Mkn 501 in 1997: I. Data from the stereoscopic imaging atmospheric Cherenkov telescope system of HEGRA. Astronomy & Astrophysics, 342(1), 69

Aharonian, F., Akhperjanian, A., Barrio, J., et al. (1999b): The temporal characteristics of the TeV gamma-emission from Mkn 501 in 1997: II. Results from HEGRA CT1 and CT2. Astronomy & Astrophysics, 349(1), 29

Aharonian, F., Akhperjanian, A., Barrio, J., et al. (2001): The TeV Energy Spectrum of Markarian 501 Measured with the Stereoscopic Telescope System of HEGRA during 1998 and 1999. The Astrophysical Journal, 546(2), 898

Aharonian, F., Akhperjanian, A., Beilicke, M., et al. (2002): Variations of the TeV energy spectrum at different flux levels of Mkn 421 observed with the HEGRA system of Cherenkov telescopes. Astronomy & Astrophysics, 393(1), 89

Aharonian, F., Akhperjanian, A., Beilicke, M., et al. (2003): TeV gamma-ray light curve and energy spectrum of Mkn 421 during its 2001 flare as measured with HEGRA CT1. Astronomy & Astrophysics, 410(3), 813

Aharonian, F., Akhperjanian, A., Beilicke, M., et al. (2004): The Crab Nebula and Pulsar between 500 GeV and 80 TeV: Observations with the HEGRA Stereoscopic Air Cerenkov Telescopes. The Astrophysical Journal, 614(2), 897

Aharonian, F., Akhperjanian, A., Aye, K., et al. (2005): Observations of Mkn 421 in 2004 with HESS at large zenith angles. Astronomy & Astrophysics, 437(1), 95

Aharonian, F., Akhperjanian, A., Bazer-Bachi, A. R., et al. (2006): Observations of the Crab nebula with HESS. Astronomy & Astrophysics, 457(3), 899

Albert, J., Aliu, E., Anderhub, H., et al. (2008): VHE gamma-Ray Observation of the Crab Nebula and its Pulsar with the MAGIC Telescope. The Astrophysical Journal, 674(2), 1037

Buckley, J. H., Akerlof, C. W., Biller, S., et al. (1996): Gamma-Ray Variability of the BL Lacertae Object Markarian 421. The Astrophysical Journal, 472, L9

Donnarumma, I., Vittorini, V., Vercellone, S., et al. (2009): The June 2008 Flare of Markarian 421 from Optical to TeV Energies. The Astrophysical Journal, 691, L13

Kerrick, A. D., Akerlof, C. W., Biller, S. D., et al. (1995): Outburst of TeV photons from Markarian 421. The Astrophysical Journal, 438, L59

Kestel, M. (2003): TeV gamma-Flux and Spectrum of Markarian 421 in 1999/2000 with Hegra CT1 using refined Analysis Methods. Ph.D. Thesis, Technische \enc{Universitt}{Universitaet} \enc{Mnchen}{Muenchen}

Krawczynski, H., Sambruna, R., Kohnle, A., et al. (2001): Simultaneous X-Ray and TeV Gamma-Ray Observation of the TeV Blazar Markarian 421 during 2000 February and May. The Astrophysical Journal, 559(1), 187

Maraschi, L., Fossati, G., Tavecchio, F., et al. (1999): Simultaneous X-Ray and TeV Observations of a Rapid Flare from Markarian 421. The Astrophysical Journal, 526, L81

Piron, F. (2000): \enc{tude}{Etude} des \enc{proprits}{proprietes} spectrales et de la \enc{variabilit}{variabilite} de l'\enc{mission}{emission} Gamma \enc{suprieure}{superieure} \enc{}{a} 250 GeV des blazars \enc{observs}{observes} entre Octobre 1996 et \enc{Fvrier}{Fevrier} 2000 par le \enc{tlescope}{telescope} \enc{}{a} effet Tcherenkov \enc{athmosphrique}{athmospherique} C.A.T. Ph.D. Thesis, \enc{Universit}{Universite} de Paris-Sud

Piron, F., Djannati-Atai, A., Punch, M., et al. (2001): Temporal and spectral gamma-ray properties of Mkn 421 above 250 GeV from CAT observations between 1996 and 2000. Astronomy & Astrophysics, 374(3), 895

Rebillot, P. F., Badran, H. M., Blaylock, G., et al. (2006): Multiwavelength Observations of the Blazar Markarian 421 in 2002 December and 2003 January. The Astrophysical Journal, 641(2), 740

Schubnell, M. S., Akerlof, C. W., Biller, S., et al. (1996): Very High Energy Gamma-Ray Emission from the Blazar Markarian 421. The Astrophysical Journal, 460, 644
}
\note{See Vignette Section 5.3 for example.}
\keyword{datasets}