% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RuleInduction.R
\name{RI.CN2Rules.RST}
\alias{RI.CN2Rules.RST}
\title{Rule induction using a version of CN2 algorithm}
\usage{
RI.CN2Rules.RST(decision.table, K = 3)
}
\arguments{
\item{decision.table}{an object inheriting from the \code{"DecisionTable"} class, which represents a decision system.
See \code{\link{SF.asDecisionTable}}.}

\item{K}{a positive integer that controls a complexity of the algorithm. In each iteration \code{K} best rule predicates are
extended by all possible descriptors.}
}
\value{
An object of a class \code{"RuleSetRST"}. For details see \code{\link{RI.indiscernibilityBasedRules.RST}}.
}
\description{
An implementation of verions of the famous CN2 algorithm for induction of decision rules, proposed by P.E. Clark and T. Niblett.
}
\examples{
###########################################################
## Example
##############################################################
data(RoughSetData)
wine.data <- RoughSetData$wine.dt
set.seed(13)
wine.data <- wine.data[sample(nrow(wine.data)),]

## Split the data into a training set and a test set,
## 60\% for training and 40\% for testing:
idx <- round(0.6 * nrow(wine.data))
wine.tra <-SF.asDecisionTable(wine.data[1:idx,],
                              decision.attr = 14,
                              indx.nominal = 14)
wine.tst <- SF.asDecisionTable(wine.data[(idx+1):nrow(wine.data), -ncol(wine.data)])

true.classes <- wine.data[(idx+1):nrow(wine.data), ncol(wine.data)]

## discretization:
cut.values <- D.discretization.RST(wine.tra,
                                   type.method = "unsupervised.quantiles",
                                   nOfIntervals = 3)
data.tra <- SF.applyDecTable(wine.tra, cut.values)
data.tst <- SF.applyDecTable(wine.tst, cut.values)

## rule induction from the training set:
rules <- RI.CN2Rules.RST(data.tra, K = 5)
rules

## predicitons for the test set:
pred.vals <- predict(rules, data.tst)

## checking the accuracy of predictions:
mean(pred.vals == true.classes)

}
\references{
P.E. Clark and T. Niblett, "The CN2 Induction algorithm",
Machine Learning, 3, p. 261 - 284 (1986).
}
\seealso{
\code{\link{predict.RuleSetFRST}}, \code{\link{RI.indiscernibilityBasedRules.RST}}, \code{\link{RI.LEM2Rules.RST}},
         \code{\link{RI.AQRules.RST}}.
}
\author{
Andrzej Janusz
}
